/*
 * Decompiled with CFR 0.152.
 */
package fr.loudo.parkourGhost.recordings;

import fr.loudo.parkourGhost.ParkourGhost;
import fr.loudo.parkourGhost.manager.PlayersDataManager;
import fr.loudo.parkourGhost.recordings.RecordingData;
import fr.loudo.parkourGhost.recordings.actions.ActionPlayer;
import fr.loudo.parkourGhost.recordings.actions.ActionType;
import fr.loudo.parkourGhost.recordings.actions.MovementData;
import fr.loudo.parkourGhost.recordings.actions.PlayerPoseChange;
import io.github.a5h73y.parkour.Parkour;
import io.github.a5h73y.parkour.type.player.session.ParkourSession;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Pose;
import org.bukkit.ChatColor;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Recording {
    private String courseName;
    private Player player;
    private RecordingData recordingData;
    private boolean isRecording;
    private int tick;
    private BukkitTask recordTask;

    public Recording(String courseName, Player player) {
        this.courseName = courseName;
        this.player = player;
        this.recordingData = new RecordingData();
    }

    public boolean start() {
        if (this.isRecording) {
            return false;
        }
        this.isRecording = true;
        this.recordingData.getMovementData().clear();
        final ServerPlayer serverPlayer = ((CraftPlayer)this.player).getHandle();
        final AtomicReference<Pose> lastPos = new AtomicReference<Pose>(serverPlayer.getPose());
        this.tick = 0;
        this.recordTask = new BukkitRunnable(){

            public void run() {
                MovementData movementData = MovementData.getMovementDataFromPlayer(Recording.this.player);
                Recording.this.recordingData.getMovementData().add(movementData);
                if (serverPlayer.getPose() != lastPos.get()) {
                    Recording.this.recordingData.getActionsPlayer().put(Recording.this.tick, new PlayerPoseChange(serverPlayer.getPose()));
                }
                lastPos.set(serverPlayer.getPose());
                ++Recording.this.tick;
            }
        }.runTaskTimer((Plugin)ParkourGhost.getPlugin(), 0L, 1L);
        return true;
    }

    public void addAction(ActionType actionType) {
        this.recordingData.getActionsPlayer().put(this.tick, new ActionPlayer(actionType));
    }

    public boolean stop(boolean force) {
        if (!this.isRecording) {
            return false;
        }
        this.recordTask.cancel();
        this.recordTask = null;
        this.isRecording = false;
        if (!force) {
            try {
                ParkourSession pSession = Parkour.getInstance().getParkourSessionManager().getParkourSession(this.player);
                if (Parkour.getInstance().getDatabaseManager().isBestCourseTime(pSession.getCourseName(), pSession.getTimeFinished())) {
                    this.save();
                    this.player.sendMessage(String.valueOf(ChatColor.GREEN) + "New Personal Best. Challenge your ghost with /paghost play " + pSession.getCourseName());
                }
            }
            catch (Exception e) {
                this.player.sendMessage("An unexpected error occurred while saving your position data!");
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public void save() throws IOException {
        PlayersDataManager.writeRecordingData(this.recordingData, this.player, this.courseName);
    }
}

