/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.themes.meteor.widgets;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorGuiTheme;
import meteordevelopment.meteorclient.gui.themes.meteor.MeteorWidget;
import meteordevelopment.meteorclient.gui.utils.AlignmentX;
import meteordevelopment.meteorclient.gui.widgets.pressable.WPressable;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class WMeteorModule
extends WPressable
implements MeteorWidget {
    private final Module module;
    private double titleWidth;
    private double animationProgress1;
    private double animationProgress2;

    public WMeteorModule(Module module) {
        this.module = module;
        this.tooltip = String.format("%1$s (%2$s)\n\n%3$s", module.title, module.name, module.getDescription());
        if (module.isActive()) {
            this.animationProgress1 = 1.0;
            this.animationProgress2 = 1.0;
        } else {
            this.animationProgress1 = 0.0;
            this.animationProgress2 = 0.0;
        }
    }

    @Override
    public double pad() {
        return this.theme.scale(4.0);
    }

    @Override
    protected void onCalculateSize() {
        double offset;
        double pad = this.pad();
        double d = offset = this.module.oneShot ? this.theme.scale(16.0) + pad : 0.0;
        if (this.titleWidth == 0.0) {
            this.titleWidth = this.theme.textWidth(this.module.title);
        }
        this.width = offset + pad + this.titleWidth + pad;
        this.height = pad + this.theme.textHeight() + pad;
    }

    @Override
    protected void onPressed(int button) {
        if (button == 0) {
            this.module.toggle();
        } else if (button == 1) {
            MeteorClient.mc.method_1507((class_437)this.theme.moduleScreen(this.module));
        }
    }

    @Override
    protected void onRender(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        MeteorGuiTheme theme = this.theme();
        double pad = this.pad();
        this.animationProgress1 += delta * 4.0 * (double)(this.module.isActive() || this.mouseOver ? 1 : -1);
        this.animationProgress1 = class_3532.method_15350((double)this.animationProgress1, (double)0.0, (double)1.0);
        this.animationProgress2 += delta * 6.0 * (double)(this.module.isActive() ? 1 : -1);
        this.animationProgress2 = class_3532.method_15350((double)this.animationProgress2, (double)0.0, (double)1.0);
        if (this.module.oneShot) {
            renderer.quad(this.x, this.y, this.width, this.height, theme.oneShotModuleBackground.get());
        }
        if (this.animationProgress1 > 0.0) {
            renderer.quad(this.x, this.y, this.width * this.animationProgress1, this.height, this.module.oneShot ? (Color)theme.oneShotModuleForeground.get() : (Color)theme.moduleBackground.get());
        }
        if (this.animationProgress2 > 0.0) {
            renderer.quad(this.x, this.y + this.height * (1.0 - this.animationProgress2), theme.scale(2.0), this.height * this.animationProgress2, theme.accentColor.get());
        }
        double x = this.x + pad;
        double w = this.width - pad * 2.0;
        if (this.module.oneShot) {
            double size = theme.scale(16.0);
            double offset = size + pad;
            renderer.quad(x, this.y + (this.height - size) / 2.0, size, size, GuiRenderer.ONESHOT, (Color)theme.textColor.get());
            x += offset;
            w -= offset;
        }
        if (theme.moduleAlignment.get() == AlignmentX.Center) {
            x += w / 2.0 - this.titleWidth / 2.0;
        } else if (theme.moduleAlignment.get() == AlignmentX.Right) {
            x += w - this.titleWidth;
        }
        renderer.text(this.module.title, x, this.y + pad, theme.textColor.get(), false);
    }
}

