/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.entity.LivingEntityMoveEvent;
import meteordevelopment.meteorclient.events.entity.player.JumpVelocityMultiplierEvent;
import meteordevelopment.meteorclient.events.entity.player.PlayerMoveEvent;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.FreeLook;
import meteordevelopment.meteorclient.systems.modules.render.Freecam;
import meteordevelopment.meteorclient.systems.modules.render.NoRender;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.entity.fakeplayer.FakePlayerEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1297.class})
public abstract class EntityMixin {
    @ModifyArgs(method={"pushAwayFrom(Lnet/minecraft/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    private void onPushAwayFrom(Args args, class_1297 entity) {
        if (entity instanceof FakePlayerEntity) {
            FakePlayerEntity player = (FakePlayerEntity)entity;
            if (player.doNotPush) {
                args.set(0, (Object)0.0);
                args.set(2, (Object)0.0);
            }
        }
    }

    @ModifyReturnValue(method={"getJumpVelocityMultiplier"}, at={@At(value="RETURN")})
    private float onGetJumpVelocityMultiplier(float original) {
        if (this == MeteorClient.mc.field_1724) {
            JumpVelocityMultiplierEvent event = (JumpVelocityMultiplierEvent)MeteorClient.EVENT_BUS.post((Object)JumpVelocityMultiplierEvent.get());
            return original * event.multiplier;
        }
        return original;
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    private void onMove(class_1313 type, class_243 movement, CallbackInfo info) {
        if (this == MeteorClient.mc.field_1724) {
            MeteorClient.EVENT_BUS.post((Object)PlayerMoveEvent.get(type, movement));
        } else if (this instanceof class_1309) {
            MeteorClient.EVENT_BUS.post((Object)LivingEntityMoveEvent.get((class_1309)this, movement));
        }
    }

    @ModifyReturnValue(method={"isInvisibleTo(Lnet/minecraft/entity/player/PlayerEntity;)Z"}, at={@At(value="RETURN")})
    private boolean isInvisibleToCanceller(boolean original) {
        if (!Utils.canUpdate()) {
            return original;
        }
        if (!Utils.cheatsAllowed()) {
            return original;
        }
        if (Modules.get().get(NoRender.class).noInvisibility()) {
            return false;
        }
        return original;
    }

    @Inject(method={"isGlowing"}, at={@At(value="HEAD")}, cancellable=true)
    private void isGlowing(CallbackInfoReturnable<Boolean> info) {
        if (Modules.get().get(NoRender.class).noGlowing()) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isInvisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsInvisibleTo(class_1657 player, CallbackInfoReturnable<Boolean> info) {
        if (player == null) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"changeLookDirection"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateChangeLookDirection(double cursorDeltaX, double cursorDeltaY, CallbackInfo ci) {
        if (this != MeteorClient.mc.field_1724) {
            return;
        }
        Freecam freecam = Modules.get().get(Freecam.class);
        FreeLook freeLook = Modules.get().get(FreeLook.class);
        if (freecam.isActive()) {
            freecam.changeLookDirection(cursorDeltaX * 0.15, cursorDeltaY * 0.15);
            ci.cancel();
        } else if (freeLook.cameraMode()) {
            freeLook.cameraYaw += (float)(cursorDeltaX / (double)freeLook.sensitivity.get().floatValue());
            freeLook.cameraPitch += (float)(cursorDeltaY / (double)freeLook.sensitivity.get().floatValue());
            if (Math.abs(freeLook.cameraPitch) > 90.0f) {
                freeLook.cameraPitch = freeLook.cameraPitch > 0.0f ? 90.0f : -90.0f;
            }
            ci.cancel();
        }
    }
}

