/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.concurrent.CompletableFuture;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.entity.player.ItemUseCrosshairTargetEvent;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.game.ResolutionChangedEvent;
import meteordevelopment.meteorclient.events.game.ResourcePacksReloadedEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.WidgetScreen;
import meteordevelopment.meteorclient.mixininterface.IMinecraftClient;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.CPSUtils;
import meteordevelopment.meteorclient.utils.misc.MeteorStarscript;
import meteordevelopment.meteorclient.utils.network.OnlinePlayers;
import meteordevelopment.orbit.ICancellable;
import net.minecraft.class_10209;
import net.minecraft.class_1041;
import net.minecraft.class_239;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_315;
import net.minecraft.class_3304;
import net.minecraft.class_437;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.meteordev.starscript.Script;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class}, priority=1001)
public abstract class MinecraftClientMixin
implements IMinecraftClient {
    @Unique
    private boolean doItemUseCalled;
    @Unique
    private boolean rightClick;
    @Unique
    private long lastTime;
    @Unique
    private boolean firstFrame;
    @Shadow
    public class_638 field_1687;
    @Shadow
    @Final
    public class_312 field_1729;
    @Shadow
    @Final
    private class_1041 field_1704;
    @Shadow
    public class_437 field_1755;
    @Shadow
    @Final
    public class_315 field_1690;
    @Shadow
    @Nullable
    public class_636 field_1761;
    @Shadow
    private int field_1752;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Final
    private class_3304 field_1745;
    @Shadow
    @Final
    @Mutable
    private class_276 field_1689;

    @Shadow
    protected abstract void method_1583();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo info) {
        MeteorClient.INSTANCE.onInitializeClient();
        this.firstFrame = true;
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void onPreTick(CallbackInfo info) {
        OnlinePlayers.update();
        this.doItemUseCalled = false;
        class_10209.method_64146().method_15396("asteroid_pre_update");
        MeteorClient.EVENT_BUS.post((Object)TickEvent.Pre.get());
        class_10209.method_64146().method_15407();
        if (this.rightClick && !this.doItemUseCalled && this.field_1761 != null) {
            this.method_1583();
        }
        this.rightClick = false;
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void onTick(CallbackInfo info) {
        class_10209.method_64146().method_15396("asteroid_post_update");
        MeteorClient.EVENT_BUS.post((Object)TickEvent.Post.get());
        class_10209.method_64146().method_15407();
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")})
    private void onAttack(CallbackInfoReturnable<Boolean> cir) {
        CPSUtils.onAttack();
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")})
    private void onDoItemUse(CallbackInfo info) {
        this.doItemUseCalled = true;
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;Z)V"}, at={@At(value="HEAD")})
    private void onDisconnect(class_437 screen, boolean transferring, CallbackInfo info) {
        if (this.field_1687 != null) {
            MeteorClient.EVENT_BUS.post((Object)GameLeftEvent.get());
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetScreen(class_437 screen, CallbackInfo info) {
        if (screen instanceof WidgetScreen) {
            screen.method_16014(this.field_1729.method_1603() * (double)this.field_1704.method_4495(), this.field_1729.method_1604() * (double)this.field_1704.method_4495());
        }
        OpenScreenEvent event = OpenScreenEvent.get(screen);
        MeteorClient.EVENT_BUS.post((ICancellable)event);
        if (event.isCancelled()) {
            info.cancel();
        }
    }

    @ModifyExpressionValue(method={"doItemUse"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;crosshairTarget:Lnet/minecraft/util/hit/HitResult;", ordinal=1)})
    private class_239 doItemUseMinecraftClientCrosshairTargetProxy(class_239 original) {
        return ((ItemUseCrosshairTargetEvent)MeteorClient.EVENT_BUS.post((Object)ItemUseCrosshairTargetEvent.get((class_239)original))).target;
    }

    @ModifyReturnValue(method={"reloadResources(ZLnet/minecraft/client/MinecraftClient$LoadingContext;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    private CompletableFuture<Void> onReloadResourcesNewCompletableFuture(CompletableFuture<Void> original) {
        return original.thenRun(() -> MeteorClient.EVENT_BUS.post((Object)ResourcePacksReloadedEvent.get()));
    }

    @ModifyArg(method={"updateWindowTitle"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/Window;setTitle(Ljava/lang/String;)V"))
    private String setTitle(String original) {
        String title;
        if (Config.get() == null || !Config.get().customWindowTitle.get().booleanValue()) {
            return original;
        }
        String customTitle = Config.get().customWindowTitleText.get();
        Script script = MeteorStarscript.compile(customTitle);
        if (script != null && (title = MeteorStarscript.run(script)) != null) {
            customTitle = title;
        }
        return customTitle;
    }

    @Inject(method={"onResolutionChanged"}, at={@At(value="TAIL")})
    private void onResolutionChanged(CallbackInfo info) {
        MeteorClient.EVENT_BUS.post((Object)ResolutionChangedEvent.get());
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRender(CallbackInfo info) {
        long time = System.currentTimeMillis();
        if (this.firstFrame) {
            this.lastTime = time;
            this.firstFrame = false;
        }
        Utils.frameTime = (double)(time - this.lastTime) / 1000.0;
        this.lastTime = time;
    }

    @Override
    public void meteor$rightClick() {
        this.rightClick = true;
    }

    @Override
    public void meteor$setFramebuffer(class_276 framebuffer) {
        this.field_1689 = framebuffer;
    }
}

