/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.utils.files.StreamUtils;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import net.minecraft.class_148;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import org.apache.commons.io.FilenameUtils;

public abstract class System<T>
implements ISerializable<T> {
    private final String name;
    private File file;
    protected boolean isFirstInit;
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);

    public System(String name) {
        this.name = name;
        if (name != null) {
            this.file = new File(MeteorClient.FOLDER, name + ".nbt");
            this.isFirstInit = !this.file.exists();
        }
    }

    public void init() {
    }

    public void save(File folder) {
        File file = this.getFile();
        if (file == null) {
            return;
        }
        class_2487 tag = this.toTag();
        if (tag == null) {
            return;
        }
        try {
            File tempFile = File.createTempFile("asteroid", file.getName());
            class_2507.method_10630((class_2487)tag, (Path)tempFile.toPath());
            if (folder != null) {
                file = new File(folder, file.getName());
            }
            file.getParentFile().mkdirs();
            try {
                Files.move(tempFile.toPath(), file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException e) {
                StreamUtils.copy(tempFile, file);
            }
            tempFile.delete();
        }
        catch (IOException e) {
            MeteorClient.LOG.error("Error saving {}. Possibly corrupted?", (Object)this.name, (Object)e);
        }
    }

    public void save() {
        this.save(null);
    }

    public void load(File folder) {
        block8: {
            File file = this.getFile();
            if (file == null) {
                return;
            }
            try {
                if (folder != null) {
                    file = new File(folder, file.getName());
                }
                if (!file.exists()) break block8;
                try {
                    this.fromTag(class_2507.method_10633((Path)file.toPath()));
                }
                catch (class_148 e) {
                    String backupName = FilenameUtils.removeExtension((String)file.getName()) + "-" + ZonedDateTime.now().format(DATE_TIME_FORMATTER) + ".backup.nbt";
                    File backup = new File(file.getParentFile(), backupName);
                    try {
                        Files.move(file.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                    }
                    catch (AtomicMoveNotSupportedException ex) {
                        StreamUtils.copy(file, backup);
                    }
                    MeteorClient.LOG.error("Error loading {}. Possibly corrupted?", (Object)this.name, (Object)e);
                    MeteorClient.LOG.info("Saved settings backup to '{}'.", (Object)backup);
                }
            }
            catch (IOException e) {
                MeteorClient.LOG.error("Error loading {}. Possibly corrupted?", (Object)this.name, (Object)e);
            }
        }
    }

    public void load() {
        this.load(null);
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public class_2487 toTag() {
        return null;
    }

    @Override
    public T fromTag(class_2487 tag) {
        return null;
    }
}

