/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules;

import java.util.Objects;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.addons.AddonManager;
import meteordevelopment.meteorclient.addons.MeteorAddon;
import meteordevelopment.meteorclient.gui.GuiTheme;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.settings.Settings;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.systems.modules.Category;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.ISerializable;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public abstract class Module
implements ISerializable<Module>,
Comparable<Module> {
    protected final class_310 mc;
    public final Category category;
    public final String name;
    public String title;
    public final String description;
    public final String[] aliases;
    public final Color color;
    public final MeteorAddon addon;
    public final Settings settings = new Settings();
    private boolean active;
    public boolean disabled;
    public boolean isCheat;
    public boolean oneShot = false;
    public boolean serialize = true;
    public boolean runInMainMenu = false;
    public boolean autoSubscribe = true;
    public final Keybind keybind = Keybind.none();
    public boolean toggleOnBindRelease = false;
    public boolean chatFeedback = true;
    public boolean favorite = false;

    public Module(Category category, String name, String description, String ... aliases) {
        if (name.contains(" ")) {
            MeteorClient.LOG.warn("Module '{}' contains invalid characters in its name making it incompatible with Meteor Client commands.", (Object)name);
        }
        this.mc = class_310.method_1551();
        this.category = category;
        this.name = name;
        this.title = Utils.nameToTitle(name);
        this.description = description;
        this.aliases = aliases;
        this.color = Color.fromHsv(Utils.random(0.0, 360.0), 0.35, 1.0);
        String classname = this.getClass().getName();
        for (MeteorAddon addon : AddonManager.ADDONS) {
            if (!classname.startsWith(addon.getPackage())) continue;
            this.addon = addon;
            return;
        }
        this.addon = null;
    }

    public Module(Category category, String name, String desc) {
        this(category, name, desc, new String[0]);
    }

    public WWidget getWidget(GuiTheme theme) {
        return null;
    }

    public void onActivate() {
    }

    public void onDeactivate() {
    }

    public void activate() {
        this.activate(true);
    }

    public void activate(boolean callback) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.active) {
            return;
        }
        if (this.oneShot) {
            if (callback) {
                this.oneshotActivate();
            }
        } else {
            this.active = true;
            Modules.get().addActive(this);
            if (this.runInMainMenu || Utils.canUpdate()) {
                if (this.autoSubscribe) {
                    MeteorClient.EVENT_BUS.subscribe((Object)this);
                }
                if (callback) {
                    this.onActivate();
                }
            }
        }
        this.settings.onActivated();
    }

    private void oneshotActivate() {
        if (!this.runInMainMenu && !Utils.canUpdate()) {
            return;
        }
        this.onActivate();
    }

    public void deactivate() {
        this.deactivate(true);
    }

    public void deactivate(boolean callback) {
        if (this.oneShot) {
            return;
        }
        if (!this.active) {
            return;
        }
        if (this.runInMainMenu || Utils.canUpdate()) {
            if (this.autoSubscribe) {
                MeteorClient.EVENT_BUS.unsubscribe((Object)this);
            }
            if (callback) {
                this.onDeactivate();
            }
        }
        this.active = false;
        Modules.get().removeActive(this);
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean callback) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.active) {
            this.activate(callback);
        } else {
            this.deactivate(callback);
        }
    }

    public void sendToggledMsg() {
        if (Config.get().chatFeedback.get().booleanValue() && this.chatFeedback) {
            ChatUtils.forceNextPrefixClass(this.getClass());
            ChatUtils.sendMsg(this.hashCode(), class_124.field_1080, "Toggled (highlight)%s(default) %s(default).", this.title, this.isActive() ? String.valueOf(class_124.field_1060) + "on" : String.valueOf(class_124.field_1061) + "off");
        }
    }

    public void info(class_2561 message) {
        ChatUtils.forceNextPrefixClass(this.getClass());
        ChatUtils.sendMsg(this.title, message);
    }

    public void info(String message, Object ... args) {
        ChatUtils.forceNextPrefixClass(this.getClass());
        ChatUtils.infoPrefix(this.title, message, args);
    }

    public void warning(String message, Object ... args) {
        ChatUtils.forceNextPrefixClass(this.getClass());
        ChatUtils.warningPrefix(this.title, message, args);
    }

    public void error(String message, Object ... args) {
        ChatUtils.forceNextPrefixClass(this.getClass());
        ChatUtils.errorPrefix(this.title, message, args);
    }

    public boolean isActive() {
        if (!this.isEnabled()) {
            return false;
        }
        return this.active;
    }

    public boolean isEnabled() {
        if (this.disabled) {
            return false;
        }
        if (!this.isCheat) {
            return true;
        }
        return Utils.cheatsAllowed();
    }

    public String getInfoString() {
        return null;
    }

    public String getDescription() {
        if (this.isCheat && !MeteorClient.BYPASS_CHEATS) {
            return "(Cheat) " + this.description;
        }
        return this.description;
    }

    @Override
    public class_2487 toTag() {
        if (!this.serialize) {
            return null;
        }
        class_2487 tag = new class_2487();
        tag.method_10582("name", this.name);
        tag.method_10566("keybind", (class_2520)this.keybind.toTag());
        tag.method_10556("toggleOnKeyRelease", this.toggleOnBindRelease);
        tag.method_10556("chatFeedback", this.chatFeedback);
        tag.method_10556("favorite", this.favorite);
        tag.method_10566("settings", (class_2520)this.settings.toTag());
        tag.method_10556("active", this.active);
        return tag;
    }

    @Override
    public Module fromTag(class_2487 tag) {
        boolean active;
        this.keybind.fromTag(tag.method_68568("keybind"));
        this.toggleOnBindRelease = tag.method_68566("toggleOnKeyRelease", false);
        this.chatFeedback = !tag.method_10545("chatFeedback") || tag.method_68566("chatFeedback", false);
        this.favorite = tag.method_68566("favorite", false);
        class_2520 settingsTag = tag.method_10580("settings");
        if (settingsTag instanceof class_2487) {
            this.settings.fromTag((class_2487)settingsTag);
        }
        if ((active = tag.method_68566("active", false)) != this.isActive()) {
            this.toggle();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Module module = (Module)o;
        return Objects.equals(this.name, module.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public int compareTo(@NotNull Module o) {
        return this.name.compareTo(o.name);
    }
}

