/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.game.GameJoinedEvent;
import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.meteor.ActiveModulesChangedEvent;
import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.ModuleBindChangedEvent;
import meteordevelopment.meteorclient.events.meteor.MouseClickEvent;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.System;
import meteordevelopment.meteorclient.systems.Systems;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Category;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.misc.AutoReconnect;
import meteordevelopment.meteorclient.systems.modules.misc.BetterChat;
import meteordevelopment.meteorclient.systems.modules.misc.DiscordPresence;
import meteordevelopment.meteorclient.systems.modules.misc.InventoryTweaks;
import meteordevelopment.meteorclient.systems.modules.misc.SoundBlocker;
import meteordevelopment.meteorclient.systems.modules.player.AutoClicker;
import meteordevelopment.meteorclient.systems.modules.player.AutoReplenish;
import meteordevelopment.meteorclient.systems.modules.player.AutoRespawn;
import meteordevelopment.meteorclient.systems.modules.player.AutoTool;
import meteordevelopment.meteorclient.systems.modules.player.FakePlayer;
import meteordevelopment.meteorclient.systems.modules.player.MiddleClickExtra;
import meteordevelopment.meteorclient.systems.modules.player.NameProtect;
import meteordevelopment.meteorclient.systems.modules.player.NoInteract;
import meteordevelopment.meteorclient.systems.modules.player.NoMiningTrace;
import meteordevelopment.meteorclient.systems.modules.player.Portals;
import meteordevelopment.meteorclient.systems.modules.player.Rotation;
import meteordevelopment.meteorclient.systems.modules.render.BetterTab;
import meteordevelopment.meteorclient.systems.modules.render.BetterTooltips;
import meteordevelopment.meteorclient.systems.modules.render.BlockSelection;
import meteordevelopment.meteorclient.systems.modules.render.Blur;
import meteordevelopment.meteorclient.systems.modules.render.BossStack;
import meteordevelopment.meteorclient.systems.modules.render.Breadcrumbs;
import meteordevelopment.meteorclient.systems.modules.render.BreakIndicators;
import meteordevelopment.meteorclient.systems.modules.render.CameraTweaks;
import meteordevelopment.meteorclient.systems.modules.render.EntityOwner;
import meteordevelopment.meteorclient.systems.modules.render.FreeLook;
import meteordevelopment.meteorclient.systems.modules.render.Freecam;
import meteordevelopment.meteorclient.systems.modules.render.Fullbright;
import meteordevelopment.meteorclient.systems.modules.render.HandView;
import meteordevelopment.meteorclient.systems.modules.render.ItemHighlight;
import meteordevelopment.meteorclient.systems.modules.render.ItemPhysics;
import meteordevelopment.meteorclient.systems.modules.render.LightOverlay;
import meteordevelopment.meteorclient.systems.modules.render.Nametags;
import meteordevelopment.meteorclient.systems.modules.render.NoRender;
import meteordevelopment.meteorclient.systems.modules.render.Tracers;
import meteordevelopment.meteorclient.systems.modules.render.Trail;
import meteordevelopment.meteorclient.systems.modules.render.UnfocusedCPU;
import meteordevelopment.meteorclient.systems.modules.render.WaypointsModule;
import meteordevelopment.meteorclient.systems.modules.render.Xray;
import meteordevelopment.meteorclient.systems.modules.render.Zoom;
import meteordevelopment.meteorclient.systems.modules.render.blockesp.BlockESP;
import meteordevelopment.meteorclient.systems.modules.render.marker.Marker;
import meteordevelopment.meteorclient.systems.modules.world.Ambience;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.misc.ValueComparableMap;
import meteordevelopment.meteorclient.utils.misc.input.Input;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class Modules
extends System<Modules> {
    private static final List<Category> CATEGORIES = new ArrayList<Category>();
    private final Map<Class<? extends Module>, Module> moduleInstances = new Reference2ReferenceOpenHashMap();
    private final Map<Category, List<Module>> groups = new Reference2ReferenceOpenHashMap();
    private final List<Module> active = new ArrayList<Module>();
    private Module moduleToBind;
    private boolean awaitingKeyRelease = false;

    public Modules() {
        super("modules");
    }

    public static Modules get() {
        return Systems.get(Modules.class);
    }

    @Override
    public void init() {
        this.initPlayer();
        this.initRender();
        this.initMisc();
        this.blacklist();
    }

    @Override
    public void load(File folder) {
        for (Module module : this.getAll()) {
            for (SettingGroup group : module.settings) {
                for (Setting<?> setting : group) {
                    setting.reset();
                }
            }
        }
        super.load(folder);
    }

    public void sortModules() {
        for (List<Module> modules : this.groups.values()) {
            modules.sort(Comparator.comparing(o -> o.title));
        }
    }

    public static void registerCategory(Category category) {
        if (!Categories.REGISTERING) {
            throw new RuntimeException("Modules.registerCategory - Cannot register category outside of onRegisterCategories callback.");
        }
        CATEGORIES.add(category);
    }

    public static Iterable<Category> loopCategories() {
        return CATEGORIES;
    }

    public <T extends Module> T get(Class<T> klass) {
        return (T)this.moduleInstances.get(klass);
    }

    public Module get(String name) {
        for (Module module : this.moduleInstances.values()) {
            if (!module.name.equalsIgnoreCase(name)) continue;
            return module;
        }
        return null;
    }

    public boolean isActive(Class<? extends Module> klass) {
        Module module = this.get(klass);
        return module != null && module.isActive();
    }

    public List<Module> getGroup(Category category) {
        return this.groups.computeIfAbsent(category, category1 -> new ArrayList());
    }

    public Stream<Module> getGroupEnabled(Category category) {
        return this.getGroup(category).stream().filter(module -> module.isEnabled());
    }

    public boolean groupHasEnabledModules(Category category) {
        return this.getGroupEnabled(category).count() > 0L;
    }

    public Collection<Module> getAll() {
        return this.moduleInstances.values();
    }

    public Stream<Module> getAllEnabled() {
        return this.moduleInstances.values().stream().filter(module -> module.isEnabled());
    }

    public int getCount() {
        return this.moduleInstances.size();
    }

    public int getCountEnabled() {
        return Math.toIntExact(this.getAllEnabled().count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Module> getActive() {
        List<Module> list = this.active;
        synchronized (list) {
            return this.active;
        }
    }

    public Set<Module> searchTitles(String text) {
        ValueComparableMap modules = new ValueComparableMap(Comparator.naturalOrder());
        for (Module module : this.moduleInstances.values()) {
            if (!module.isEnabled()) continue;
            int score = Utils.searchLevenshteinDefault(module.title, text, false);
            if (Config.get().moduleAliases.get().booleanValue()) {
                for (String alias : module.aliases) {
                    int aliasScore = Utils.searchLevenshteinDefault(alias, text, false);
                    if (aliasScore >= score) continue;
                    score = aliasScore;
                }
            }
            modules.put(module, modules.getOrDefault(module, 0) + score);
        }
        return modules.keySet();
    }

    public Set<Module> searchSettingTitles(String text) {
        ValueComparableMap modules = new ValueComparableMap(Comparator.naturalOrder());
        for (Module module : this.moduleInstances.values()) {
            if (!module.isEnabled()) continue;
            int lowest = Integer.MAX_VALUE;
            for (SettingGroup sg : module.settings) {
                for (Setting<?> setting : sg) {
                    int score = Utils.searchLevenshteinDefault(setting.title, text, false);
                    if (score >= lowest) continue;
                    lowest = score;
                }
            }
            modules.put(module, modules.getOrDefault(module, 0) + lowest);
        }
        return modules.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActive(Module module) {
        List<Module> list = this.active;
        synchronized (list) {
            if (!this.active.contains(module)) {
                this.active.add(module);
                MeteorClient.EVENT_BUS.post((Object)ActiveModulesChangedEvent.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActive(Module module) {
        List<Module> list = this.active;
        synchronized (list) {
            if (this.active.remove(module)) {
                MeteorClient.EVENT_BUS.post((Object)ActiveModulesChangedEvent.get());
            }
        }
    }

    public void setModuleToBind(Module moduleToBind) {
        this.moduleToBind = moduleToBind;
    }

    public void awaitKeyRelease() {
        this.awaitingKeyRelease = true;
    }

    public boolean isBinding() {
        return this.moduleToBind != null;
    }

    @EventHandler(priority=200)
    private void onKeyBinding(KeyEvent event) {
        if (event.action == KeyAction.Release && this.onBinding(true, event.key(), event.modifiers())) {
            event.cancel();
        }
    }

    @EventHandler(priority=200)
    private void onButtonBinding(MouseClickEvent event) {
        if (event.action == KeyAction.Release && this.onBinding(false, event.button(), 0)) {
            event.cancel();
        }
    }

    private boolean onBinding(boolean isKey, int value, int modifiers) {
        if (!this.isBinding()) {
            return false;
        }
        if (this.awaitingKeyRelease) {
            if (!isKey || value != 257 && value != 335) {
                return false;
            }
            this.awaitingKeyRelease = false;
            return false;
        }
        if (this.moduleToBind.keybind.canBindTo(isKey, value, modifiers)) {
            this.moduleToBind.keybind.set(isKey, value, modifiers);
            this.moduleToBind.info("Bound to (highlight)%s(default).", this.moduleToBind.keybind);
        } else if (value == 256) {
            this.moduleToBind.keybind.set(Keybind.none());
            this.moduleToBind.info("Removed bind.", new Object[0]);
        } else {
            return false;
        }
        MeteorClient.EVENT_BUS.post((Object)ModuleBindChangedEvent.get(this.moduleToBind));
        this.moduleToBind = null;
        return true;
    }

    @EventHandler(priority=100)
    private void onKey(KeyEvent event) {
        if (event.action == KeyAction.Repeat) {
            return;
        }
        this.onAction(true, event.key(), event.modifiers(), event.action == KeyAction.Press);
    }

    @EventHandler(priority=100)
    private void onMouseClick(MouseClickEvent event) {
        if (event.action == KeyAction.Repeat) {
            return;
        }
        this.onAction(false, event.button(), 0, event.action == KeyAction.Press);
    }

    private void onAction(boolean isKey, int value, int modifiers, boolean isPress) {
        if (MeteorClient.mc.field_1755 != null || Input.isKeyPressed(292)) {
            return;
        }
        for (Module module : this.moduleInstances.values()) {
            if (!module.keybind.matches(isKey, value, modifiers) || !isPress && (!module.toggleOnBindRelease || !module.isActive())) continue;
            module.toggle();
            module.sendToggledMsg();
        }
    }

    @EventHandler(priority=201)
    private void onOpenScreen(OpenScreenEvent event) {
        if (!Utils.canUpdate()) {
            return;
        }
        for (Module module : this.moduleInstances.values()) {
            if (!module.toggleOnBindRelease || !module.isActive()) continue;
            module.toggle();
            module.sendToggledMsg();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onGameJoined(GameJoinedEvent event) {
        List<Module> list = this.active;
        synchronized (list) {
            for (Module module : this.getAll()) {
                if (!module.isActive() || module.runInMainMenu) continue;
                MeteorClient.EVENT_BUS.subscribe((Object)module);
                module.onActivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        List<Module> list = this.active;
        synchronized (list) {
            for (Module module : this.getAll()) {
                if (!module.isActive() || module.runInMainMenu) continue;
                MeteorClient.EVENT_BUS.unsubscribe((Object)module);
                module.onDeactivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAll() {
        List<Module> list = this.active;
        synchronized (list) {
            for (Module module : this.getAll()) {
                if (!module.isActive()) continue;
                module.toggle();
            }
        }
    }

    @Override
    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        class_2499 modulesTag = new class_2499();
        for (Module module : this.getAll()) {
            class_2487 moduleTag = module.toTag();
            if (moduleTag == null) continue;
            modulesTag.add((Object)moduleTag);
        }
        tag.method_10566("modules", (class_2520)modulesTag);
        return tag;
    }

    @Override
    public Modules fromTag(class_2487 tag) {
        this.disableAll();
        class_2499 modulesTag = tag.method_68569("modules");
        for (class_2520 moduleTagI : modulesTag) {
            class_2487 moduleTag = (class_2487)moduleTagI;
            Module module = this.get(moduleTag.method_68564("name", ""));
            if (module == null) continue;
            module.fromTag(moduleTag);
        }
        return this;
    }

    public void add(Module module) {
        if (!CATEGORIES.contains(module.category)) {
            throw new RuntimeException("Modules.addModule - Module's category was not registered.");
        }
        AtomicReference removedModule = new AtomicReference();
        if (this.moduleInstances.values().removeIf(module1 -> {
            if (module1.name.equals(module.name)) {
                removedModule.set(module1);
                module1.settings.unregisterColorSettings();
                return true;
            }
            return false;
        })) {
            this.getGroup(((Module)removedModule.get()).category).remove(removedModule.get());
        }
        this.moduleInstances.put(module.getClass(), module);
        this.getGroup(module.category).add(module);
        module.settings.registerColorSettings(module);
    }

    public void addDisabled(Module module) {
        module.disabled = true;
        this.add(module);
    }

    public void addCheat(Module module) {
        module.isCheat = true;
        this.add(module);
    }

    private void initPlayer() {
        this.add(new AutoReplenish());
        this.add(new AutoRespawn());
        this.add(new AutoTool());
        this.add(new FakePlayer());
        this.add(new MiddleClickExtra());
        this.add(new NameProtect());
        this.add(new NoInteract());
        this.add(new NoMiningTrace());
        this.add(new Portals());
        this.add(new Rotation());
    }

    private void initRender() {
        this.add(new BetterTab());
        this.add(new BetterTooltips());
        this.addCheat(new BlockESP());
        this.add(new BlockSelection());
        this.add(new BossStack());
        this.add(new Breadcrumbs());
        this.add(new BreakIndicators());
        this.addCheat(new CameraTweaks());
        this.add(new EntityOwner());
        this.addCheat(new Freecam());
        this.add(new FreeLook());
        this.add(new Fullbright());
        this.add(new HandView());
        this.add(new ItemHighlight());
        this.add(new ItemPhysics());
        this.add(new LightOverlay());
        this.add(new Marker());
        this.addCheat(new Nametags());
        this.add(new NoRender());
        this.addCheat(new Tracers());
        this.add(new Trail());
        this.add(new UnfocusedCPU());
        this.add(new WaypointsModule());
        this.addCheat(new Xray());
        this.add(new Zoom());
        this.add(new Blur());
    }

    private void initMisc() {
        this.add(new AutoClicker());
        this.add(new AutoReconnect());
        this.add(new BetterChat());
        this.add(new DiscordPresence());
        this.add(new SoundBlocker());
        this.add(new InventoryTweaks());
        this.add(new Ambience());
    }

    private void blacklist() {
        List<String> lines;
        File blacklistFile = new File(MeteorClient.FOLDER.getPath() + "/blacklist.txt");
        if (!blacklistFile.exists()) {
            return;
        }
        try {
            lines = Files.readAllLines(blacklistFile.toPath());
        }
        catch (IOException exception) {
            return;
        }
        lines.forEach(line -> {
            Module module;
            if (line.trim().startsWith("#")) {
                return;
            }
            boolean isCheat = false;
            String name = line;
            if (line.endsWith("*")) {
                isCheat = true;
                name = line.substring(0, line.length() - 2);
            }
            if ((module = this.get(name)) == null) {
                return;
            }
            if (isCheat) {
                module.isCheat = true;
            } else {
                module.disabled = true;
            }
        });
    }
}

