/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc;

import java.lang.runtime.SwitchBootstraps;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.mixin.ClientPlayerInteractionManagerAccessor;
import meteordevelopment.meteorclient.mixin.MinecraftClientAccessor;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.systems.config.Config;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.utils.PreInit;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.CPSUtils;
import meteordevelopment.meteorclient.utils.misc.HorizontalDirection;
import meteordevelopment.meteorclient.utils.misc.Names;
import meteordevelopment.meteorclient.utils.player.ChatUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.world.Dimension;
import meteordevelopment.meteorclient.utils.world.TickRate;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2799;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;
import org.meteordev.starscript.Script;
import org.meteordev.starscript.Section;
import org.meteordev.starscript.StandardLib;
import org.meteordev.starscript.Starscript;
import org.meteordev.starscript.compiler.Compiler;
import org.meteordev.starscript.compiler.Parser;
import org.meteordev.starscript.utils.Error;
import org.meteordev.starscript.utils.StarscriptError;
import org.meteordev.starscript.value.Value;
import org.meteordev.starscript.value.ValueMap;

public class MeteorStarscript {
    public static Starscript ss = new Starscript();
    private static final class_2338.class_2339 BP = new class_2338.class_2339();
    private static final StringBuilder SB = new StringBuilder();
    private static long lastRequestedStatsTime = 0L;

    @PreInit
    public static void init() {
        StandardLib.init((Starscript)ss);
        ss.set("mc_version", class_155.method_16673().comp_4025());
        ss.set("fps", () -> Value.number((double)MinecraftClientAccessor.meteor$getFps()));
        ss.set("ping", MeteorStarscript::ping);
        ss.set("time", () -> Value.string((String)LocalTime.now().format(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT))));
        ss.set("cps", () -> Value.number((double)CPSUtils.getCpsAverage()));
        ss.set("meteor", new ValueMap().set("name", MeteorClient.NAME).set("version", (String)(MeteorClient.VERSION != null ? (MeteorClient.BUILD_NUMBER.isEmpty() ? MeteorClient.VERSION.toString() : String.valueOf(MeteorClient.VERSION) + " " + MeteorClient.BUILD_NUMBER) : "")).set("modules", () -> Value.number((double)Modules.get().getAll().size())).set("active_modules", () -> Value.number((double)Modules.get().getActive().size())).set("is_module_active", MeteorStarscript::isModuleActive).set("get_module_info", MeteorStarscript::getModuleInfo).set("get_module_setting", MeteorStarscript::getModuleSetting).set("prefix", MeteorStarscript::getMeteorPrefix));
        ss.set("camera", new ValueMap().set("pos", new ValueMap().set("_toString", () -> MeteorStarscript.posString(false, true)).set("x", () -> Value.number((double)MeteorClient.mc.field_1773.method_19418().method_19326().field_1352)).set("y", () -> Value.number((double)MeteorClient.mc.field_1773.method_19418().method_19326().field_1351)).set("z", () -> Value.number((double)MeteorClient.mc.field_1773.method_19418().method_19326().field_1350))).set("opposite_dim_pos", new ValueMap().set("_toString", () -> MeteorStarscript.posString(true, true)).set("x", () -> MeteorStarscript.oppositeX(true)).set("y", () -> Value.number((double)MeteorClient.mc.field_1773.method_19418().method_19326().field_1351)).set("z", () -> MeteorStarscript.oppositeZ(true))).set("yaw", () -> MeteorStarscript.yaw(true)).set("pitch", () -> MeteorStarscript.pitch(true)).set("direction", () -> MeteorStarscript.direction(true)));
        ss.set("player", new ValueMap().set("_toString", () -> Value.string((String)MeteorClient.mc.method_1548().method_1676())).set("health", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? (double)MeteorClient.mc.field_1724.method_6032() : 0.0))).set("absorption", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? (double)MeteorClient.mc.field_1724.method_6067() : 0.0))).set("hunger", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? (double)MeteorClient.mc.field_1724.method_7344().method_7586() : 0.0))).set("saturation", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? (double)MeteorClient.mc.field_1724.method_7344().method_7589() : 0.0))).set("speed", () -> Value.number((double)Utils.getPlayerSpeed().method_37267())).set("speed_all", new ValueMap().set("_toString", () -> Value.string((String)(MeteorClient.mc.field_1724 != null ? Utils.getPlayerSpeed().toString() : ""))).set("x", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? Utils.getPlayerSpeed().field_1352 : 0.0))).set("y", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? Utils.getPlayerSpeed().field_1351 : 0.0))).set("z", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? Utils.getPlayerSpeed().field_1350 : 0.0)))).set("breaking_progress", () -> Value.number((double)(MeteorClient.mc.field_1761 != null ? (double)((ClientPlayerInteractionManagerAccessor)MeteorClient.mc.field_1761).meteor$getBreakingProgress() : 0.0))).set("biome", MeteorStarscript::biome).set("dimension", () -> Value.string((String)PlayerUtils.getDimension().name())).set("opposite_dimension", () -> Value.string((String)PlayerUtils.getDimension().opposite().name())).set("gamemode", () -> PlayerUtils.getGameMode() != null ? Value.string((String)StringUtils.capitalize((String)PlayerUtils.getGameMode().method_8381())) : Value.null_()).set("pos", new ValueMap().set("_toString", () -> MeteorStarscript.posString(false, false)).set("x", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_23317() : 0.0))).set("y", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_23318() : 0.0))).set("z", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_23321() : 0.0)))).set("opposite_dim_pos", new ValueMap().set("_toString", () -> MeteorStarscript.posString(true, false)).set("x", () -> MeteorStarscript.oppositeX(false)).set("y", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_23318() : 0.0))).set("z", () -> MeteorStarscript.oppositeZ(false))).set("yaw", () -> MeteorStarscript.yaw(false)).set("pitch", () -> MeteorStarscript.pitch(false)).set("direction", () -> MeteorStarscript.direction(false)).set("hand", () -> MeteorClient.mc.field_1724 != null ? MeteorStarscript.wrap(MeteorClient.mc.field_1724.method_6047()) : Value.null_()).set("offhand", () -> MeteorClient.mc.field_1724 != null ? MeteorStarscript.wrap(MeteorClient.mc.field_1724.method_6079()) : Value.null_()).set("hand_or_offhand", MeteorStarscript::handOrOffhand).set("get_item", MeteorStarscript::getItem).set("count_items", MeteorStarscript::countItems).set("xp", new ValueMap().set("level", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? (double)MeteorClient.mc.field_1724.field_7520 : 0.0))).set("progress", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? (double)MeteorClient.mc.field_1724.field_7510 : 0.0))).set("total", () -> Value.number((double)(MeteorClient.mc.field_1724 != null ? (double)MeteorClient.mc.field_1724.field_7495 : 0.0)))).set("has_potion_effect", MeteorStarscript::hasPotionEffect).set("get_potion_effect", MeteorStarscript::getPotionEffect).set("get_stat", MeteorStarscript::getStat));
        ss.set("crosshair_target", new ValueMap().set("type", MeteorStarscript::crosshairType).set("value", MeteorStarscript::crosshairValue));
        ss.set("server", new ValueMap().set("_toString", () -> Value.string((String)Utils.getWorldName())).set("tps", () -> Value.number((double)TickRate.INSTANCE.getTickRate())).set("time", () -> Value.string((String)Utils.getWorldTime())).set("player_count", () -> Value.number((double)(MeteorClient.mc.method_1562() != null ? (double)MeteorClient.mc.method_1562().method_2880().size() : 0.0))).set("difficulty", () -> Value.string((String)(MeteorClient.mc.field_1687 != null ? MeteorClient.mc.field_1687.method_8407().method_5460() : ""))));
    }

    public static Script compile(String source) {
        Parser.Result result = Parser.parse((String)source);
        if (result.hasErrors()) {
            for (Error error : result.errors) {
                MeteorStarscript.printChatError(error);
            }
            return null;
        }
        return Compiler.compile((Parser.Result)result);
    }

    public static Section runSection(Script script, StringBuilder sb) {
        try {
            return ss.run(script, sb);
        }
        catch (StarscriptError error) {
            MeteorStarscript.printChatError(error);
            return null;
        }
    }

    public static String run(Script script, StringBuilder sb) {
        Section section = MeteorStarscript.runSection(script, sb);
        return section != null ? section.toString() : null;
    }

    public static Section runSection(Script script) {
        return MeteorStarscript.runSection(script, new StringBuilder());
    }

    public static String run(Script script) {
        return MeteorStarscript.run(script, new StringBuilder());
    }

    public static void printChatError(int i, Error error) {
        String caller = MeteorStarscript.getCallerName();
        if (caller != null) {
            if (i != -1) {
                ChatUtils.errorPrefix("Starscript", "%d, %d '%c': %s (from %s)", i, error.character, Character.valueOf(error.ch), error.message, caller);
            } else {
                ChatUtils.errorPrefix("Starscript", "%d '%c': %s (from %s)", error.character, Character.valueOf(error.ch), error.message, caller);
            }
        } else if (i != -1) {
            ChatUtils.errorPrefix("Starscript", "%d, %d '%c': %s", i, error.character, Character.valueOf(error.ch), error.message);
        } else {
            ChatUtils.errorPrefix("Starscript", "%d '%c': %s", error.character, Character.valueOf(error.ch), error.message);
        }
    }

    public static void printChatError(Error error) {
        MeteorStarscript.printChatError(-1, error);
    }

    public static void printChatError(StarscriptError e) {
        String caller = MeteorStarscript.getCallerName();
        if (caller != null) {
            ChatUtils.errorPrefix("Starscript", "%s (from %s)", e.getMessage(), caller);
        } else {
            ChatUtils.errorPrefix("Starscript", "%s", e.getMessage());
        }
    }

    private static String getCallerName() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length == 0) {
            return null;
        }
        for (int i = 1; i < elements.length; ++i) {
            String name = elements[i].getClassName();
            if (name.startsWith(Starscript.class.getPackageName()) || name.equals(MeteorStarscript.class.getName())) continue;
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return null;
    }

    private static Value hasPotionEffect(Starscript ss, int argCount) {
        if (argCount < 1) {
            ss.error("player.has_potion_effect() requires 1 argument, got %d.", new Object[]{argCount});
        }
        if (MeteorClient.mc.field_1724 == null) {
            return Value.bool((boolean)false);
        }
        class_2960 name = MeteorStarscript.popIdentifier(ss, "First argument to player.has_potion_effect() needs to a string.");
        Optional effect = class_7923.field_41174.method_10223(name);
        if (effect.isEmpty()) {
            return Value.bool((boolean)false);
        }
        class_1293 effectInstance = MeteorClient.mc.field_1724.method_6112((class_6880)effect.get());
        return Value.bool((effectInstance != null ? 1 : 0) != 0);
    }

    private static Value getPotionEffect(Starscript ss, int argCount) {
        if (argCount < 1) {
            ss.error("player.get_potion_effect() requires 1 argument, got %d.", new Object[]{argCount});
        }
        if (MeteorClient.mc.field_1724 == null) {
            return Value.null_();
        }
        class_2960 name = MeteorStarscript.popIdentifier(ss, "First argument to player.get_potion_effect() needs to a string.");
        Optional effect = class_7923.field_41174.method_10223(name);
        if (effect.isEmpty()) {
            return Value.null_();
        }
        class_1293 effectInstance = MeteorClient.mc.field_1724.method_6112((class_6880)effect.get());
        if (effectInstance == null) {
            return Value.null_();
        }
        return MeteorStarscript.wrap(effectInstance);
    }

    private static Value getStat(Starscript ss, int argCount) {
        if (argCount < 1) {
            ss.error("player.get_stat() requires 1 argument, got %d.", new Object[]{argCount});
        }
        if (MeteorClient.mc.field_1724 == null) {
            return Value.number((double)0.0);
        }
        long time = System.currentTimeMillis();
        if ((double)(time - lastRequestedStatsTime) / 1000.0 >= 1.0 && MeteorClient.mc.method_1562() != null) {
            MeteorClient.mc.method_1562().method_52787((class_2596)new class_2799(class_2799.class_2800.field_12775));
            lastRequestedStatsTime = time;
        }
        String type = argCount > 1 ? ss.popString("First argument to player.get_stat() needs to be a string.") : "custom";
        class_2960 name = MeteorStarscript.popIdentifier(ss, (argCount > 1 ? "Second" : "First") + " argument to player.get_stat() needs to be a string.");
        class_3445 stat = switch (type) {
            case "mined" -> class_3468.field_15427.method_14956((Object)((class_2248)class_7923.field_41175.method_63535(name)));
            case "crafted" -> class_3468.field_15370.method_14956((Object)((class_1792)class_7923.field_41178.method_63535(name)));
            case "used" -> class_3468.field_15372.method_14956((Object)((class_1792)class_7923.field_41178.method_63535(name)));
            case "broken" -> class_3468.field_15383.method_14956((Object)((class_1792)class_7923.field_41178.method_63535(name)));
            case "picked_up" -> class_3468.field_15392.method_14956((Object)((class_1792)class_7923.field_41178.method_63535(name)));
            case "dropped" -> class_3468.field_15405.method_14956((Object)((class_1792)class_7923.field_41178.method_63535(name)));
            case "killed" -> class_3468.field_15403.method_14956((Object)((class_1299)class_7923.field_41177.method_63535(name)));
            case "killed_by" -> class_3468.field_15411.method_14956((Object)((class_1299)class_7923.field_41177.method_63535(name)));
            case "custom" -> {
                name = (class_2960)class_7923.field_41183.method_63535(name);
                if (name != null) {
                    yield class_3468.field_15419.method_14956((Object)name);
                }
                yield null;
            }
            default -> null;
        };
        return Value.number((double)(stat != null ? (double)MeteorClient.mc.field_1724.method_3143().method_15025(stat) : 0.0));
    }

    private static Value getModuleInfo(Starscript ss, int argCount) {
        Module module;
        if (argCount != 1) {
            ss.error("meteor.get_module_info() requires 1 argument, got %d.", new Object[]{argCount});
        }
        if ((module = Modules.get().get(ss.popString("First argument to meteor.get_module_info() needs to be a string."))) != null && module.isActive()) {
            String info = module.getInfoString();
            return Value.string((String)(info == null ? "" : info));
        }
        return Value.string((String)"");
    }

    private static Value getModuleSetting(Starscript ss, int argCount) {
        Object value;
        Setting<?> setting;
        if (argCount != 2) {
            ss.error("meteor.get_module_setting() requires 2 arguments, got %d.", new Object[]{argCount});
        }
        String settingName = ss.popString("Second argument to meteor.get_module_setting() needs to be a string.");
        String moduleName = ss.popString("First argument to meteor.get_module_setting() needs to be a string.");
        Module module = Modules.get().get(moduleName);
        if (module == null) {
            ss.error("Unable to get module %s for meteor.get_module_setting()", new Object[]{moduleName});
        }
        if ((setting = module.settings.get(settingName)) == null) {
            ss.error("Unable to get setting %s for module %s for meteor.get_module_setting()", new Object[]{settingName, moduleName});
        }
        Object obj = value = setting.get();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Integer.class, Boolean.class, List.class}, obj, n)) {
            case 0 -> {
                Double d = (Double)obj;
                yield Value.number((double)d);
            }
            case 1 -> {
                Integer i = (Integer)obj;
                yield Value.number((double)i.intValue());
            }
            case 2 -> {
                Boolean b = (Boolean)obj;
                yield Value.bool((boolean)b);
            }
            case 3 -> {
                List list = (List)obj;
                yield Value.number((double)list.size());
            }
            default -> Value.string((String)value.toString());
        };
    }

    private static Value isModuleActive(Starscript ss, int argCount) {
        Module module;
        if (argCount != 1) {
            ss.error("meteor.is_module_active() requires 1 argument, got %d.", new Object[]{argCount});
        }
        return Value.bool(((module = Modules.get().get(ss.popString("First argument to meteor.is_module_active() needs to be a string."))) != null && module.isActive() ? 1 : 0) != 0);
    }

    private static Value getItem(Starscript ss, int argCount) {
        int i;
        if (argCount != 1) {
            ss.error("player.get_item() requires 1 argument, got %d.", new Object[]{argCount});
        }
        if ((i = (int)ss.popNumber("First argument to player.get_item() needs to be a number.")) < 0) {
            ss.error("First argument to player.get_item() needs to be a non-negative integer.", new Object[]{i});
        }
        return MeteorClient.mc.field_1724 != null ? MeteorStarscript.wrap(MeteorClient.mc.field_1724.method_31548().method_5438(i)) : Value.null_();
    }

    private static Value countItems(Starscript ss, int argCount) {
        String idRaw;
        class_2960 id;
        if (argCount != 1) {
            ss.error("player.count_items() requires 1 argument, got %d.", new Object[]{argCount});
        }
        if ((id = class_2960.method_12829((String)(idRaw = ss.popString("First argument to player.count_items() needs to be a string.")))) == null) {
            return Value.number((double)0.0);
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
        if (item == class_1802.field_8162 || MeteorClient.mc.field_1724 == null) {
            return Value.number((double)0.0);
        }
        int count = 0;
        for (int i = 0; i < MeteorClient.mc.field_1724.method_31548().method_5439(); ++i) {
            class_1799 itemStack = MeteorClient.mc.field_1724.method_31548().method_5438(i);
            if (itemStack.method_7909() != item) continue;
            count += itemStack.method_7947();
        }
        return Value.number((double)count);
    }

    private static Value getMeteorPrefix() {
        if (Config.get() == null) {
            return Value.null_();
        }
        return Value.string((String)Config.get().prefix.get());
    }

    private static Value oppositeX(boolean camera) {
        double x = camera ? MeteorClient.mc.field_1773.method_19418().method_19326().field_1352 : (MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_23317() : 0.0);
        Dimension dimension = PlayerUtils.getDimension();
        if (dimension == Dimension.Overworld) {
            x /= 8.0;
        } else if (dimension == Dimension.Nether) {
            x *= 8.0;
        }
        return Value.number((double)x);
    }

    private static Value oppositeZ(boolean camera) {
        double z = camera ? MeteorClient.mc.field_1773.method_19418().method_19326().field_1350 : (MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_23321() : 0.0);
        Dimension dimension = PlayerUtils.getDimension();
        if (dimension == Dimension.Overworld) {
            z /= 8.0;
        } else if (dimension == Dimension.Nether) {
            z *= 8.0;
        }
        return Value.number((double)z);
    }

    private static Value yaw(boolean camera) {
        float yaw = camera ? MeteorClient.mc.field_1773.method_19418().method_19330() : (MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_36454() : 0.0f);
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw > 180.0f) {
            yaw -= 360.0f;
        }
        return Value.number((double)yaw);
    }

    private static Value pitch(boolean camera) {
        float pitch = camera ? MeteorClient.mc.field_1773.method_19418().method_19329() : (MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_36455() : 0.0f);
        if ((pitch %= 360.0f) < 0.0f) {
            pitch += 360.0f;
        }
        if (pitch > 180.0f) {
            pitch -= 360.0f;
        }
        return Value.number((double)pitch);
    }

    private static Value direction(boolean camera) {
        float yaw = camera ? MeteorClient.mc.field_1773.method_19418().method_19330() : (MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_36454() : 0.0f);
        return MeteorStarscript.wrap(HorizontalDirection.get(yaw));
    }

    private static Value biome() {
        if (MeteorClient.mc.field_1724 == null || MeteorClient.mc.field_1687 == null) {
            return Value.string((String)"");
        }
        BP.method_10102(MeteorClient.mc.field_1724.method_23317(), MeteorClient.mc.field_1724.method_23318(), MeteorClient.mc.field_1724.method_23321());
        return MeteorClient.mc.field_1687.method_30349().method_46759(class_7924.field_41236).map(biomeRegistry -> {
            class_2960 id = biomeRegistry.method_10221((Object)((class_1959)MeteorClient.mc.field_1687.method_23753((class_2338)BP).comp_349()));
            if (id == null) {
                return Value.string((String)"Unknown");
            }
            return Value.string((String)Arrays.stream(id.method_12832().split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" ")));
        }).orElse(Value.string((String)"Unknown"));
    }

    private static Value handOrOffhand() {
        if (MeteorClient.mc.field_1724 == null) {
            return Value.null_();
        }
        class_1799 itemStack = MeteorClient.mc.field_1724.method_6047();
        if (itemStack.method_7960()) {
            itemStack = MeteorClient.mc.field_1724.method_6079();
        }
        return itemStack != null ? MeteorStarscript.wrap(itemStack) : Value.null_();
    }

    private static Value ping() {
        if (MeteorClient.mc.method_1562() == null || MeteorClient.mc.field_1724 == null) {
            return Value.number((double)0.0);
        }
        class_640 playerListEntry = MeteorClient.mc.method_1562().method_2871(MeteorClient.mc.field_1724.method_5667());
        return Value.number((double)(playerListEntry != null ? (double)playerListEntry.method_2959() : 0.0));
    }

    private static Value posString(boolean opposite, boolean camera) {
        class_243 pos = camera ? MeteorClient.mc.field_1773.method_19418().method_19326() : (MeteorClient.mc.field_1724 != null ? MeteorClient.mc.field_1724.method_73189() : class_243.field_1353);
        double x = pos.field_1352;
        double z = pos.field_1350;
        if (opposite) {
            Dimension dimension = PlayerUtils.getDimension();
            if (dimension == Dimension.Overworld) {
                x /= 8.0;
                z /= 8.0;
            } else if (dimension == Dimension.Nether) {
                x *= 8.0;
                z *= 8.0;
            }
        }
        return MeteorStarscript.posString(x, pos.field_1351, z);
    }

    private static Value posString(double x, double y, double z) {
        return Value.string((String)String.format("X: %.0f Y: %.0f Z: %.0f", x, y, z));
    }

    private static Value crosshairType() {
        if (MeteorClient.mc.field_1765 == null) {
            return Value.string((String)"miss");
        }
        return Value.string((String)(switch (MeteorClient.mc.field_1765.method_17783()) {
            default -> throw new MatchException(null, null);
            case class_239.class_240.field_1333 -> "miss";
            case class_239.class_240.field_1332 -> "block";
            case class_239.class_240.field_1331 -> "entity";
        }));
    }

    private static Value crosshairValue() {
        if (MeteorClient.mc.field_1687 == null || MeteorClient.mc.field_1765 == null) {
            return Value.null_();
        }
        if (MeteorClient.mc.field_1765.method_17783() == class_239.class_240.field_1333) {
            return Value.string((String)"");
        }
        class_239 class_2392 = MeteorClient.mc.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 hit = (class_3965)class_2392;
            return MeteorStarscript.wrap(hit.method_17777(), MeteorClient.mc.field_1687.method_8320(hit.method_17777()));
        }
        return MeteorStarscript.wrap(((class_3966)MeteorClient.mc.field_1765).method_17782());
    }

    public static class_2960 popIdentifier(Starscript ss, String errorMessage) {
        try {
            return class_2960.method_60654((String)ss.popString(errorMessage));
        }
        catch (class_151 e) {
            ss.error(e.getMessage(), new Object[0]);
            return null;
        }
    }

    public static Value wrap(class_1799 itemStack) {
        String name = itemStack.method_7960() ? "" : Names.get(itemStack.method_7909());
        int durability = 0;
        if (!itemStack.method_7960() && itemStack.method_7963()) {
            durability = itemStack.method_7936() - itemStack.method_7919();
        }
        return Value.map((ValueMap)new ValueMap().set("_toString", Value.string((String)(itemStack.method_7947() <= 1 ? name : String.format("%s %dx", name, itemStack.method_7947())))).set("name", Value.string((String)name)).set("id", Value.string((String)class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString())).set("count", Value.number((double)itemStack.method_7947())).set("durability", Value.number((double)durability)).set("max_durability", Value.number((double)itemStack.method_7936())));
    }

    public static Value wrap(class_2338 blockPos, class_2680 blockState) {
        return Value.map((ValueMap)new ValueMap().set("_toString", Value.string((String)Names.get(blockState.method_26204()))).set("id", Value.string((String)class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString())).set("pos", Value.map((ValueMap)new ValueMap().set("_toString", MeteorStarscript.posString(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())).set("x", Value.number((double)blockPos.method_10263())).set("y", Value.number((double)blockPos.method_10264())).set("z", Value.number((double)blockPos.method_10260())))));
    }

    public static Value wrap(class_1297 entity) {
        double d;
        double d2;
        class_1309 e;
        ValueMap valueMap = new ValueMap().set("_toString", Value.string((String)entity.method_5477().getString())).set("id", Value.string((String)class_7923.field_41177.method_10221((Object)entity.method_5864()).toString()));
        if (entity instanceof class_1309) {
            e = (class_1309)entity;
            d2 = e.method_6032();
        } else {
            d2 = 0.0;
        }
        ValueMap valueMap2 = valueMap.set("health", Value.number((double)d2));
        if (entity instanceof class_1309) {
            e = (class_1309)entity;
            d = e.method_6067();
        } else {
            d = 0.0;
        }
        return Value.map((ValueMap)valueMap2.set("absorption", Value.number((double)d)).set("pos", Value.map((ValueMap)new ValueMap().set("_toString", MeteorStarscript.posString(entity.method_23317(), entity.method_23318(), entity.method_23321())).set("x", Value.number((double)entity.method_23317())).set("y", Value.number((double)entity.method_23318())).set("z", Value.number((double)entity.method_23321())))));
    }

    public static Value wrap(HorizontalDirection dir) {
        return Value.map((ValueMap)new ValueMap().set("_toString", Value.string((String)(dir.name + " " + dir.axis))).set("name", Value.string((String)dir.name)).set("axis", Value.string((String)dir.axis)));
    }

    public static Value wrap(class_1293 effectInstance) {
        return Value.map((ValueMap)new ValueMap().set("duration", (double)effectInstance.method_5584()).set("level", (double)(effectInstance.method_5578() + 1)));
    }
}

