/*
 * Decompiled with CFR 0.152.
 */
package com.globalista.makeitrain;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class Config {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    public String registryKey = "Use RegistryKey dimension matching instead of checking if the dimension has skylight (default: true)";
    public boolean registryKeyEnable = true;

    public static Config loadConfigFile(File file) {
        Config config = null;
        if (file.exists()) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                config = (Config)gson.fromJson((Reader)fileReader, Config.class);
            }
            catch (IOException e) {
                throw new RuntimeException("[Make It Rain] Problem occurred when trying to load config: ", e);
            }
        }
        if (config == null) {
            config = new Config();
        }
        config.saveConfigFile(file);
        return config;
    }

    public void saveConfigFile(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

