/*
 * Decompiled with CFR 0.152.
 */
package com.destroyaa.container_blocker.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockedItemsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"container-blocker");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config", "blocked_items.json");
    private static Set<class_1792> blockedItems = new HashSet<class_1792>();

    public static void load() {
        try {
            ConfigData config;
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                config = (ConfigData)GSON.fromJson(json, ConfigData.class);
                LOGGER.info("Loaded blocked items config from {}", (Object)CONFIG_PATH);
            } else {
                config = BlockedItemsConfig.createDefaultConfig();
                BlockedItemsConfig.saveConfig(config);
                LOGGER.info("Created default blocked items config at {}", (Object)CONFIG_PATH);
            }
            blockedItems.clear();
            if (config.blockedItems == null || config.blockedItems.isEmpty()) {
                LOGGER.warn("No blocked items configured");
            } else {
                LOGGER.info("Loading {} blocked item(s)", (Object)config.blockedItems.size());
                for (String itemId : config.blockedItems) {
                    try {
                        class_2960 id = class_2960.method_12829((String)itemId);
                        if (id != null && class_7923.field_41178.method_10250(id)) {
                            class_1792 item = (class_1792)class_7923.field_41178.method_63535(id);
                            blockedItems.add(item);
                            LOGGER.info("\u2713 Blocking item: {} ({})", (Object)itemId, (Object)item.toString());
                            continue;
                        }
                        LOGGER.warn("\u2717 Unknown item ID in config: {}", (Object)itemId);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u2717 Failed to parse item ID: {}", (Object)itemId, (Object)e);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load blocked items config", (Throwable)e);
            blockedItems.clear();
            blockedItems.add((class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)"dragon_egg")));
        }
    }

    private static ConfigData createDefaultConfig() {
        ConfigData config = new ConfigData();
        config.blockedItems = new ArrayList<String>();
        config.blockedItems.add("minecraft:dragon_egg");
        return config;
    }

    private static void saveConfig(ConfigData config) throws IOException {
        String json = GSON.toJson((Object)config);
        Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
    }

    public static boolean isBlocked(class_1792 item) {
        return blockedItems.contains(item);
    }

    private static class ConfigData {
        public List<String> blockedItems;

        private ConfigData() {
        }
    }
}

