/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.scabbard.platform;

import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.invictusslayer.scabbard.Scabbard;
import net.invictusslayer.scabbard.world.biome.BiomeModifierHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public interface IPlatformHandler {
    public static final IPlatformHandler PLATFORM = IPlatformHandler.load(IPlatformHandler.class);

    public Platform getPlatform();

    public Path configPath(String var1);

    public void addSpawnBiomeModifier(BiomeModifierHandler var1, String var2, TagKey<Biome> var3, List<MobSpawnSettings.SpawnerData> var4);

    public void addFeatureBiomeModifier(BiomeModifierHandler var1, String var2, TagKey<Biome> var3, GenerationStep.Decoration var4, List<ResourceKey<PlacedFeature>> var5);

    public Supplier<SpawnEggItem> registerSpawnEgg(String var1, String var2, Supplier<EntityType<? extends Mob>> var3, int var4, int var5, Item.Properties var6);

    public <T> Supplier<T> register(Registry<? super T> var1, String var2, String var3, Supplier<T> var4);

    public <T> Supplier<Holder.Reference<T>> registerHolder(Registry<T> var1, String var2, String var3, Supplier<T> var4);

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Scabbard.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static enum Platform {
        FABRIC,
        FORGE,
        NEOFORGE;

    }
}

