package net.invictusslayer.scabbard.platform;

import net.fabricmc.fabric.api.biome.v1.BiomeModification;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.loader.api.FabricLoader;
import net.invictusslayer.scabbard.Scabbard;
import net.invictusslayer.scabbard.world.biome.BiomeModifierHandler;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;

public class FabricPlatformHandler implements IPlatformHandler {
	@Override
	public Platform getPlatform() {
		return Platform.FABRIC;
	}

	@Override
	public Path configPath(String modId) {
		return FabricLoader.getInstance().getConfigDir().resolve(modId);
	}

	@Override
	public void addSpawnBiomeModifier(BiomeModifierHandler handler, String name, class_6862<class_1959> biomes, List<class_5483.class_1964> spawners) {
		BiomeModification modification = BiomeModifications.create(class_2960.method_60655(Scabbard.MOD_ID, name));
		spawners.forEach(spawner -> modification.add(ModificationPhase.ADDITIONS, context -> context.hasTag(biomes), context -> context.getSpawnSettings().addSpawn(spawner.field_9389.method_5891(), spawner)));
	}

	@Override
	public void addFeatureBiomeModifier(BiomeModifierHandler handler, String name, class_6862<class_1959> biomes, class_2893.class_2895 step, List<class_5321<class_6796>> features) {
		BiomeModification modification = BiomeModifications.create(class_2960.method_60655(Scabbard.MOD_ID, name));
		features.forEach(feature -> modification.add(ModificationPhase.ADDITIONS, context -> context.hasTag(biomes), context -> context.getGenerationSettings().addFeature(step, feature)));
	}

	@Override
	public <T> Supplier<T> register(class_2378<? super T> registry, String modId, String name, Supplier<T> value) {
		T registered = class_2378.method_10230(registry, class_2960.method_60655(modId, name), value.get());
		return () -> registered;
	}

	@Override
	public <T> Supplier<class_6880.class_6883<T>> registerHolder(class_2378<T> registry, String modId, String name, Supplier<T> value) {
		class_6880.class_6883<T> registered = class_2378.method_47985(registry, class_2960.method_60655(modId, name), value.get());
		return () -> registered;
	}
}
