package net.invictusslayer.scabbard.data;

import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class LangProvider implements class_2405 {
	private final Map<String, String> data = new TreeMap<>();
	private final class_7784 output;
	private final String modId;
	private final String locale;

	public LangProvider(class_7784 output, String modId, String locale) {
		this.output = output;
		this.modId = modId;
		this.locale = locale;
	}

	protected abstract void addTranslations();

	public CompletableFuture<?> method_10319(class_7403 cache) {
		addTranslations();

		if (!data.isEmpty()) return save(cache, output.method_45972(class_7784.class_7490.field_39368).resolve(modId).resolve("lang").resolve(locale + ".json"));

		return CompletableFuture.allOf();
	}

	public String method_10321() {
		return "Languages: " + locale;
	}

	private CompletableFuture<?> save(class_7403 cache, Path path) {
		JsonObject json = new JsonObject();
		data.forEach(json::addProperty);

		return class_2405.method_10320(cache, json, path);
	}

	protected void addBlock(Supplier<? extends class_2248> key, String name) {
		add(key.get(), name);
	}

	protected void add(class_2248 key, String name) {
		add(key.method_8389().method_7876(), name);
	}

	protected void addItem(Supplier<? extends class_1792> key, String name) {
		add(key.get(), name);
	}

	protected void add(class_1792 key, String name) {
		add(key.method_7876(), name);
	}

	protected void addItemStack(Supplier<class_1799> key, String name) {
		add(key.get(), name);
	}

	protected void add(class_1799 key, String name) {
		add(key.method_7909().method_7876(), name);
	}

	protected void addEnchantment(Supplier<? extends class_1887> key, String name) {
		add(key.get(), name);
	}

	protected void add(class_1887 key, String name) {
		add(key.method_8184(), name);
	}

	protected void addEffect(Supplier<class_6880.class_6883<class_1291>> key, String name) {
		add(key.get().comp_349(), name);
	}

	protected void add(class_1291 key, String name) {
		add(key.method_5567(), name);
	}

	protected void addEntityType(Supplier<? extends class_1299<?>> key, String name) {
		add(key.get(), name);
	}

	protected void add(class_1299<?> key, String name) {
		add(key.method_5882(), name);
	}

	protected void add(String key, String value) {
		if (data.put(key, value) != null) throw new IllegalStateException("Duplicate translation key " + key);
	}

	protected void addSound(Supplier<? extends class_3414> key, String name) {
		add(key.get().method_14833().method_42093("subtitles"), name);
	}

	protected void addItemDesc(Supplier<? extends class_1792> key, String name) {
		add(key.get().method_7876() + ".desc", name);
	}

	protected void addCreativeTab(String key, String name) {
		add("itemGroup." + modId + "." + key, name);
	}

	protected void addConfig(String key, String name) {
		add("text.autoconfig." + modId + "." + key, name);
	}

	protected void addConfigTitle(String name) {
		addConfig("title", name);
	}

	protected void addConfigCategory(String key, String name) {
		addConfig("category." + key, name);
	}

	protected void addConfigOption(String key, String name) {
		addConfig("option." + key, name);
	}

	protected void addConfigOptionPrefix(String key, String name, String prefix) {
		addConfigOption(key, name);
		addConfigOption(key + ".@PrefixText", prefix);
	}

	protected void addConfigEnumTooltip(String key, int ordinal, String name) {
		addConfig(key + ".@Tooltip[" + ordinal + "]", name);
	}
}
