/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.scabbard.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;

public abstract class LangProvider
implements DataProvider {
    private final Map<String, String> data = new TreeMap<String, String>();
    private final PackOutput output;
    private final String modId;
    private final String locale;

    public LangProvider(PackOutput output, String modId, String locale) {
        this.output = output;
        this.modId = modId;
        this.locale = locale;
    }

    protected abstract void addTranslations();

    public CompletableFuture<?> run(CachedOutput cache) {
        this.addTranslations();
        if (!this.data.isEmpty()) {
            return this.save(cache, this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modId).resolve("lang").resolve(this.locale + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    public String getName() {
        return "Languages: " + this.locale;
    }

    private CompletableFuture<?> save(CachedOutput cache, Path path) {
        JsonObject json = new JsonObject();
        this.data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
    }

    protected void addBlock(Supplier<? extends Block> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Block key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addItem(Supplier<? extends Item> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Item key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addItemStack(Supplier<ItemStack> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(ItemStack key, String name) {
        this.add(key.getItem().getDescriptionId(), name);
    }

    protected void addEnchantment(Supplier<? extends Enchantment> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Enchantment key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addEffect(Supplier<Holder.Reference<MobEffect>> key, String name) {
        this.add((MobEffect)key.get().value(), name);
    }

    protected void add(MobEffect key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void addEntityType(Supplier<? extends EntityType<?>> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(EntityType<?> key, String name) {
        this.add(key.getDescriptionId(), name);
    }

    protected void add(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }

    protected void addSound(Supplier<? extends SoundEvent> key, String name) {
        this.add(key.get().getLocation().toLanguageKey("subtitles"), name);
    }

    protected void addItemDesc(Supplier<? extends Item> key, String name) {
        this.add(key.get().getDescriptionId() + ".desc", name);
    }

    protected void addCreativeTab(String key, String name) {
        this.add("itemGroup." + this.modId + "." + key, name);
    }

    protected void addConfig(String key, String name) {
        this.add("text.autoconfig." + this.modId + "." + key, name);
    }

    protected void addConfigTitle(String name) {
        this.addConfig("title", name);
    }

    protected void addConfigCategory(String key, String name) {
        this.addConfig("category." + key, name);
    }

    protected void addConfigOption(String key, String name) {
        this.addConfig("option." + key, name);
    }

    protected void addConfigOptionPrefix(String key, String name, String prefix) {
        this.addConfigOption(key, name);
        this.addConfigOption(key + ".@PrefixText", prefix);
    }

    protected void addConfigEnumTooltip(String key, int ordinal, String name) {
        this.addConfig(key + ".@Tooltip[" + ordinal + "]", name);
    }
}

