/*
 * Decompiled with CFR 0.152.
 */
package net.invictusslayer.scabbard.world.level.block;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;

public abstract class FlammableBlocks {
    protected static void registerWoodFamilies(Stream<WoodFamily> families) {
        families.filter(WoodFamily::isFlammable).forEach(family -> family.getVariants().forEach((variant, supplier) -> {
            switch (variant) {
                case LOG: 
                case WOOD: 
                case STRIPPED_LOG: 
                case STRIPPED_WOOD: {
                    FlammableBlocks.register(supplier, 5, 5);
                    break;
                }
                case LEAVES: {
                    FlammableBlocks.register(supplier, 60, 30);
                    break;
                }
                case PLANKS: 
                case STAIRS: 
                case SLAB: 
                case FENCE: 
                case FENCE_GATE: {
                    FlammableBlocks.register(supplier, 20, 5);
                }
            }
        }));
    }

    protected static void register(Supplier<?> block, int flammability, int encouragement) {
        ((FireBlock)Blocks.FIRE).setFlammable((Block)block.get(), encouragement, flammability);
    }
}

