package net.invictusslayer.scabbard.platform;

import net.invictusslayer.scabbard.Scabbard;
import net.invictusslayer.scabbard.world.biome.BiomeModifierHandler;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_5321;
import net.minecraft.class_5483;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import java.nio.file.Path;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Supplier;

/*
Based on Joseph T. McQuigg's BWG PlatformHandler
https://github.com/Potion-Studios/Oh-The-Biomes-Weve-Gone/blob/c9c97df5bf24e1b8aa9eaa32bf477d569aa7c156/Common/src/main/java/net/potionstudios/biomeswevegone/PlatformHandler.java
 */
public interface IPlatformHandler {
	IPlatformHandler PLATFORM = load(IPlatformHandler.class);

	Platform getPlatform();

	Path configPath(String modId);

	void addSpawnBiomeModifier(BiomeModifierHandler handler, String name, class_6862<class_1959> biomes, List<class_5483.class_1964> spawners);

	void addFeatureBiomeModifier(BiomeModifierHandler handler, String name, class_6862<class_1959> biomes, class_2893.class_2895 step, List<class_5321<class_6796>> features);

	Supplier<class_1826> registerSpawnEgg(String modId, String name, Supplier<class_1299<? extends class_1308>> entity, int bgColor, int fgColor, class_1792.class_1793 props);

	<T> Supplier<T> register(class_2378<? super T> registry, String modId, String name, Supplier<T> value);

	<T> Supplier<class_6880.class_6883<T>> registerHolder(class_2378<T> registry, String modId, String name, Supplier<T> value);

	private static <T> T load(Class<T> clazz) {
		final T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
		Scabbard.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
		return loadedService;
	}

	enum Platform {
		FABRIC,
		FORGE,
		NEOFORGE
	}
}
