package net.invictusslayer.scabbard.world.level;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_6862;

public class WoodFamily {
	private static final List<WoodFamily> FAMILIES = new ArrayList<>();
	private class_6862<class_2248> logBlocks = null;
	private class_6862<class_1792> logItems = null;
	private class_1690.class_1692 boatType = null;
	private final Map<Variant, Supplier<?>> variants = new HashMap<>();
	private boolean isFlammable = true;
	private boolean isStrippable = true;

	WoodFamily() {}

	public class_6862<class_2248> getLogBlocks() {
		return logBlocks;
	}

	public class_6862<class_1792> getLogItems() {
		return logItems;
	}

	public class_1690.class_1692 getBoatType() {
		return boatType;
	}

	public Map<Variant, Supplier<?>> getVariants() {
		return variants;
	}

	public Supplier<?> get(Variant variant) {
		return variants.get(variant);
	}

	public boolean isFlammable() {
		return isFlammable;
	}

	public boolean isStrippable() {
		return isStrippable;
	}

	protected static Builder builder() {
		Builder builder = new Builder();
		FAMILIES.add(builder.getFamily());
		return builder;
	}

	public static Stream<WoodFamily> getAllFamilies() {
		return FAMILIES.stream();
	}

	public static class Builder {
		private final WoodFamily family;

		public Builder() {
			family = new WoodFamily();
		}

		public WoodFamily getFamily() {
			return family;
		}

		public Builder button(Supplier<class_2248> button) {
			family.variants.put(Variant.BUTTON, button);
			return this;
		}

		public Builder boat(Supplier<class_1792> boat, class_1690.class_1692 type) {
			family.variants.put(Variant.BOAT, boat);
			family.boatType = type;
			return this;
		}

		public Builder chestBoat(Supplier<class_1792> boat) {
			family.variants.put(Variant.CHEST_BOAT, boat);
			return this;
		}

		public Builder door(Supplier<class_2248> door) {
			family.variants.put(Variant.DOOR, door);
			return this;
		}

		public Builder fence(Supplier<class_2248> fence) {
			family.variants.put(Variant.FENCE, fence);
			return this;
		}

		public Builder fenceGate(Supplier<class_2248> fenceGate) {
			family.variants.put(Variant.FENCE_GATE, fenceGate);
			return this;
		}

		public Builder hangingSign(Supplier<class_2248> ceiling, Supplier<class_2248> wall, Supplier<class_1792> item) {
			family.variants.put(Variant.HANGING_SIGN, ceiling);
			family.variants.put(Variant.WALL_HANGING_SIGN, wall);
			family.variants.put(Variant.HANGING_SIGN_ITEM, item);
			return this;
		}

		public Builder leaves(Supplier<class_2248> leaves) {
			family.variants.put(Variant.LEAVES, leaves);
			return this;
		}

		public Builder log(Supplier<class_2248> log, class_6862<class_2248> blockTag, class_6862<class_1792> itemTag) {
			family.variants.put(Variant.LOG, log);
			family.logBlocks = blockTag;
			family.logItems = itemTag;
			return this;
		}

		public Builder sapling(Supplier<class_2248> sapling, Supplier<class_2248> pottedSapling) {
			family.variants.put(Variant.SAPLING, sapling);
			family.variants.put(Variant.POTTED_SAPLING, pottedSapling);
			return this;
		}

		public Builder sign(Supplier<class_2248> standing, Supplier<class_2248> wall, Supplier<class_1792> item) {
			family.variants.put(Variant.SIGN, standing);
			family.variants.put(Variant.WALL_SIGN, wall);
			family.variants.put(Variant.SIGN_ITEM, item);
			return this;
		}

		public Builder slab(Supplier<class_2248> slab) {
			family.variants.put(Variant.SLAB, slab);
			return this;
		}

		public Builder stairs(Supplier<class_2248> stairs) {
			family.variants.put(Variant.STAIRS, stairs);
			return this;
		}

		public Builder strippedLog(Supplier<class_2248> strippedLog) {
			family.variants.put(Variant.STRIPPED_LOG, strippedLog);
			return this;
		}

		public Builder strippedWood(Supplier<class_2248> strippedWood) {
			family.variants.put(Variant.STRIPPED_WOOD, strippedWood);
			return this;
		}

		public Builder planks(Supplier<class_2248> planks) {
			family.variants.put(Variant.PLANKS, planks);
			return this;
		}

		public Builder pressurePlate(Supplier<class_2248> pressurePlate) {
			family.variants.put(Variant.PRESSURE_PLATE, pressurePlate);
			return this;
		}

		public Builder trapdoor(Supplier<class_2248> trapdoor) {
			family.variants.put(Variant.TRAPDOOR, trapdoor);
			return this;
		}

		public Builder wood(Supplier<class_2248> wood) {
			family.variants.put(Variant.WOOD, wood);
			return this;
		}

		public Builder notFlammable() {
			family.isFlammable = false;
			return this;
		}

		public Builder notStrippable() {
			family.isStrippable = false;
			return this;
		}
	}

	public enum Variant {
		BUTTON,
		BOAT,
		CHEST_BOAT,
		DOOR(true),
		FENCE,
		FENCE_GATE,
		HANGING_SIGN,
		HANGING_SIGN_ITEM,
		LEAVES,
		LOG,
		SAPLING(true),
		SIGN,
		SIGN_ITEM,
		SLAB,
		STAIRS,
		STRIPPED_LOG,
		STRIPPED_WOOD,
		PLANKS,
		POTTED_SAPLING(true),
		PRESSURE_PLATE,
		TRAPDOOR(true),
		WALL_HANGING_SIGN,
		WALL_SIGN,
		WOOD;

		private final boolean isCutout;

		Variant() {
			this(false);
		}

		Variant(boolean isCutout) {
			this.isCutout = isCutout;
		}

		public boolean isCutout() {
			return isCutout;
		}
	}
}
