package net.invictusslayer.scabbard.world.level.block;

import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2358;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class FlammableBlocks {
	protected static void registerWoodFamilies(Stream<WoodFamily> families) {
		families.filter(WoodFamily::isFlammable).forEach(family -> family.getVariants().forEach((variant, supplier) -> {
			switch (variant) {
				case LOG, WOOD, STRIPPED_LOG, STRIPPED_WOOD -> register(supplier, 5, 5);
				case LEAVES -> register(supplier, 60, 30);
				case PLANKS, STAIRS, SLAB, FENCE, FENCE_GATE -> register(supplier, 20, 5);
			}
		}));
	}

	protected static void register(Supplier<?> block, int flammability, int encouragement) {
		((class_2358) class_2246.field_10036).method_10189((class_2248) block.get(), encouragement, flammability);
	}
}
