package net.invictusslayer.scabbard.world.level.block;

import com.google.common.collect.Maps;
import net.invictusslayer.scabbard.world.level.WoodFamily;
import net.minecraft.class_1743;
import net.minecraft.class_2248;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class StrippableBlocks {
	protected static void registerWoodFamilies(Stream<WoodFamily> families) {
		families.filter(WoodFamily::isStrippable).forEach(family -> {
			register(family.get(WoodFamily.Variant.LOG), family.get(WoodFamily.Variant.STRIPPED_LOG));
			register(family.get(WoodFamily.Variant.WOOD), family.get(WoodFamily.Variant.STRIPPED_WOOD));
		});
	}

	protected static void register(Supplier<?> block, Supplier<?> result) {
		class_1743.field_7898 = Maps.newHashMap(class_1743.field_7898);
		class_1743.field_7898.put((class_2248) block.get(), (class_2248) result.get());
	}
}
