/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import net.minecraft.server.MinecraftServer;
import samcask.scheduledrestart.RestartScheduler;
import samcask.scheduledrestart.ScheduledRestart;

public class RestartAutoScheduler {
    static LocalDateTime currentTime;
    static LocalDateTime restartTime;

    public static void scheduleAutoRestartInterval(MinecraftServer server, long delaySeconds) {
        if (delaySeconds == 0L) {
            ScheduledRestart.logInfo("Failed to schedule interval restart, no interval set.");
            return;
        }
        RestartScheduler.scheduleRestart(server, delaySeconds, RestartScheduler.RestartChannel.AutoRestart);
    }

    public static void scheduleAutoRestartDaily(MinecraftServer server, String[] times) {
        if (times.length == 0) {
            ScheduledRestart.logInfo("Failed to schedule daily restart, no times set");
            return;
        }
        RestartAutoScheduler.initialiseTimes(times);
        RestartScheduler.scheduleRestart(server, RestartAutoScheduler.getTimeToNextDailyRestart(times), RestartScheduler.RestartChannel.AutoRestart);
    }

    private static void initialiseTimes(String[] times) {
        currentTime = LocalDateTime.now();
        if (currentTime.isAfter(restartTime = LocalDateTime.now().with(LocalTime.parse(times[0])))) {
            restartTime = restartTime.plusDays(1L);
        }
    }

    private static int getTimeToNextDailyRestart(String[] times) {
        int delay;
        int smallestDelay = delay = (int)Duration.between(currentTime, restartTime).toSeconds();
        for (int i = 1; i < times.length; ++i) {
            restartTime = LocalDateTime.now().with(LocalTime.parse(times[i]));
            if (currentTime.isAfter(restartTime)) {
                restartTime = restartTime.plusDays(1L);
            }
            if ((delay = (int)Duration.between(currentTime, restartTime).toSeconds()) >= smallestDelay) continue;
            smallestDelay = delay;
        }
        return smallestDelay;
    }
}

