/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import samcask.scheduledrestart.RestartAutoScheduler;
import samcask.scheduledrestart.RestartCommand;
import samcask.scheduledrestart.RestartConfig;
import samcask.scheduledrestart.RestartNoPlayerScheduler;

public class ScheduledRestart
implements ModInitializer {
    public static final String MOD_ID = "scheduled-restart";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"scheduled-restart");
    public static RestartConfig config;

    public void onInitialize() {
        AutoConfig.register(RestartConfig.class, JanksonConfigSerializer::new);
        config = (RestartConfig)AutoConfig.getConfigHolder(RestartConfig.class).getConfig();
        CommandRegistrationCallback.EVENT.register(RestartCommand::register);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (ScheduledRestart.config.restartScheduleType.equals("daily") && ScheduledRestart.config.restartInterval > 0) {
                RestartAutoScheduler.scheduleAutoRestartDaily(server, ScheduledRestart.config.dailyRestartTimes);
            } else if (ScheduledRestart.config.restartScheduleType.equals("interval") && ScheduledRestart.config.restartInterval > 0) {
                RestartAutoScheduler.scheduleAutoRestartInterval(server, ScheduledRestart.config.restartInterval);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(RestartNoPlayerScheduler::finalPlayerDisconnected);
    }

    public static void logInfo(String message) {
        LOGGER.info("[ScheduledRestartMod] - " + message);
    }

    public static void logError(String message) {
        LOGGER.error("[ScheduledRestartMod] - " + message);
    }

    public static void sendAnnouncement(MinecraftServer server, String message, boolean logMessage) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(class_2561.method_30163((String)("[Server] " + message)), false);
        }
        if (logMessage) {
            ScheduledRestart.logInfo(message);
        }
    }
}

