/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import samcask.scheduledrestart.ScheduledRestart;

public class RestartHandler {
    static final String os = System.getProperty("os.name").toLowerCase();
    static final Path rootPath = Path.of(".", new String[0]);
    static String startScriptPath = RestartHandler.getStartScriptPath();

    public static int restart(MinecraftServer server) {
        if (!RestartHandler.doesScriptExist()) {
            return 0;
        }
        String[] command = RestartHandler.tryConstructRestartCommand();
        if (command == null) {
            return 0;
        }
        RestartHandler.tryKickPlayers(server);
        RestartHandler.stopServerWithRestart(server, command);
        return 1;
    }

    private static boolean doesScriptExist() {
        try {
            if (!Files.exists(rootPath.toRealPath(new LinkOption[0]).resolve(startScriptPath), new LinkOption[0])) {
                ScheduledRestart.logError("Start script not found");
                return false;
            }
        }
        catch (IOException e) {
            ScheduledRestart.logError("Could not find root directory");
            return false;
        }
        return true;
    }

    @Nullable
    private static String[] tryConstructRestartCommand() {
        if (os.contains("win")) {
            return new String[]{"cmd", "/c", "start", "", startScriptPath};
        }
        if (os.contains("nix") || os.contains("nux") || os.contains("mac")) {
            return new String[]{"bash", startScriptPath};
        }
        ScheduledRestart.logError("Operating system not supported");
        return null;
    }

    private static String getStartScriptPath() {
        boolean scriptPathDefinedInConfig;
        boolean bl = scriptPathDefinedInConfig = !ScheduledRestart.config.startScriptPath.isEmpty();
        String startScriptPath = scriptPathDefinedInConfig ? ScheduledRestart.config.startScriptPath : (os.contains("win") ? "start.bat" : "start.sh");
        return startScriptPath;
    }

    private static void tryKickPlayers(MinecraftServer server) {
        ScheduledRestart.logInfo("Disconnecting players...");
        try {
            RestartHandler.kickPlayers(server);
        }
        catch (Exception e) {
            ScheduledRestart.logError("Unknown error while disconnecting players");
        }
    }

    private static void kickPlayers(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.field_13987.method_14367(class_2561.method_30163((String)ScheduledRestart.config.kickMessage));
        }
        ScheduledRestart.logInfo("Successfully disconnected all players");
    }

    private static void stopServerWithRestart(MinecraftServer server, String[] command) {
        ScheduledRestart.logInfo("Restarting server...");
        RestartHandler.prepareRestart(command);
        server.method_3747(false);
    }

    private static void prepareRestart(String[] command) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Runtime.getRuntime().exec(command, null, rootPath.toFile());
            }
            catch (IOException e) {
                ScheduledRestart.logError("Failed to run start script");
            }
        }));
        ScheduledRestart.logInfo("Start script ready");
    }
}

