/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import samcask.scheduledrestart.RestartHandler;
import samcask.scheduledrestart.ScheduledRestart;

public class RestartScheduler {
    static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "RestartScheduler");
        t.setDaemon(true);
        return t;
    });
    static ScheduledFuture<?> scheduledManualRestart = null;
    static ScheduledFuture<?> scheduledAutoRestart = null;
    static ScheduledFuture<?> scheduledNoPlayerRestart = null;
    static ScheduledFuture<?>[] scheduledManualAnnouncements = new ScheduledFuture[ScheduledRestart.config.restartWarningTimes.length];
    static ScheduledFuture<?>[] scheduledAutoAnnouncements = new ScheduledFuture[ScheduledRestart.config.restartWarningTimes.length];

    public static int scheduleRestart(MinecraftServer server, long delaySeconds, RestartChannel restartChannel) {
        RestartScheduler.cancelScheduledRestart(restartChannel);
        RestartScheduler.setScheduledRestart(restartChannel, RestartScheduler.createScheduledRestart(server, delaySeconds));
        RestartScheduler.setScheduledAnnouncements(restartChannel, RestartScheduler.createScheduledAnnouncements(server, delaySeconds));
        ScheduledRestart.logInfo("New restart scheduled on channel " + String.valueOf((Object)restartChannel) + " at time " + String.valueOf(LocalDateTime.now().plusSeconds(delaySeconds)));
        return 1;
    }

    public static ScheduledFuture<?> getScheduledRestart(RestartChannel restartChannel) {
        return switch (restartChannel.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> scheduledManualRestart;
            case 1 -> scheduledAutoRestart;
            case 2 -> scheduledNoPlayerRestart;
        };
    }

    public static ScheduledFuture<?>[] getScheduledAnnouncements(RestartChannel restartChannel) {
        return switch (restartChannel.ordinal()) {
            case 0 -> scheduledManualAnnouncements;
            case 1 -> scheduledAutoAnnouncements;
            default -> null;
        };
    }

    public static int cancelScheduledRestart(RestartChannel restartChannel) {
        ScheduledFuture<?> scheduledRestart = RestartScheduler.getScheduledRestart(restartChannel);
        if (scheduledRestart == null || scheduledRestart.isDone()) {
            return 0;
        }
        scheduledRestart.cancel(false);
        RestartScheduler.cancelScheduledAnnouncements(RestartScheduler.getScheduledAnnouncements(restartChannel));
        ScheduledRestart.logInfo("Cancelled existing scheduled restart on channel " + String.valueOf((Object)restartChannel));
        return 1;
    }

    private static void cancelScheduledAnnouncements(ScheduledFuture<?>[] scheduledAnnouncements) {
        if (scheduledAnnouncements == null) {
            return;
        }
        for (ScheduledFuture<?> scheduledAnnouncement : scheduledAnnouncements) {
            if (scheduledAnnouncement == null) continue;
            scheduledAnnouncement.cancel(false);
        }
    }

    private static void setScheduledRestart(RestartChannel restartChannel, ScheduledFuture<?> scheduledRestart) {
        switch (restartChannel.ordinal()) {
            case 0: {
                scheduledManualRestart = scheduledRestart;
                break;
            }
            case 1: {
                scheduledAutoRestart = scheduledRestart;
                break;
            }
            case 2: {
                scheduledNoPlayerRestart = scheduledRestart;
            }
        }
    }

    private static ScheduledFuture<?> createScheduledRestart(MinecraftServer server, long delaySeconds) {
        return scheduler.schedule(() -> server.execute(() -> RestartHandler.restart(server)), delaySeconds, TimeUnit.SECONDS);
    }

    private static void setScheduledAnnouncements(RestartChannel restartChannel, ScheduledFuture<?>[] scheduledAnnouncements) {
        switch (restartChannel.ordinal()) {
            case 0: {
                scheduledManualAnnouncements = scheduledAnnouncements;
                break;
            }
            case 1: {
                scheduledAutoAnnouncements = scheduledAnnouncements;
            }
        }
    }

    private static ScheduledFuture<?>[] createScheduledAnnouncements(MinecraftServer server, long delaySeconds) {
        ScheduledFuture[] scheduledAnnouncements = new ScheduledFuture[ScheduledRestart.config.restartWarningTimes.length];
        for (int i = 0; i < scheduledAnnouncements.length; ++i) {
            scheduledAnnouncements[i] = RestartScheduler.tryCreateScheduledAnnouncement(server, delaySeconds, i);
        }
        return scheduledAnnouncements;
    }

    private static ScheduledFuture<?> tryCreateScheduledAnnouncement(MinecraftServer server, long delaySeconds, int i) {
        int announcementDelay = ScheduledRestart.config.restartWarningTimes[i];
        if (delaySeconds - (long)announcementDelay > 0L) {
            return scheduler.schedule(() -> server.execute(() -> RestartScheduler.announceRestart(server, announcementDelay)), delaySeconds - (long)announcementDelay, TimeUnit.SECONDS);
        }
        return null;
    }

    public static void announceRestart(MinecraftServer server, int secondsToRestart) {
        if (secondsToRestart == 0) {
            return;
        }
        StringBuilder message = new StringBuilder("The server will restart in ");
        Duration timeToRestart = Duration.ofSeconds(secondsToRestart);
        message = RestartScheduler.formatRestartWarning(RestartScheduler.constructRestartWarning(timeToRestart, message));
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(class_2561.method_30163((String)("[Server] " + String.valueOf(message))), false);
        }
        ScheduledRestart.logInfo(message.toString());
    }

    private static StringBuilder formatRestartWarning(StringBuilder message) {
        StringBuilder messageBuilder;
        message.delete(message.toString().length() - 2, message.toString().length()).append(".");
        int lastCommaIndex = message.lastIndexOf(",");
        if (lastCommaIndex < 0) {
            messageBuilder = message;
        } else {
            messageBuilder = new StringBuilder();
            messageBuilder.append(message, 0, lastCommaIndex).append(" and").append(message, lastCommaIndex + 1, message.toString().length());
        }
        return messageBuilder;
    }

    private static StringBuilder constructRestartWarning(Duration timeToRestart, StringBuilder message) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append((CharSequence)message);
        RestartScheduler.constructRestartWarningSegment(messageBuilder, timeToRestart.toDaysPart(), "day", "days");
        RestartScheduler.constructRestartWarningSegment(messageBuilder, timeToRestart.toHoursPart(), "hour", "hours");
        RestartScheduler.constructRestartWarningSegment(messageBuilder, timeToRestart.toMinutesPart(), "minute", "minutes");
        RestartScheduler.constructRestartWarningSegment(messageBuilder, timeToRestart.toSecondsPart(), "second", "seconds");
        return messageBuilder;
    }

    private static void constructRestartWarningSegment(StringBuilder message, long timespan, String singular, String plural) {
        if (timespan > 0L) {
            message.append(timespan).append(" ").append(timespan == 1L ? singular : plural).append(", ");
        }
    }

    public static enum RestartChannel {
        ManualRestart,
        AutoRestart,
        NoPlayerRestart;

    }
}

