/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart;

import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import samcask.scheduledrestart.RestartAutoScheduler;
import samcask.scheduledrestart.RestartCommand;
import samcask.scheduledrestart.RestartConfig;
import samcask.scheduledrestart.RestartNoPlayerScheduler;

public class ScheduledRestart
implements ModInitializer {
    public static final String MOD_ID = "scheduled-restart";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"scheduled-restart");
    public static RestartConfig config;

    public void onInitialize() {
        AutoConfig.register(RestartConfig.class, JanksonConfigSerializer::new);
        config = (RestartConfig)AutoConfig.getConfigHolder(RestartConfig.class).getConfig();
        CommandRegistrationCallback.EVENT.register(RestartCommand::register);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (ScheduledRestart.config.restartScheduleType.equals("daily") && ScheduledRestart.config.restartInterval > 0) {
                RestartAutoScheduler.scheduleAutoRestartDaily(server, ScheduledRestart.config.dailyRestartTimes);
            } else if (ScheduledRestart.config.restartScheduleType.equals("interval") && ScheduledRestart.config.restartInterval > 0) {
                RestartAutoScheduler.scheduleAutoRestartInterval(server, ScheduledRestart.config.restartInterval);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(RestartNoPlayerScheduler::finalPlayerDisconnected);
    }

    public static void logInfo(String message) {
        LOGGER.info("[ScheduledRestartMod] - " + message);
    }

    public static void logError(String message) {
        LOGGER.error("[ScheduledRestartMod] - " + message);
    }
}

