/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart;

import java.io.File;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import samcask.scheduledrestart.config.OldConfigData;
import samcask.scheduledrestart.config.RestartConfig;
import samcask.scheduledrestart.scheduling.AutoRestart;
import samcask.scheduledrestart.scheduling.ManualRestart;
import samcask.scheduledrestart.scheduling.NoPlayerRestart;

public class ScheduledRestart
implements ModInitializer {
    public static final String MOD_ID = "scheduled-restart";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"scheduled-restart");
    public static RestartConfig CONFIG;

    public void onInitialize() {
        Path configPath = FabricLoader.getInstance().getConfigDir();
        File configFile = configPath.resolve("scheduled-restart.properties").toFile();
        Path oldConfigPath = configPath.resolve("scheduled-restart.json5");
        if (oldConfigPath.toFile().isFile()) {
            try {
                OldConfigData OLD_CONFIG = new OldConfigData(oldConfigPath);
                CONFIG = new RestartConfig(configFile, OLD_CONFIG);
            }
            catch (Exception e) {
                ScheduledRestart.logInfo(e.toString());
                CONFIG = new RestartConfig(configFile);
            }
            oldConfigPath.toFile().delete();
        } else {
            CONFIG = new RestartConfig(configFile);
        }
        CommandRegistrationCallback.EVENT.register(ManualRestart::register);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (ScheduledRestart.CONFIG.restartScheduleType.equals("daily") && ScheduledRestart.CONFIG.restartInterval > 0) {
                AutoRestart.scheduleAutoRestartDaily(server, ScheduledRestart.CONFIG.dailyRestartTimes);
            } else if (ScheduledRestart.CONFIG.restartScheduleType.equals("interval") && ScheduledRestart.CONFIG.restartInterval > 0) {
                AutoRestart.scheduleAutoRestartInterval(server, ScheduledRestart.CONFIG.restartInterval);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(NoPlayerRestart::finalPlayerDisconnected);
    }

    public static void logInfo(String message) {
        LOGGER.info("[ScheduledRestartMod] - " + message);
    }

    public static void logError(String message) {
        LOGGER.error("[ScheduledRestartMod] - " + message);
    }

    public static void sendAnnouncement(MinecraftServer server, String message, boolean logMessage) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.method_7353(class_2561.method_30163((String)("[Server] " + message)), false);
        }
        if (logMessage) {
            ScheduledRestart.logInfo(message);
        }
    }
}

