/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Properties;
import java.util.function.Function;
import samcask.scheduledrestart.ScheduledRestart;

public abstract class ConfigData {
    private Properties properties;
    private ArrayList<ConfigProperty<?>> propertyList = new ArrayList();

    protected void loadProperties(File configFile) {
        this.properties = new Properties();
        try (FileInputStream input2 = new FileInputStream(configFile);){
            this.properties.load(input2);
        }
        catch (FileNotFoundException input2) {
        }
        catch (Exception e) {
            ScheduledRestart.logError("Failed to read config file: " + String.valueOf(e));
        }
    }

    protected abstract void setConfigDataValues();

    protected void saveProperties(File configFile) {
        try {
            StringBuilder newConfig = new StringBuilder();
            for (ConfigProperty<?> property : this.propertyList) {
                newConfig.append(property);
            }
            configFile.delete();
            configFile.getParentFile().mkdirs();
            Files.createFile(configFile.toPath(), new FileAttribute[0]);
            PrintWriter writer = new PrintWriter(configFile, StandardCharsets.UTF_8);
            writer.write(newConfig.toString());
            writer.close();
        }
        catch (Exception e) {
            ScheduledRestart.logError("Failed to write to config file: " + String.valueOf(e));
        }
    }

    protected String addStringProperty(String key, String defaultValue, String comment) {
        StringProperty property = new StringProperty(this, key, defaultValue, comment);
        this.propertyList.add(property);
        property.load();
        return (String)property.value;
    }

    protected Integer addIntegerProperty(String key, String defaultValue, String comment) {
        IntegerProperty property = new IntegerProperty(this, key, defaultValue, comment);
        this.propertyList.add(property);
        property.load();
        return (Integer)property.value;
    }

    protected LocalTime addTimeProperty(String key, String defaultValue, String comment) {
        TimeProperty property = new TimeProperty(this, key, defaultValue, comment);
        this.propertyList.add(property);
        property.load();
        return (LocalTime)property.value;
    }

    protected ArrayList<Integer> addIntegerArrayProperty(String key, String defaultValue, String comment) {
        IntegerArrayProperty property = new IntegerArrayProperty(this, key, defaultValue, comment);
        this.propertyList.add(property);
        property.load();
        return (ArrayList)property.value;
    }

    protected ArrayList<LocalTime> addTimeArrayProperty(String key, String defaultValue, String comment) {
        TimeArrayProperty property = new TimeArrayProperty(this, key, defaultValue, comment);
        this.propertyList.add(property);
        property.load();
        return (ArrayList)property.value;
    }

    protected static <T> ArrayList<T> parseArray(String value, Function<String, T> parse) {
        String[] items = value.replaceAll("[\\[\\]\"\\s]", "").split(",");
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < items.length; ++i) {
            values.add(parse.apply(items[i]));
        }
        return values;
    }

    protected abstract class ConfigProperty<T> {
        public T value;
        private final String key;
        private final String defaultValue;
        private final String comment;

        private ConfigProperty(String key, String defaultValue, String comment) {
            this.key = key;
            this.defaultValue = defaultValue;
            this.comment = comment;
        }

        public void load() {
            try {
                this.value = this.parse(ConfigData.this.properties.getProperty(this.key).replaceAll("^ +| +$", ""));
            }
            catch (Exception e) {
                this.value = this.parse(this.defaultValue);
            }
        }

        protected abstract T parse(String var1);

        public String toString() {
            return "# " + this.comment.replaceAll("\n", "\n# ") + "\n" + this.key + "=" + String.valueOf(this.value) + "\n\n";
        }
    }

    protected class StringProperty
    extends ConfigProperty<String> {
        private StringProperty(ConfigData this$0, String key, String defaultValue, String comment) {
            super(key, defaultValue, comment);
        }

        @Override
        protected String parse(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            return value.replaceAll("\"", "");
        }
    }

    protected class IntegerProperty
    extends ConfigProperty<Integer> {
        private IntegerProperty(ConfigData this$0, String key, String defaultValue, String comment) {
            super(key, defaultValue, comment);
        }

        @Override
        protected Integer parse(String value) {
            return Integer.parseInt(value);
        }
    }

    protected class TimeProperty
    extends ConfigProperty<LocalTime> {
        private TimeProperty(ConfigData this$0, String key, String defaultValue, String comment) {
            super(key, defaultValue, comment);
        }

        @Override
        protected LocalTime parse(String value) {
            return LocalTime.parse(value);
        }
    }

    protected class IntegerArrayProperty
    extends ArrayProperty<Integer> {
        protected IntegerArrayProperty(ConfigData this$0, String key, String defaultValue, String comment) {
            super(this$0, key, defaultValue, comment);
        }

        @Override
        protected Integer parseElement(String value) {
            return Integer.parseInt(value);
        }
    }

    protected class TimeArrayProperty
    extends ArrayProperty<LocalTime> {
        protected TimeArrayProperty(ConfigData this$0, String key, String defaultValue, String comment) {
            super(this$0, key, defaultValue, comment);
        }

        @Override
        protected LocalTime parseElement(String value) {
            return LocalTime.parse(value);
        }
    }

    protected abstract class ArrayProperty<T>
    extends ConfigProperty<ArrayList<T>> {
        private ArrayProperty(ConfigData this$0, String key, String defaultValue, String comment) {
            super(key, defaultValue, comment);
        }

        @Override
        protected ArrayList<T> parse(String value) {
            return ConfigData.parseArray(value, this::parseElement);
        }

        protected abstract T parseElement(String var1);
    }
}

