/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart.config;

import java.io.File;
import java.time.LocalTime;
import java.util.ArrayList;
import samcask.scheduledrestart.config.ConfigData;
import samcask.scheduledrestart.config.OldConfigData;

public class RestartConfig
extends ConfigData {
    public String startScriptPath;
    public String kickMessage;
    public String restartScheduleType;
    public ArrayList<LocalTime> dailyRestartTimes;
    public int restartInterval;
    public ArrayList<Integer> restartWarningTimes;
    public int noPlayerRestartDelay;
    private String startScriptPathDefault = "";
    private String kickMessageDefault = "The server is restarting";
    private String restartScheduleTypeDefault = "daily";
    private String dailyRestartTimesDefault = "00:00";
    private String restartIntervalDefault = "86400";
    private String restartWarningTimesDefault = "300,30";
    private String noPlayerRestartDelayDefault = "3600";

    public RestartConfig(File configFile) {
        this.loadProperties(configFile);
        this.setConfigDataValues();
        this.saveProperties(configFile);
    }

    @Deprecated
    public RestartConfig(File configFile, OldConfigData oldConfigData) {
        this.loadProperties(configFile);
        this.loadOldConfigData(oldConfigData);
        this.setConfigDataValues();
        this.saveProperties(configFile);
    }

    @Deprecated
    private void loadOldConfigData(OldConfigData oldConfigData) {
        this.startScriptPathDefault = oldConfigData.extractString("startScriptPath", this.startScriptPathDefault);
        this.kickMessageDefault = oldConfigData.extractString("kickMessage", this.kickMessageDefault);
        this.restartScheduleTypeDefault = oldConfigData.extractString("restartScheduleType", this.restartScheduleTypeDefault);
        this.dailyRestartTimesDefault = oldConfigData.extractTimeArray("dailyRestartTimes", this.dailyRestartTimesDefault);
        this.restartIntervalDefault = oldConfigData.extractInteger("restartInterval", this.restartIntervalDefault);
        this.restartWarningTimesDefault = oldConfigData.extractIntegerArray("restartWarningTimes", this.restartWarningTimesDefault);
        this.noPlayerRestartDelayDefault = oldConfigData.extractInteger("noPlayerRestartDelay", this.noPlayerRestartDelayDefault);
    }

    @Override
    protected void setConfigDataValues() {
        this.startScriptPath = this.addStringProperty("start-script-path", this.startScriptPathDefault, "Name of script file to start the server.\nIf left blank, defaults to start.bat on windows, or start.sh otherwise.");
        this.kickMessage = this.addStringProperty("kick-message", this.kickMessageDefault, "Message displayed to kicked players on server restart.");
        this.restartScheduleType = this.addStringProperty("restart-schedule-type", this.restartScheduleTypeDefault, "Which type of automatic restart scheduling to use. Leave blank to disable automatic scheduled restarts.");
        this.dailyRestartTimes = this.addTimeArrayProperty("daily-restart-times", this.dailyRestartTimesDefault, "Restarts the server at these times each day.\nOnly works if restartScheduleType is set to \"daily\".");
        this.restartInterval = this.addIntegerProperty("restart-interval", this.restartIntervalDefault, "Restarts the server after it has been online for this many seconds.\nOnly works if restartScheduleType is set to \"interval\".");
        this.restartWarningTimes = this.addIntegerArrayProperty("restart-warning-times", this.restartWarningTimesDefault, "How many seconds in advance all players should be warned before a scheduled server restart.");
        this.noPlayerRestartDelay = this.addIntegerProperty("no-player-restart-delay", this.noPlayerRestartDelayDefault, "Automatically restarts the server after no players have been online for this many seconds.\nSet to 0 to disable.");
    }
}

