/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart.scheduling;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import samcask.scheduledrestart.ScheduledRestart;
import samcask.scheduledrestart.scheduling.RestartScheduler;

public class AutoRestart {
    static LocalDateTime currentTime;
    static LocalDateTime restartTime;

    public static void scheduleAutoRestartInterval(MinecraftServer server, long delaySeconds) {
        if (delaySeconds == 0L) {
            ScheduledRestart.logInfo("Failed to schedule interval restart, no interval set.");
            return;
        }
        RestartScheduler.scheduleRestart(server, delaySeconds, RestartScheduler.RestartChannel.AutoRestart);
    }

    public static void scheduleAutoRestartDaily(MinecraftServer server, ArrayList<LocalTime> times) {
        if (times.isEmpty()) {
            ScheduledRestart.logInfo("Failed to schedule daily restart, no times set");
            return;
        }
        AutoRestart.initialiseTimes(times);
        RestartScheduler.scheduleRestart(server, AutoRestart.getTimeToNextDailyRestart(times), RestartScheduler.RestartChannel.AutoRestart);
    }

    private static void initialiseTimes(ArrayList<LocalTime> times) {
        currentTime = LocalDateTime.now();
        for (int i = 0; i < times.size(); ++i) {
            LocalDateTime nextRestartTime = LocalDateTime.now().with(times.get(i));
            while (currentTime.isAfter(nextRestartTime)) {
                nextRestartTime = nextRestartTime.plusDays(1L);
            }
            if (i != 0 && !restartTime.isAfter(nextRestartTime)) continue;
            restartTime = nextRestartTime;
        }
    }

    private static int getTimeToNextDailyRestart(ArrayList<LocalTime> times) {
        int delay;
        int smallestDelay = delay = (int)Duration.between(currentTime, restartTime).toSeconds();
        for (int i = 1; i < times.size(); ++i) {
            restartTime = LocalDateTime.now().with(times.get(i));
            if (currentTime.isAfter(restartTime)) {
                restartTime = restartTime.plusDays(1L);
            }
            if ((delay = (int)Duration.between(currentTime, restartTime).toSeconds()) >= smallestDelay) continue;
            smallestDelay = delay;
        }
        return smallestDelay;
    }
}

