/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart.scheduling;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import samcask.scheduledrestart.ScheduledRestart;

public class RestartHandler {
    static final String os = System.getProperty("os.name").toLowerCase();
    static final Path rootPath = Path.of(".", new String[0]);
    static String startupScriptPath = RestartHandler.getStartupScriptPath();

    public static int restart(MinecraftServer server) {
        if (!RestartHandler.doesStartupScriptExist()) {
            return 0;
        }
        String[] command = RestartHandler.constructRestartCommand();
        RestartHandler.disconnectPlayers(server);
        RestartHandler.stopServerWithRestart(server, command);
        return 1;
    }

    private static boolean doesStartupScriptExist() {
        try {
            if (!Files.exists(rootPath.toRealPath(new LinkOption[0]).resolve(startupScriptPath), new LinkOption[0])) {
                ScheduledRestart.logError("Start script not found");
                return false;
            }
        }
        catch (IOException e) {
            ScheduledRestart.logError("Error while locating startup script: " + String.valueOf(e));
            return false;
        }
        return true;
    }

    private static String[] constructRestartCommand() {
        if (os.contains("win")) {
            return new String[]{"cmd", "/c", "start", "", startupScriptPath};
        }
        return new String[]{"bash", startupScriptPath};
    }

    private static void disconnectPlayers(MinecraftServer server) {
        ScheduledRestart.logInfo("Disconnecting players...");
        try {
            for (class_3222 player : server.method_3760().method_14571()) {
                player.field_13987.method_52396(class_2561.method_30163((String)ScheduledRestart.CONFIG.kickMessage));
            }
            ScheduledRestart.logInfo("Successfully disconnected all players");
        }
        catch (Exception e) {
            ScheduledRestart.logError("Error while disconnecting players: " + String.valueOf(e));
        }
    }

    private static void stopServerWithRestart(MinecraftServer server, String[] command) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Runtime.getRuntime().exec(command, null, rootPath.toFile());
            }
            catch (IOException e) {
                ScheduledRestart.logError("Error while adding shutdown hook: " + String.valueOf(e));
            }
        }));
        ScheduledRestart.logInfo("Restarting server...");
        server.method_3747(false);
    }

    private static String getStartupScriptPath() {
        String startScriptPath = ScheduledRestart.CONFIG.startScriptPath;
        if (startScriptPath.isEmpty()) {
            if (os.contains("win")) {
                return "start.bat";
            }
            return "start.sh";
        }
        return startScriptPath;
    }
}

