/*
 * Decompiled with CFR 0.152.
 */
package samcask.scheduledrestart.scheduling;

import java.time.LocalDateTime;
import java.util.Dictionary;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import samcask.scheduledrestart.ScheduledRestart;
import samcask.scheduledrestart.scheduling.RestartAnnouncer;
import samcask.scheduledrestart.scheduling.RestartHandler;

public class RestartScheduler {
    static final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "RestartScheduler");
        t.setDaemon(true);
        return t;
    });
    static Dictionary<RestartChannel, ScheduledFuture<?>> scheduledRestarts;
    static Dictionary<RestartChannel, ScheduledFuture<?>[]> scheduledAnnouncements;

    public static int scheduleRestart(MinecraftServer server, long secondsUntilRestart, RestartChannel restartChannel) {
        RestartScheduler.cancelScheduledRestart(restartChannel);
        scheduledRestarts.put(restartChannel, RestartScheduler.createScheduledRestart(server, secondsUntilRestart));
        RestartScheduler.scheduleAnnouncements(server, secondsUntilRestart, restartChannel);
        ScheduledRestart.logInfo("New restart scheduled on channel " + String.valueOf((Object)restartChannel) + " at time " + String.valueOf(LocalDateTime.now().plusSeconds(secondsUntilRestart)));
        return 1;
    }

    private static ScheduledFuture<?> createScheduledRestart(MinecraftServer server, long secondsUntilRestart) {
        return scheduler.schedule(() -> server.execute(() -> RestartHandler.restart(server)), secondsUntilRestart, TimeUnit.SECONDS);
    }

    public static int cancelScheduledRestart(RestartChannel restartChannel) {
        ScheduledFuture<?> scheduledRestart = scheduledRestarts.get((Object)restartChannel);
        if (scheduledRestart == null || scheduledRestart.isDone()) {
            return 0;
        }
        scheduledRestart.cancel(false);
        RestartScheduler.cancelScheduledAnnouncements(restartChannel);
        ScheduledRestart.logInfo("Cancelled existing scheduled restart on channel " + String.valueOf((Object)restartChannel));
        return 1;
    }

    private static void scheduleAnnouncements(MinecraftServer server, long secondsUntilRestart, RestartChannel restartChannel) {
        ScheduledFuture[] newAnnouncements = new ScheduledFuture[ScheduledRestart.CONFIG.restartWarningTimes.size()];
        for (int i = 0; i < newAnnouncements.length; ++i) {
            newAnnouncements[i] = RestartScheduler.createScheduledAnnouncement(server, secondsUntilRestart, ScheduledRestart.CONFIG.restartWarningTimes.get(i));
        }
        scheduledAnnouncements.put(restartChannel, newAnnouncements);
    }

    private static ScheduledFuture<?> createScheduledAnnouncement(MinecraftServer server, long secondsUntilRestart, int secondsInAdvance) {
        if (secondsUntilRestart - (long)secondsInAdvance > 0L) {
            return scheduler.schedule(() -> server.execute(() -> RestartAnnouncer.announceRestart(server, secondsInAdvance)), secondsUntilRestart - (long)secondsInAdvance, TimeUnit.SECONDS);
        }
        return null;
    }

    private static void cancelScheduledAnnouncements(RestartChannel restartChannel) {
        if (scheduledAnnouncements.get((Object)restartChannel) == null) {
            return;
        }
        for (ScheduledFuture<?> scheduledAnnouncement : scheduledAnnouncements.get((Object)restartChannel)) {
            if (scheduledAnnouncement == null) continue;
            scheduledAnnouncement.cancel(false);
        }
    }

    public static enum RestartChannel {
        ManualRestart,
        AutoRestart,
        NoPlayerRestart;

    }
}

