/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.features;

import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.events.ChatPlusMinuteEvent;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.AlignMessage;
import com.ebicep.chatplus.features.chattabs.AddNewMessageEvent;
import com.ebicep.chatplus.features.chattabs.ChatTab;
import com.ebicep.chatplus.features.chattabs.ChatTabAddDisplayMessageEvent;
import com.ebicep.chatplus.features.chattabs.ChatTabGetMessageAtEvent;
import com.ebicep.chatplus.features.chattabs.MessageAtType;
import com.ebicep.chatplus.features.chattabs.ValuesXY;
import com.ebicep.chatplus.features.chatwindows.ChatWindow;
import com.ebicep.chatplus.hud.ChatManager;
import com.ebicep.chatplus.hud.ChatRenderLineTextEvent;
import com.ebicep.chatplus.util.GraphicsUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u00068\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\nR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R \u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/ebicep/chatplus/features/PlayerHeadChatDisplay;", "", "<init>", "()V", "Lcom/ebicep/chatplus/features/chatwindows/ChatWindow;", "chatWindow", "", "getMessageOffset", "(Lcom/ebicep/chatplus/features/chatwindows/ChatWindow;)I", "CACHE_EXPIRATION", "I", "HEAD_RIGHT_PADDING", "HEAD_WIDTH_PADDED", "HEAD_WIDTH_PADDED_HALF", "Lkotlin/text/Regex;", "NAME_REGEX", "Lkotlin/text/Regex;", "", "", "Lcom/ebicep/chatplus/features/PlayerHeadChatDisplay$TimedUUID;", "playerNameUUIDs", "Ljava/util/Map;", "Ljava/util/UUID;", "Lcom/ebicep/chatplus/features/PlayerHeadChatDisplay$HeadData;", "playerHeads", "TimedUUID", "HeadData", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nPlayerHeadChatDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerHeadChatDisplay.kt\ncom/ebicep/chatplus/features/PlayerHeadChatDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 GraphicsUtil.kt\ncom/ebicep/chatplus/util/GraphicsUtil\n+ 4 EventBus.kt\ncom/ebicep/chatplus/events/EventBus\n*L\n1#1,163:1\n1863#2,2:164\n57#3,4:166\n57#4,5:170\n57#4,5:175\n57#4,5:180\n57#4,5:185\n57#4,5:190\n*S KotlinDebug\n*F\n+ 1 PlayerHeadChatDisplay.kt\ncom/ebicep/chatplus/features/PlayerHeadChatDisplay\n*L\n58#1:164,2\n106#1:166,4\n40#1:170,5\n52#1:175,5\n76#1:180,5\n124#1:185,5\n130#1:190,5\n*E\n"})
public final class PlayerHeadChatDisplay {
    @NotNull
    public static final PlayerHeadChatDisplay INSTANCE;
    private static final int CACHE_EXPIRATION = 600000;
    private static final int HEAD_RIGHT_PADDING = 2;
    private static final int HEAD_WIDTH_PADDED = 10;
    private static final int HEAD_WIDTH_PADDED_HALF = 5;
    @NotNull
    private static final Regex NAME_REGEX;
    @NotNull
    private static final Map<String, TimedUUID> playerNameUUIDs;
    @NotNull
    private static final Map<UUID, HeadData> playerHeads;

    private PlayerHeadChatDisplay() {
    }

    private final int getMessageOffset(ChatWindow chatWindow) {
        return switch (WhenMappings.$EnumSwitchMapping$0[chatWindow.getGeneralSettings().getMessageAlignment().ordinal()]) {
            case 1 -> 10;
            case 2 -> 5;
            case 3 -> 0;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final boolean lambda$2$lambda$0(long $currentTime, Map.Entry entry) {
        boolean remove;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        boolean bl = remove = $currentTime - ((TimedUUID)entry.getValue()).getLastUsed() > 600000L;
        if (remove) {
            playerHeads.remove(((TimedUUID)entry.getValue()).getUuid());
        }
        return remove;
    }

    private static final boolean lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$2(ChatPlusMinuteEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getMinute() % (long)10 == 0L) {
            long currentTime = System.currentTimeMillis();
            playerNameUUIDs.entrySet().removeIf(arg_0 -> PlayerHeadChatDisplay.lambda$2$lambda$1(arg_0 -> PlayerHeadChatDisplay.lambda$2$lambda$0(currentTime, arg_0), arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final ResourceLocation lambda$6$lambda$5$lambda$4(PlayerInfo $playerInfo) {
        ResourceLocation resourceLocation = $playerInfo.getSkin().texture();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"texture(...)");
        return resourceLocation;
    }

    private static final Unit _init_$lambda$6(AddNewMessageEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getPlayerHeadChatDisplayEnabled()) {
            return Unit.INSTANCE;
        }
        String content = it.getRawComponent().getString();
        ClientPacketListener clientPacketListener = Minecraft.getInstance().getConnection();
        if (clientPacketListener == null) {
            return Unit.INSTANCE;
        }
        ClientPacketListener connection = clientPacketListener;
        Intrinsics.checkNotNull((Object)content);
        CharSequence charSequence = content;
        Regex regex = NAME_REGEX;
        int n = 0;
        Iterable $this$forEach$iv = regex.split(charSequence, n);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String word = (String)element$iv;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)word)) continue;
            TimedUUID timedUUID = playerNameUUIDs.get(word);
            if (timedUUID != null) {
                TimedUUID timedUUID2 = timedUUID;
                boolean bl2 = false;
                it.setSenderUUID(timedUUID2.getUuid());
                return Unit.INSTANCE;
            }
            PlayerInfo playerInfo = connection.getPlayerInfo(word);
            if (playerInfo == null) continue;
            UUID uuid = playerInfo.getProfile().getId();
            Intrinsics.checkNotNull((Object)uuid);
            playerNameUUIDs.put(word, new TimedUUID(uuid, System.currentTimeMillis()));
            Map<UUID, HeadData> map = playerHeads;
            ClientLevel clientLevel = Minecraft.getInstance().level;
            HeadData headData = new HeadData((Function0<ResourceLocation>)((Function0)() -> PlayerHeadChatDisplay.lambda$6$lambda$5$lambda$4(playerInfo)), clientLevel != null && (clientLevel = clientLevel.getPlayerByUUID(uuid)) != null ? clientLevel.isModelPartShown(PlayerModelPart.HAT) : false);
            map.put(uuid, headData);
            it.setSenderUUID(uuid);
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(ChatRenderLineTextEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getPlayerHeadChatDisplayEnabled()) {
            return Unit.INSTANCE;
        }
        ChatTab.ChatPlusGuiMessageLine chatPlusGuiMessageLine = it.getChatPlusGuiMessageLine();
        GuiGraphics guiGraphics = it.getGuiGraphics();
        PoseStack poseStack = guiGraphics.pose();
        int messageOffset = INSTANCE.getMessageOffset(it.getChatWindow());
        if (!Config.INSTANCE.getValues().getPlayerHeadChatDisplayShowOnWrapped() && chatPlusGuiMessageLine.getWrappedIndex() != 0) {
            if (Config.INSTANCE.getValues().getPlayerHeadChatDisplayOffsetNonHeadMessagesShowOnWrapped()) {
                Intrinsics.checkNotNull((Object)poseStack);
                GraphicsUtil.translate0$default(GraphicsUtil.INSTANCE, poseStack, messageOffset, 0, 0, 6, null);
            }
            return Unit.INSTANCE;
        }
        ChatTab.ChatPlusGuiMessage chatPlusGuiMessage = chatPlusGuiMessageLine.getLinkedMessage();
        UUID senderUUID = chatPlusGuiMessage.getSenderUUID();
        if (senderUUID == null) {
            if (Config.INSTANCE.getValues().getPlayerHeadChatDisplayOffsetNonHeadMessages()) {
                Intrinsics.checkNotNull((Object)poseStack);
                GraphicsUtil.translate0$default(GraphicsUtil.INSTANCE, poseStack, messageOffset, 0, 0, 6, null);
            }
            return Unit.INSTANCE;
        }
        HeadData headData = playerHeads.get(senderUUID);
        if (headData == null) {
            if (Config.INSTANCE.getValues().getPlayerHeadChatDisplayOffsetNonHeadMessages()) {
                Intrinsics.checkNotNull((Object)poseStack);
                GraphicsUtil.translate0$default(GraphicsUtil.INSTANCE, poseStack, messageOffset, 0, 0, 6, null);
            }
            return Unit.INSTANCE;
        }
        Intrinsics.checkNotNull((Object)poseStack);
        GraphicsUtil.translate0$default(GraphicsUtil.INSTANCE, poseStack, messageOffset, 0, 0, 6, null);
        GraphicsUtil graphicsUtil = GraphicsUtil.INSTANCE;
        PoseStack $this$createPose$iv = poseStack;
        boolean $i$f$createPose = false;
        $this$createPose$iv.pushPose();
        boolean bl = false;
        GraphicsUtil.guiForward$default(GraphicsUtil.INSTANCE, poseStack, null, false, 3, null);
        GraphicsUtil.translate0$default(GraphicsUtil.INSTANCE, poseStack, -10.0, 0.0, 0.0, 6, null);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)it.getTextColor() / 255.0f));
        GraphicsUtil.PlayerHeadUtils.INSTANCE.playerFaceRendererDraw(guiGraphics, (ResourceLocation)headData.getTexture().invoke(), it.getChatWindow().getRenderer().getRescaledX(), it.getVerticalTextOffset(), 8.0f, headData.getShowHat(), false, -1);
        guiGraphics.flush();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        $this$createPose$iv.popPose();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(ChatTabAddDisplayMessageEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getPlayerHeadChatDisplayEnabled()) {
            return Unit.INSTANCE;
        }
        it.setMaxWidth(it.getMaxWidth() - 10);
        return Unit.INSTANCE;
    }

    private static final void lambda$11$lambda$10(ChatTabGetMessageAtEvent $it, ValuesXY valuesXY, ValuesXY current) {
        Intrinsics.checkNotNullParameter((Object)valuesXY, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        current.setX(current.getX() - (double)INSTANCE.getMessageOffset($it.getChatWindow()));
    }

    private static final Unit _init_$lambda$11(ChatTabGetMessageAtEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getPlayerHeadChatDisplayEnabled()) {
            return Unit.INSTANCE;
        }
        if (it.getMessageAtType() != MessageAtType.COMPONENT) {
            return Unit.INSTANCE;
        }
        ChatTab.ChatPlusGuiMessageLine chatPlusGuiMessageLine = ChatManager.INSTANCE.getGlobalSelectedTab().getHoveredOverMessageLine();
        if (chatPlusGuiMessageLine == null) {
            return Unit.INSTANCE;
        }
        ChatTab.ChatPlusGuiMessageLine messageLine = chatPlusGuiMessageLine;
        UUID senderUUID = messageLine.getLinkedMessage().getSenderUUID();
        if (senderUUID == null && !Config.INSTANCE.getValues().getPlayerHeadChatDisplayOffsetNonHeadMessages()) {
            return Unit.INSTANCE;
        }
        if (messageLine.getWrappedIndex() != 0 && !Config.INSTANCE.getValues().getPlayerHeadChatDisplayOffsetNonHeadMessagesShowOnWrapped()) {
            return Unit.INSTANCE;
        }
        it.getChatOperators().add((arg_0, arg_1) -> PlayerHeadChatDisplay.lambda$11$lambda$10(it, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    static {
        EventBus $this$iv;
        INSTANCE = new PlayerHeadChatDisplay();
        NAME_REGEX = new Regex("(\u00a7.)|\\W");
        playerNameUUIDs = new LinkedHashMap();
        playerHeads = new LinkedHashMap();
        EventBus eventBus = EventBus.INSTANCE;
        Function1 callback$iv = PlayerHeadChatDisplay::_init_$lambda$2;
        Function0 priority$iv = EventBus.register.1.INSTANCE;
        Function0 skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        boolean $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatPlusMinuteEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = PlayerHeadChatDisplay::_init_$lambda$6;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, AddNewMessageEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = PlayerHeadChatDisplay::_init_$lambda$8;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatRenderLineTextEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = PlayerHeadChatDisplay::_init_$lambda$9;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatTabAddDisplayMessageEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = PlayerHeadChatDisplay::_init_$lambda$11;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatTabGetMessageAtEvent.class, callback$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ*\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0010\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u0019\u0010\nR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001a\u001a\u0004\b\u001b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/ebicep/chatplus/features/PlayerHeadChatDisplay$HeadData;", "", "Lkotlin/Function0;", "Lnet/minecraft/resources/ResourceLocation;", "texture", "", "showHat", "<init>", "(Lkotlin/jvm/functions/Function0;Z)V", "component1", "()Lkotlin/jvm/functions/Function0;", "component2", "()Z", "copy", "(Lkotlin/jvm/functions/Function0;Z)Lcom/ebicep/chatplus/features/PlayerHeadChatDisplay$HeadData;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function0;", "getTexture", "Z", "getShowHat", "chatplus-common"})
    public static final class HeadData {
        @NotNull
        private final Function0<ResourceLocation> texture;
        private final boolean showHat;

        public HeadData(@NotNull Function0<ResourceLocation> texture, boolean showHat) {
            Intrinsics.checkNotNullParameter(texture, (String)"texture");
            this.texture = texture;
            this.showHat = showHat;
        }

        @NotNull
        public final Function0<ResourceLocation> getTexture() {
            return this.texture;
        }

        public final boolean getShowHat() {
            return this.showHat;
        }

        @NotNull
        public final Function0<ResourceLocation> component1() {
            return this.texture;
        }

        public final boolean component2() {
            return this.showHat;
        }

        @NotNull
        public final HeadData copy(@NotNull Function0<ResourceLocation> texture, boolean showHat) {
            Intrinsics.checkNotNullParameter(texture, (String)"texture");
            return new HeadData(texture, showHat);
        }

        public static /* synthetic */ HeadData copy$default(HeadData headData, Function0 function0, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                function0 = headData.texture;
            }
            if ((n & 2) != 0) {
                bl = headData.showHat;
            }
            return headData.copy(function0, bl);
        }

        @NotNull
        public String toString() {
            return "HeadData(texture=" + this.texture + ", showHat=" + this.showHat + ")";
        }

        public int hashCode() {
            int result = this.texture.hashCode();
            result = result * 31 + Boolean.hashCode(this.showHat);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HeadData)) {
                return false;
            }
            HeadData headData = (HeadData)other;
            if (!Intrinsics.areEqual(this.texture, headData.texture)) {
                return false;
            }
            return this.showHat == headData.showHat;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ$\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\tR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/ebicep/chatplus/features/PlayerHeadChatDisplay$TimedUUID;", "", "Ljava/util/UUID;", "uuid", "", "lastUsed", "<init>", "(Ljava/util/UUID;J)V", "component1", "()Ljava/util/UUID;", "component2", "()J", "copy", "(Ljava/util/UUID;J)Lcom/ebicep/chatplus/features/PlayerHeadChatDisplay$TimedUUID;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getUuid", "J", "getLastUsed", "chatplus-common"})
    public static final class TimedUUID {
        @NotNull
        private final UUID uuid;
        private final long lastUsed;

        public TimedUUID(@NotNull UUID uuid, long lastUsed) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            this.uuid = uuid;
            this.lastUsed = lastUsed;
        }

        @NotNull
        public final UUID getUuid() {
            return this.uuid;
        }

        public final long getLastUsed() {
            return this.lastUsed;
        }

        @NotNull
        public final UUID component1() {
            return this.uuid;
        }

        public final long component2() {
            return this.lastUsed;
        }

        @NotNull
        public final TimedUUID copy(@NotNull UUID uuid, long lastUsed) {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            return new TimedUUID(uuid, lastUsed);
        }

        public static /* synthetic */ TimedUUID copy$default(TimedUUID timedUUID, UUID uUID, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = timedUUID.uuid;
            }
            if ((n & 2) != 0) {
                l = timedUUID.lastUsed;
            }
            return timedUUID.copy(uUID, l);
        }

        @NotNull
        public String toString() {
            return "TimedUUID(uuid=" + this.uuid + ", lastUsed=" + this.lastUsed + ")";
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = result * 31 + Long.hashCode(this.lastUsed);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimedUUID)) {
                return false;
            }
            TimedUUID timedUUID = (TimedUUID)other;
            if (!Intrinsics.areEqual((Object)this.uuid, (Object)timedUUID.uuid)) {
                return false;
            }
            return this.lastUsed == timedUUID.lastUsed;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AlignMessage.Alignment.values().length];
            try {
                nArray[AlignMessage.Alignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlignMessage.Alignment.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlignMessage.Alignment.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

