/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.features.speechtotext;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.config.ConfigKt;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.internal.MessageFilterWithString;
import com.ebicep.chatplus.features.speechtotext.Microphone;
import com.ebicep.chatplus.features.speechtotext.MicrophoneException;
import com.ebicep.chatplus.features.speechtotext.MicrophoneThread$SpeechToTextReplace$;
import com.ebicep.chatplus.features.speechtotext.SpeechToText;
import com.ebicep.chatplus.hud.ChatManager;
import com.ebicep.chatplus.hud.ChatPlusScreen;
import com.ebicep.chatplus.hud.ChatScreenCloseEvent;
import com.ebicep.chatplus.hud.ChatScreenInitPreEvent;
import com.ebicep.chatplus.mixin.IMixinChatScreen;
import com.ebicep.chatplus.translator.Language;
import com.ebicep.chatplus.translator.LanguageManager;
import com.ebicep.chatplus.translator.TranslateResult;
import com.ebicep.chatplus.translator.Translator;
import com.ebicep.chatplus.util.GraphicsUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vosk.Model;
import org.vosk.Recognizer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0017\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001:\u000223B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\t\u001a\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\u0003J\r\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u000f\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\b\b\u0002\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u0016\u0010 \u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010\u001eR\u0018\u0010!\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0018\u0010$\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0018\u0010&\u001a\u0004\u0018\u00010\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010-\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0014\u00101\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100\u00a8\u00064"}, d2={"Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread;", "Ljava/lang/Thread;", "<init>", "()V", "Lkotlin/Function2;", "", "", "", "toRun", "doWithMessage", "(Lkotlin/jvm/functions/Function2;)V", "resetRecognizer", "resetMicrophone", "run", "sleep", "", "readMic", "()[S", "data", "speechToText", "([S)Ljava/lang/String;", "Lcom/ebicep/chatplus/features/speechtotext/Microphone;", "getMicrophone", "()Lcom/ebicep/chatplus/features/speechtotext/Microphone;", "input", "", "searchDepth", "replacePlayer", "(Ljava/lang/String;I)Ljava/lang/String;", "listening", "Z", "running", "disabled", "microphone", "Lcom/ebicep/chatplus/features/speechtotext/Microphone;", "Lorg/vosk/Recognizer;", "recognizer", "Lorg/vosk/Recognizer;", "lastSpokenMessage", "Ljava/lang/String;", "", "", "totalData", "Ljava/util/List;", "", "quickSendTimer", "J", "getCanQuickSend", "()Z", "canQuickSend", "MatchedPlayer", "SpeechToTextReplace", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nSpeechToText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpeechToText.kt\ncom/ebicep/chatplus/features/speechtotext/MicrophoneThread\n+ 2 EventBus.kt\ncom/ebicep/chatplus/events/EventBus\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 GraphicsUtil.kt\ncom/ebicep/chatplus/util/GraphicsUtil\n*L\n1#1,461:1\n57#2,5:462\n57#2,5:467\n1053#3:472\n774#3:473\n865#3,2:474\n1863#3,2:476\n1557#3:478\n1628#3,3:479\n1557#3:482\n1628#3,3:483\n774#3:486\n865#3,2:487\n57#4,4:489\n57#4,4:493\n*S KotlinDebug\n*F\n+ 1 SpeechToText.kt\ncom/ebicep/chatplus/features/speechtotext/MicrophoneThread\n*L\n167#1:462,5\n192#1:467,5\n326#1:472\n327#1:473\n327#1:474,2\n328#1:476,2\n414#1:478\n414#1:479,3\n415#1:482\n415#1:483,3\n421#1:486\n421#1:487,2\n206#1:489,4\n214#1:493,4\n*E\n"})
public final class MicrophoneThread
extends Thread {
    private boolean listening;
    private volatile boolean running = true;
    private volatile boolean disabled;
    @Nullable
    private volatile Microphone microphone;
    @Nullable
    private volatile Recognizer recognizer;
    @Nullable
    private String lastSpokenMessage;
    @NotNull
    private List<Short> totalData = new ArrayList();
    private long quickSendTimer;

    public MicrophoneThread() {
        super("ChatPlusMicrophoneThread");
        EventBus $this$iv;
        ChatPlus.INSTANCE.getLOGGER().info("SpeechToText initialized");
        EventBus eventBus = EventBus.INSTANCE;
        Function1 callback$iv = arg_0 -> MicrophoneThread._init_$lambda$1(this, arg_0);
        Function0 priority$iv = EventBus.register.1.INSTANCE;
        Function0 skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        boolean $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatScreenInitPreEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = arg_0 -> MicrophoneThread._init_$lambda$2(this, arg_0);
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatScreenCloseEvent.class, callback$iv);
        ClientGuiEvent.RENDER_HUD.register((arg_0, arg_1) -> MicrophoneThread._init_$lambda$5(this, arg_0, arg_1));
        ClientRawInputEvent.KEY_PRESSED.register((arg_0, arg_1, arg_2, arg_3, arg_4) -> MicrophoneThread._init_$lambda$7(this, arg_0, arg_1, arg_2, arg_3, arg_4));
    }

    private final boolean getCanQuickSend() {
        return this.quickSendTimer > System.currentTimeMillis() && this.lastSpokenMessage != null;
    }

    private final void doWithMessage(Function2<? super String, ? super Boolean, Unit> toRun) {
        block2: {
            String string = this.lastSpokenMessage;
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            Language speechToTextLang = SpeechToText.INSTANCE.getSpeechToTextLang();
            if (Config.INSTANCE.getValues().getSpeechToTextTranslateEnabled() && speechToTextLang != null) {
                Language language = LanguageManager.INSTANCE.getAutoLang();
                new Translator(it, speechToTextLang, toRun, language){
                    final /* synthetic */ Function2<String, Boolean, Unit> $toRun;
                    {
                        this.$toRun = $toRun;
                        super($it, $super_call_param$1, $speechToTextLang, false);
                    }

                    public void onTranslate(String matchedRegex, TranslateResult translatedMessage, String fromLanguage) {
                        Intrinsics.checkNotNullParameter((Object)translatedMessage, (String)"translatedMessage");
                        this.$toRun.invoke((Object)translatedMessage.getTranslatedText(), (Object)true);
                    }
                }.start();
            } else {
                toRun.invoke((Object)it, (Object)false);
            }
        }
    }

    public final void resetRecognizer() {
        ChatPlus.INSTANCE.getLOGGER().info("Resetting Recognizer");
        this.disabled = false;
        this.recognizer = null;
    }

    public final void resetMicrophone() {
        ChatPlus.INSTANCE.getLOGGER().info("Resetting Microphone");
        this.disabled = false;
        this.microphone = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        ChatPlus.INSTANCE.getLOGGER().info("SpeechToText Thread started");
        while (this.running) {
            if (!Config.INSTANCE.getValues().getSpeechToTextEnabled() || this.disabled) {
                Thread.sleep(5000L);
                continue;
            }
            if (this.recognizer == null) {
                try {
                    this.recognizer = new Recognizer(new Model(ConfigKt.getConfigDirectoryPath() + "/models/" + Config.INSTANCE.getValues().getSpeechToTextSelectedAudioModel()), (float)SpeechToText.INSTANCE.getSAMPLE_RATE());
                    String recognizedModel = "Recognized Model: " + Config.INSTANCE.getValues().getSpeechToTextSelectedAudioModel();
                    ChatPlus.INSTANCE.getLOGGER().info(recognizedModel);
                    MutableComponent mutableComponent = Component.literal((String)recognizedModel).withStyle(MicrophoneThread::run$lambda$9);
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                    ChatPlus.INSTANCE.sendMessage((Component)mutableComponent);
                }
                catch (Exception e) {
                    MutableComponent mutableComponent = Component.literal((String)"Failed to load model, disabling Speech to Text.").withStyle(MicrophoneThread::run$lambda$10);
                    Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                    ChatPlus.INSTANCE.sendMessage((Component)mutableComponent);
                    ChatPlus.INSTANCE.getLOGGER().error((Object)e);
                    this.disabled = true;
                }
            }
            try {
                boolean recordMic = SpeechToText.INSTANCE.getRecordMic();
                if (recordMic && !this.listening) {
                    this.quickSendTimer = 0L;
                    this.totalData.clear();
                    ChatPlus.INSTANCE.getLOGGER().info("Started Recording");
                    Microphone microphone = this.getMicrophone();
                    if (microphone != null) {
                        microphone.startRecording();
                    }
                    this.listening = true;
                    continue;
                }
                if (!recordMic && this.listening) {
                    void $this$filterTo$iv$iv;
                    Object object;
                    String string;
                    String asString;
                    ChatPlus.INSTANCE.getLOGGER().info("Done Recording");
                    this.listening = false;
                    this.totalData.addAll(ArraysKt.toList((short[])this.readMic()));
                    ChatPlus.INSTANCE.getLOGGER().info("Data: " + this.totalData.size());
                    Microphone microphone = this.getMicrophone();
                    if (microphone != null) {
                        microphone.stopRecording();
                    }
                    this.speechToText(CollectionsKt.toShortArray((Collection)this.totalData));
                    Recognizer recognizer = this.recognizer;
                    Intrinsics.checkNotNull((Object)recognizer);
                    JsonElement jsonElement = JsonParser.parseString((String)recognizer.getFinalResult()).getAsJsonObject().get("text");
                    String string2 = asString = jsonElement != null ? jsonElement.getAsString() : null;
                    if (asString == null) {
                        string = null;
                    } else {
                        Charset charset;
                        Charset charset2 = Charset.forName(Config.INSTANCE.getValues().getSpeechToTextCharset());
                        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
                        byte[] byArray = asString.getBytes(charset2);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        object = byArray;
                        Intrinsics.checkNotNullExpressionValue((Object)StandardCharsets.UTF_8, (String)"UTF_8");
                        string = new String((byte[])object, charset);
                    }
                    this.lastSpokenMessage = string;
                    this.quickSendTimer = System.currentTimeMillis() + (long)3000;
                    ChatPlus.INSTANCE.getLOGGER().info("Final: " + this.lastSpokenMessage);
                    object = this.lastSpokenMessage;
                    if (object == null || StringsKt.isBlank((CharSequence)object)) continue;
                    Iterable $this$sortedBy$iv = Config.INSTANCE.getValues().getSpeechToTextReplace();
                    boolean $i$f$sortedBy = false;
                    Iterable $this$filter$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            SpeechToTextReplace it = (SpeechToTextReplace)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(-it.getPriority());
                            it = (SpeechToTextReplace)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(-it.getPriority()));
                        }
                    });
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        SpeechToTextReplace it = (SpeechToTextReplace)element$iv$iv;
                        boolean bl = false;
                        boolean bl2 = ((CharSequence)it.getRegex().getPattern()).length() > 0;
                        if (!bl2) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        SpeechToTextReplace it = (SpeechToTextReplace)element$iv;
                        boolean bl = false;
                        String string3 = this.lastSpokenMessage;
                        Intrinsics.checkNotNull((Object)string3);
                        CharSequence charSequence = string3;
                        Regex regex = it.getRegex();
                        String string4 = it.getStr();
                        this.lastSpokenMessage = regex.replace(charSequence, string4);
                        ChatPlus.INSTANCE.getLOGGER().info("Replaced: " + this.lastSpokenMessage);
                    }
                    if (Config.INSTANCE.getValues().getSpeechToTextAutoReplacePlayers()) {
                        String string5 = this.lastSpokenMessage;
                        Intrinsics.checkNotNull((Object)string5);
                        this.lastSpokenMessage = MicrophoneThread.replacePlayer$default(this, string5, 0, 2, null);
                    }
                    Screen screen = Minecraft.getInstance().screen;
                    if (!ChatManager.INSTANCE.isChatFocused()) continue;
                    this.doWithMessage((Function2<? super String, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> MicrophoneThread.run$lambda$14(screen, arg_0, arg_1)));
                    continue;
                }
                if (!this.listening) continue;
                Logger logger = ChatPlus.INSTANCE.getLOGGER();
                Microphone microphone = this.microphone;
                Intrinsics.checkNotNull((Object)microphone);
                logger.debug("available: " + microphone.dataAvailable());
                this.totalData.addAll(ArraysKt.toList((short[])this.readMic()));
                this.sleep();
            }
            catch (Exception e) {
                ChatPlus.INSTANCE.getLOGGER().error((Object)e);
                MutableComponent mutableComponent = Component.literal((String)("Problem recording speech, disabling Speech to Text: " + e.getMessage())).withStyle(MicrophoneThread::run$lambda$15);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
                ChatPlus.INSTANCE.sendMessage((Component)mutableComponent);
                this.disabled = true;
            }
        }
    }

    private final void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            ChatPlus.INSTANCE.getLOGGER().error((Object)e);
        }
    }

    private final short[] readMic() {
        Microphone mic = this.getMicrophone();
        if (mic == null) {
            Thread.sleep(10000L);
            throw new MicrophoneException("Failed to get microphone");
        }
        if (!mic.isActive()) {
            mic.startRecording();
        }
        return mic.read();
    }

    private final String speechToText(short[] data) {
        String string;
        Recognizer recognizer = this.recognizer;
        Intrinsics.checkNotNull((Object)recognizer);
        if (recognizer.acceptWaveForm(data, data.length)) {
            Recognizer recognizer2 = this.recognizer;
            Intrinsics.checkNotNull((Object)recognizer2);
            JsonElement jsonElement = JsonParser.parseString((String)recognizer2.getResult()).getAsJsonObject().get("text");
            string = jsonElement != null ? jsonElement.getAsString() : null;
        } else {
            Recognizer recognizer3 = this.recognizer;
            Intrinsics.checkNotNull((Object)recognizer3);
            JsonElement jsonElement = JsonParser.parseString((String)recognizer3.getPartialResult()).getAsJsonObject().get("partial");
            string = jsonElement != null ? jsonElement.getAsString() : null;
        }
        return string;
    }

    private final Microphone getMicrophone() {
        if (this.microphone != null) {
            return this.microphone;
        }
        try {
            this.microphone = SpeechToText.INSTANCE.createMicrophone();
        }
        catch (MicrophoneException e) {
            MutableComponent mutableComponent = Component.literal((String)"Invalid Microphone, disabling Speech to Text.").withStyle(MicrophoneThread::getMicrophone$lambda$16);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
            ChatPlus.INSTANCE.sendMessage((Component)mutableComponent);
            this.disabled = true;
            ChatPlus.INSTANCE.getLOGGER().error((Object)e);
        }
        return this.microphone;
    }

    /*
     * WARNING - void declaration
     */
    private final String replacePlayer(String input, int searchDepth) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (!StringsKt.contains$default((CharSequence)input, (CharSequence)"player", (boolean)false, (int)2, null)) {
            return input;
        }
        Object object = Minecraft.getInstance().getConnection();
        if (object == null || (object = object.getListedOnlinePlayers()) == null) {
            return input;
        }
        Object players = object;
        String[] stringArray = new String[]{" "};
        List words = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)input, (String)"player ", null, (int)2, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable iterable = (Iterable)players;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PlayerInfo playerInfo = (PlayerInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getProfile().getName());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new MatchedPlayer(it, it));
        }
        List matched = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        int matchedIndex = -1;
        int i = 0;
        int n = Math.min(searchDepth, words.size());
        while (i < n) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String wordToMatch = (String)words.get(i);
            Iterable iterable2 = matched;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MatchedPlayer it2 = (MatchedPlayer)element$iv$iv;
                boolean bl = false;
                int matchedIndex2 = StringsKt.indexOf$default((CharSequence)it2.getPostMatchName(), (String)wordToMatch, (int)0, (boolean)true, (int)2, null);
                if (matchedIndex2 != -1) {
                    String string = it2.getPostMatchName().substring(matchedIndex2 + wordToMatch.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    it2.setPostMatchName(string);
                }
                if (!(matchedIndex2 != -1)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List newMatched = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
            if (newMatched.isEmpty()) break;
            matched = newMatched;
            matchedIndex = i++;
            if (newMatched.size() == 1) break;
        }
        if (matchedIndex == -1 || matched.isEmpty()) {
            return input;
        }
        return StringsKt.replace((String)input, (String)("player " + CollectionsKt.joinToString$default((Iterable)words.subList(0, matchedIndex + 1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)), (String)((MatchedPlayer)CollectionsKt.first((List)matched)).getName(), (boolean)true);
    }

    static /* synthetic */ String replacePlayer$default(MicrophoneThread microphoneThread, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Config.INSTANCE.getValues().getSpeechToTextAutoReplacePlayersMaxSearchDepth();
        }
        return microphoneThread.replacePlayer(string, n);
    }

    private static final Unit lambda$1$lambda$0(ChatScreenInitPreEvent $it, String message, boolean translated) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!Config.INSTANCE.getValues().getSpeechToTextToInputBox() && !translated || !Config.INSTANCE.getValues().getSpeechToTextTranslateToInputBox() && translated) {
            return Unit.INSTANCE;
        }
        ChatPlus.INSTANCE.getLOGGER().info("Quick Send: " + message);
        ChatScreen chatScreen = $it.getScreen();
        Intrinsics.checkNotNull((Object)chatScreen, (String)"null cannot be cast to non-null type com.ebicep.chatplus.mixin.IMixinChatScreen");
        IMixinChatScreen cfr_ignored_0 = (IMixinChatScreen)chatScreen;
        if (((IMixinChatScreen)$it.getScreen()).getInput() != null) {
            EditBox editBox = ((IMixinChatScreen)$it.getScreen()).getInput();
            if (editBox != null) {
                editBox.insertText(message);
            }
        } else {
            ((IMixinChatScreen)$it.getScreen()).setInitial(message);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MicrophoneThread this$0, ChatScreenInitPreEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getSpeechToTextEnabled()) {
            return Unit.INSTANCE;
        }
        SpeechToText.INSTANCE.setRecordMic(false);
        if (this$0.quickSendTimer <= 0L) {
            return Unit.INSTANCE;
        }
        this$0.doWithMessage((Function2<? super String, ? super Boolean, Unit>)((Function2)(arg_0, arg_1) -> MicrophoneThread.lambda$1$lambda$0(it, arg_0, arg_1)));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(MicrophoneThread this$0, ChatScreenCloseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.lastSpokenMessage = null;
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$5(MicrophoneThread this$0, GuiGraphics guiGraphics, DeltaTracker tickDelta) {
        if (!Config.INSTANCE.getValues().getSpeechToTextEnabled()) {
            return;
        }
        if (this$0.listening) {
            Intrinsics.checkNotNull((Object)guiGraphics);
            SpeechToText.INSTANCE.renderBoxAndText$chatplus_common(guiGraphics, "Listening", SpeechToText.INSTANCE.getLISTENING_COLOR());
        }
        if (this$0.getCanQuickSend()) {
            CharSequence charSequence = this$0.lastSpokenMessage;
            boolean failed = charSequence == null || charSequence.length() == 0;
            int centerWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2;
            PoseStack poseStack = guiGraphics.pose();
            GraphicsUtil graphicsUtil = GraphicsUtil.INSTANCE;
            Intrinsics.checkNotNull((Object)poseStack);
            PoseStack $this$createPose$iv = poseStack;
            boolean $i$f$createPose = false;
            $this$createPose$iv.pushPose();
            boolean bl = false;
            if (failed) {
                Intrinsics.checkNotNull((Object)guiGraphics);
                SpeechToText.INSTANCE.renderBoxAndText$chatplus_common(guiGraphics, "Failed", SpeechToText.INSTANCE.getFAILED_COLOR());
            } else {
                Intrinsics.checkNotNull((Object)guiGraphics);
                String string = this$0.lastSpokenMessage;
                Intrinsics.checkNotNull((Object)string);
                SpeechToText.INSTANCE.renderBoxAndText$chatplus_common(guiGraphics, string, -1);
            }
            $this$createPose$iv.popPose();
            if (!failed) {
                GraphicsUtil this_$iv = GraphicsUtil.INSTANCE;
                $this$createPose$iv = poseStack;
                $i$f$createPose = false;
                $this$createPose$iv.pushPose();
                boolean bl2 = false;
                float scale = 0.8f;
                poseStack.scale(scale, scale, scale);
                GraphicsUtil.translate0$default(GraphicsUtil.INSTANCE, poseStack, (float)centerWidth / scale, (float)55 / scale, 0.0f, 4, null);
                guiGraphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.literal((String)"Quick Send (").append(Config.INSTANCE.getValues().getSpeechToTextQuickSendKey().getDisplayName()).append((Component)Component.literal((String)")")), 0, 0, SpeechToText.INSTANCE.getLISTENING_COLOR());
                $this$createPose$iv.popPose();
            }
        }
    }

    private static final Unit lambda$7$lambda$6(String message, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ChatPlusScreen.sendChatMessage$default(ChatPlusScreen.INSTANCE, null, message, false, 5, null);
        return Unit.INSTANCE;
    }

    private static final EventResult _init_$lambda$7(MicrophoneThread this$0, Minecraft minecraft, int keyCode, int n, int n2, int n3) {
        boolean quickSend;
        if (!Config.INSTANCE.getValues().getSpeechToTextEnabled()) {
            return EventResult.pass();
        }
        boolean bl = quickSend = keyCode == Config.INSTANCE.getValues().getSpeechToTextQuickSendKey().getValue() && !ChatManager.INSTANCE.isChatFocused();
        if (this$0.getCanQuickSend() && quickSend) {
            this$0.quickSendTimer = -1L;
            this$0.doWithMessage((Function2<? super String, ? super Boolean, Unit>)((Function2)MicrophoneThread::lambda$7$lambda$6));
        }
        return EventResult.pass();
    }

    private static final Style run$lambda$9(Style it) {
        return it.withColor(ChatFormatting.GREEN);
    }

    private static final Style run$lambda$10(Style it) {
        return it.withColor(ChatFormatting.RED);
    }

    private static final Unit run$lambda$14(Screen $screen, String message, boolean translated) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            if (Config.INSTANCE.getValues().getSpeechToTextToInputBox() && !translated || Config.INSTANCE.getValues().getSpeechToTextTranslateToInputBox() && translated) {
                return Unit.INSTANCE;
            }
            Intrinsics.checkNotNull((Object)$screen, (String)"null cannot be cast to non-null type com.ebicep.chatplus.mixin.IMixinChatScreen");
            IMixinChatScreen cfr_ignored_0 = (IMixinChatScreen)$screen;
            EditBox editBox = ((IMixinChatScreen)$screen).getInput();
            if (editBox == null) break block1;
            editBox.insertText(message);
        }
        return Unit.INSTANCE;
    }

    private static final Style run$lambda$15(Style it) {
        return it.withColor(ChatFormatting.RED);
    }

    private static final Style getMicrophone$lambda$16(Style it) {
        return it.withColor(ChatFormatting.RED);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\bR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread$MatchedPlayer;", "", "", "name", "postMatchName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread$MatchedPlayer;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getName", "getPostMatchName", "setPostMatchName", "(Ljava/lang/String;)V", "chatplus-common"})
    public static final class MatchedPlayer {
        @NotNull
        private final String name;
        @NotNull
        private String postMatchName;

        public MatchedPlayer(@NotNull String name, @NotNull String postMatchName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)postMatchName, (String)"postMatchName");
            this.name = name;
            this.postMatchName = postMatchName;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getPostMatchName() {
            return this.postMatchName;
        }

        public final void setPostMatchName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.postMatchName = string;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.postMatchName;
        }

        @NotNull
        public final MatchedPlayer copy(@NotNull String name, @NotNull String postMatchName) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)postMatchName, (String)"postMatchName");
            return new MatchedPlayer(name, postMatchName);
        }

        public static /* synthetic */ MatchedPlayer copy$default(MatchedPlayer matchedPlayer, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = matchedPlayer.name;
            }
            if ((n & 2) != 0) {
                string2 = matchedPlayer.postMatchName;
            }
            return matchedPlayer.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "MatchedPlayer(name=" + this.name + ", postMatchName=" + this.postMatchName + ")";
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + this.postMatchName.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MatchedPlayer)) {
                return false;
            }
            MatchedPlayer matchedPlayer = (MatchedPlayer)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)matchedPlayer.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.postMatchName, (Object)matchedPlayer.postMatchName);
        }
    }

    @Serializable
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001c\u001bB!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB7\b\u0010\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0007\u0010\fJ'\u0010\u0015\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread$SpeechToTextReplace;", "Lcom/ebicep/chatplus/features/internal/MessageFilterWithString;", "", "pattern", "str", "", "priority", "<init>", "(Ljava/lang/String;Ljava/lang/String;I)V", "seen0", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "serializationConstructorMarker", "(ILjava/lang/String;Ljava/lang/String;ILkotlinx/serialization/internal/SerializationConstructorMarker;)V", "self", "Lkotlinx/serialization/encoding/CompositeEncoder;", "output", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "serialDesc", "", "write$Self$chatplus_common", "(Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread$SpeechToTextReplace;Lkotlinx/serialization/encoding/CompositeEncoder;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "write$Self", "I", "getPriority", "()I", "setPriority", "(I)V", "Companion", ".serializer", "chatplus-common"})
    public static final class SpeechToTextReplace
    extends MessageFilterWithString {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int priority;

        public final int getPriority() {
            return this.priority;
        }

        public final void setPriority(int n) {
            this.priority = n;
        }

        public SpeechToTextReplace(@NotNull String pattern, @NotNull String str, int priority) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            super(pattern, str);
            this.priority = priority;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$chatplus_common(SpeechToTextReplace self, CompositeEncoder output, SerialDescriptor serialDesc) {
            MessageFilterWithString.write$Self(self, output, serialDesc);
            if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : self.priority != 0) {
                output.encodeIntElement(serialDesc, 2, self.priority);
            }
        }

        public /* synthetic */ SpeechToTextReplace(int seen0, String pattern, String str, int priority, SerializationConstructorMarker serializationConstructorMarker) {
            if ((0 & seen0) != 0) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)0, (SerialDescriptor)SpeechToTextReplace$$serializer.INSTANCE.getDescriptor());
            }
            super(seen0, pattern, str, serializationConstructorMarker);
            this.priority = (seen0 & 4) == 0 ? 0 : priority;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread$SpeechToTextReplace$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread$SpeechToTextReplace;", "serializer", "()Lkotlinx/serialization/KSerializer;", "chatplus-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<SpeechToTextReplace> serializer() {
                return (KSerializer)SpeechToTextReplace$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

