/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.features.speechtotext;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.config.ConfigKt;
import com.ebicep.chatplus.events.ChatPlusTickEvent;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.speechtotext.ALMicrophone;
import com.ebicep.chatplus.features.speechtotext.ALMicrophoneKt;
import com.ebicep.chatplus.features.speechtotext.JavaxMicrophone;
import com.ebicep.chatplus.features.speechtotext.Microphone;
import com.ebicep.chatplus.features.speechtotext.MicrophoneException;
import com.ebicep.chatplus.features.speechtotext.MicrophoneThread;
import com.ebicep.chatplus.hud.ChatManager;
import com.ebicep.chatplus.translator.Language;
import com.ebicep.chatplus.translator.LanguageManager;
import com.ebicep.chatplus.util.KeyUtil;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.ALC11;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\u0004\b\u0014\u0010\u0010J\r\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0004\b\u0018\u0010\u0003R\u001c\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\u001e\u001a\u0004\b\"\u0010 R\u0011\u0010$\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R\"\u0010%\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b'\u0010\u0017\"\u0004\b(\u0010)R\u0017\u0010+\u001a\u00020*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u0016\u0010/\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u0010&R$\u00101\u001a\u0004\u0018\u0001008\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00067"}, d2={"Lcom/ebicep/chatplus/features/speechtotext/SpeechToText;", "", "<init>", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "text", "", "color", "", "renderBoxAndText$chatplus_common", "(Lnet/minecraft/client/gui/GuiGraphics;Ljava/lang/String;I)V", "renderBoxAndText", "", "getAllPossibleModels", "()Ljava/util/List;", "Lcom/ebicep/chatplus/features/speechtotext/Microphone;", "createMicrophone", "()Lcom/ebicep/chatplus/features/speechtotext/Microphone;", "getAllMicrophoneNames", "", "canEnumerate", "()Z", "updateTranslateLanguage", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "DEVICE_NAME", "Ljava/util/regex/Pattern;", "LISTENING_COLOR", "I", "getLISTENING_COLOR", "()I", "FAILED_COLOR", "getFAILED_COLOR", "getSAMPLE_RATE", "SAMPLE_RATE", "recordMic", "Z", "getRecordMic", "setRecordMic", "(Z)V", "Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread;", "microphoneThread", "Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread;", "getMicrophoneThread", "()Lcom/ebicep/chatplus/features/speechtotext/MicrophoneThread;", "alFailed", "Lcom/ebicep/chatplus/translator/Language;", "speechToTextLang", "Lcom/ebicep/chatplus/translator/Language;", "getSpeechToTextLang", "()Lcom/ebicep/chatplus/translator/Language;", "setSpeechToTextLang", "(Lcom/ebicep/chatplus/translator/Language;)V", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nSpeechToText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpeechToText.kt\ncom/ebicep/chatplus/features/speechtotext/SpeechToText\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 EventBus.kt\ncom/ebicep/chatplus/events/EventBus\n*L\n1#1,461:1\n11165#2:462\n11500#2,3:463\n1863#3,2:466\n57#4,5:468\n*S KotlinDebug\n*F\n+ 1 SpeechToText.kt\ncom/ebicep/chatplus/features/speechtotext/SpeechToText\n*L\n102#1:462\n102#1:463,3\n124#1:466,2\n87#1:468,5\n*E\n"})
public final class SpeechToText {
    @NotNull
    public static final SpeechToText INSTANCE;
    private static final Pattern DEVICE_NAME;
    private static final int LISTENING_COLOR;
    private static final int FAILED_COLOR;
    private static volatile boolean recordMic;
    @NotNull
    private static final MicrophoneThread microphoneThread;
    private static boolean alFailed;
    @Nullable
    private static Language speechToTextLang;

    private SpeechToText() {
    }

    public final int getLISTENING_COLOR() {
        return LISTENING_COLOR;
    }

    public final int getFAILED_COLOR() {
        return FAILED_COLOR;
    }

    public final int getSAMPLE_RATE() {
        return Config.INSTANCE.getValues().getSpeechToTextSampleRate();
    }

    public final boolean getRecordMic() {
        return recordMic;
    }

    public final void setRecordMic(boolean bl) {
        recordMic = bl;
    }

    @NotNull
    public final MicrophoneThread getMicrophoneThread() {
        return microphoneThread;
    }

    @Nullable
    public final Language getSpeechToTextLang() {
        return speechToTextLang;
    }

    public final void setSpeechToTextLang(@Nullable Language language) {
        speechToTextLang = language;
    }

    public final void renderBoxAndText$chatplus_common(@NotNull GuiGraphics guiGraphics, @NotNull String text, int color) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int centerWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2;
        int width = Minecraft.getInstance().font.width(text);
        guiGraphics.fill(centerWidth - width / 2 - 5, 35, centerWidth + width / 2 + 5, 52, 0x7F000000);
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, text, centerWidth, 40, color);
        if (Config.INSTANCE.getValues().getSpeechToTextTranslateEnabled()) {
            guiGraphics.renderOutline(centerWidth - width / 2 - 5, 35, width + 10, 17, -11141291);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAllPossibleModels() {
        void $this$mapTo$iv$iv;
        File[] files;
        File[] fileArray;
        File modelDirectory = new File(ConfigKt.getConfigDirectoryPath() + "/models");
        if (!modelDirectory.exists()) {
            modelDirectory.mkdir();
        }
        if ((fileArray = modelDirectory.listFiles(SpeechToText::getAllPossibleModels$lambda$1)) == null) {
            fileArray = new File[]{};
        }
        File[] $this$map$iv = files = fileArray;
        boolean $i$f$map = false;
        File[] fileArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @NotNull
    public final Microphone createMicrophone() {
        Microphone microphone;
        try {
            String mic = Config.INSTANCE.getValues().getSpeechToTextMicrophone();
            String device = Intrinsics.areEqual((Object)mic, (Object)"") || Intrinsics.areEqual((Object)mic, (Object)"Default") ? null : mic;
            ChatPlus.INSTANCE.getLOGGER().info("Microphone: " + device);
            microphone = new ALMicrophone(this.getSAMPLE_RATE(), this.getSAMPLE_RATE() / 1000 * 20, device, 0L, 8, null);
        }
        catch (MicrophoneException e) {
            ChatPlus.INSTANCE.getLOGGER().error((Object)e);
            alFailed = true;
            microphone = new JavaxMicrophone(this.getSAMPLE_RATE(), null, null, 4, null);
        }
        return microphone;
    }

    @NotNull
    public final List<String> getAllMicrophoneNames() {
        List names = new ArrayList();
        Iterable $this$forEach$iv = alFailed ? JavaxMicrophone.Companion.getMicrophoneNames() : ALMicrophone.Companion.getMicrophoneNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Matcher matcher = DEVICE_NAME.matcher(it);
            String string = !matcher.matches() ? it : matcher.group(1);
            Intrinsics.checkNotNull((Object)string);
            names.add(string);
        }
        return names;
    }

    public final boolean canEnumerate() {
        boolean present = ALC11.alcIsExtensionPresent((long)0L, (CharSequence)"ALC_ENUMERATE_ALL_EXT");
        ALMicrophoneKt.checkALCError(0L);
        return present;
    }

    public final void updateTranslateLanguage() {
        speechToTextLang = LanguageManager.INSTANCE.findLanguageFromName(Config.INSTANCE.getValues().getSpeechToTextTranslateLang());
    }

    private static final Unit _init_$lambda$0(ChatPlusTickEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getSpeechToTextEnabled()) {
            return Unit.INSTANCE;
        }
        recordMic = KeyUtil.INSTANCE.isDown(Config.INSTANCE.getValues().getSpeechToTextMicrophoneKey()) && !ChatManager.INSTANCE.isChatFocused();
        return Unit.INSTANCE;
    }

    private static final boolean getAllPossibleModels$lambda$1(File file) {
        return file.isDirectory();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$iv;
        INSTANCE = new SpeechToText();
        DEVICE_NAME = Pattern.compile("^(?:OpenAL.+?on )?(.*)$");
        LISTENING_COLOR = new Color(0, 200, 0, 255).getRGB();
        FAILED_COLOR = new Color(200, 0, 0, 255).getRGB();
        microphoneThread = new MicrophoneThread();
        microphoneThread.start();
        EventBus eventBus = EventBus.INSTANCE;
        Function1 callback$iv = SpeechToText::_init_$lambda$0;
        Function0 priority$iv = EventBus.register.1.INSTANCE;
        Function0 skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        boolean $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatPlusTickEvent.class, callback$iv);
    }
}

