/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.features;

import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.AlignMessage;
import com.ebicep.chatplus.features.chattabs.ChatTabAddDisplayMessageEvent;
import com.ebicep.chatplus.features.chattabs.ChatTabGetMessageAtEvent;
import com.ebicep.chatplus.features.chattabs.ValuesXY;
import com.ebicep.chatplus.features.chatwindows.ChatWindow;
import com.ebicep.chatplus.hud.ChatManager;
import com.ebicep.chatplus.hud.ChatRenderPostLinesRenderEvent;
import com.ebicep.chatplus.hud.ChatRenderer;
import com.ebicep.chatplus.hud.ChatScreenCloseEvent;
import com.ebicep.chatplus.hud.ChatScreenMouseClickedEvent;
import com.ebicep.chatplus.hud.ChatScreenMouseDraggedEvent;
import com.ebicep.chatplus.hud.ChatScreenMouseReleasedEvent;
import com.ebicep.chatplus.util.GraphicsUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0016\u0010\r\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0016\u0010\u000e\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u0016\u0010\u000f\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0006R\u0016\u0010\u0011\u001a\u00020\u00108\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/ebicep/chatplus/features/ScrollBar;", "", "<init>", "()V", "", "MIN_HEIGHT", "F", "HALF_MIN_HEIGHT", "", "getBarWidth", "()I", "barWidth", "barStartX", "barEndX", "barBottomY", "barTopY", "", "scrolling", "Z", "", "lastMouseY", "D", "lastScrollPos", "I", "scrollPerY", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nScrollBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollBar.kt\ncom/ebicep/chatplus/features/ScrollBar\n+ 2 GraphicsUtil.kt\ncom/ebicep/chatplus/util/GraphicsUtil\n+ 3 EventBus.kt\ncom/ebicep/chatplus/events/EventBus\n*L\n1#1,130:1\n59#2,4:131\n57#3,5:135\n57#3,5:140\n61#3:145\n57#3,5:146\n57#3,5:151\n57#3,5:156\n57#3,5:161\n*S KotlinDebug\n*F\n+ 1 ScrollBar.kt\ncom/ebicep/chatplus/features/ScrollBar\n*L\n54#1:131,4\n29#1:135,5\n35#1:140,5\n83#1:145\n101#1:146,5\n104#1:151,5\n107#1:156,5\n117#1:161,5\n*E\n"})
public final class ScrollBar {
    @NotNull
    public static final ScrollBar INSTANCE;
    private static final float MIN_HEIGHT = 10.0f;
    private static final float HALF_MIN_HEIGHT = 5.0f;
    private static float barStartX;
    private static float barEndX;
    private static float barBottomY;
    private static float barTopY;
    private static boolean scrolling;
    private static double lastMouseY;
    private static int lastScrollPos;
    private static double scrollPerY;

    private ScrollBar() {
    }

    private final int getBarWidth() {
        return Config.INSTANCE.getValues().getScrollbarWidth();
    }

    private static final Unit _init_$lambda$0(ChatTabAddDisplayMessageEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getScrollbarEnabled()) {
            return Unit.INSTANCE;
        }
        it.setMaxWidth(it.getMaxWidth() - Math.max(0, INSTANCE.getBarWidth()));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ChatRenderPostLinesRenderEvent it) {
        int linesPerPage;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getScrollbarEnabled()) {
            return Unit.INSTANCE;
        }
        if (!ChatManager.INSTANCE.isChatFocused()) {
            return Unit.INSTANCE;
        }
        ChatWindow chatWindow = it.getChatWindow();
        if (chatWindow != ChatManager.INSTANCE.getSelectedWindow()) {
            return Unit.INSTANCE;
        }
        ChatRenderer renderer = chatWindow.getRenderer();
        int messageCount = ChatManager.INSTANCE.getGlobalSelectedTab().getDisplayedMessages().size();
        if (messageCount <= (linesPerPage = renderer.getRescaledLinesPerPage())) {
            return Unit.INSTANCE;
        }
        class_332 guiGraphics = it.getGuiGraphics();
        Matrix3x2fStack poseStack = guiGraphics.method_51448();
        GraphicsUtil graphicsUtil = GraphicsUtil.INSTANCE;
        Intrinsics.checkNotNull((Object)poseStack);
        Matrix3x2fStack $this$createPose$iv = poseStack;
        boolean $i$f$createPose = false;
        $this$createPose$iv.pushMatrix();
        boolean bl = false;
        int chatScrollbarPos = ChatManager.INSTANCE.getGlobalSelectedTab().getChatScrollbarPos();
        int lineHeight = renderer.getLineHeight();
        int displayHeight = linesPerPage * lineHeight;
        barStartX = renderer.getRescaledEndX() - (float)INSTANCE.getBarWidth();
        barEndX = barStartX + (float)INSTANCE.getBarWidth();
        barBottomY = -((float)(chatScrollbarPos * displayHeight) / (float)messageCount - renderer.getRescaledY());
        float barHeight = (float)(displayHeight * displayHeight) / ((float)messageCount * (float)lineHeight);
        barTopY = barBottomY - barHeight;
        scrollPerY = -((double)displayHeight / (double)messageCount - (double)renderer.getRescaledY()) - (double)renderer.getRescaledY();
        if (barHeight < 5.0f) {
            barHeight = 10.0f;
            barTopY = (barBottomY += 5.0f) - barHeight;
            barBottomY = RangesKt.coerceAtMost((float)barBottomY, (float)renderer.getRescaledY());
            barTopY = RangesKt.coerceAtLeast((float)barTopY, (float)(renderer.getRescaledY() - (float)displayHeight));
        }
        GraphicsUtil.INSTANCE.fill0(guiGraphics, barStartX, barBottomY, barEndX, barTopY, Config.INSTANCE.getValues().getScrollbarColor());
        $this$createPose$iv.popMatrix();
        return Unit.INSTANCE;
    }

    private static final int _init_$lambda$3() {
        return 25;
    }

    private static final boolean _init_$lambda$4() {
        return scrolling;
    }

    private static final Unit _init_$lambda$5(ChatScreenMouseClickedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getScrollbarEnabled()) {
            return Unit.INSTANCE;
        }
        ChatWindow chatWindow = ChatManager.INSTANCE.getSelectedWindow();
        ChatRenderer renderer = chatWindow.getRenderer();
        double rescaledX = it.getMouseX() / (double)renderer.getScale();
        double rescaledY = it.getMouseY() / (double)renderer.getScale();
        double min = Math.min(barStartX, barEndX);
        double max = Math.max(barStartX, barEndX);
        boolean bl = min <= rescaledX ? rescaledX <= max : false;
        if (bl && (double)barTopY <= rescaledY && rescaledY <= (double)barBottomY) {
            scrolling = true;
            lastMouseY = rescaledY;
            lastScrollPos = ChatManager.INSTANCE.getGlobalSelectedTab().getChatScrollbarPos();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(ChatScreenMouseReleasedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        scrolling = false;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(ChatScreenCloseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        scrolling = false;
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$8(ChatScreenMouseDraggedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (scrolling) {
            ChatWindow chatWindow = ChatManager.INSTANCE.getSelectedWindow();
            ChatRenderer renderer = chatWindow.getRenderer();
            double yOffset = lastMouseY - it.getMouseY() / (double)renderer.getScale();
            double scrollOffset = yOffset / scrollPerY;
            double newScrollPos = (double)lastScrollPos - scrollOffset;
            ChatManager.INSTANCE.getGlobalSelectedTab().setScrollPos(MathKt.roundToInt((double)newScrollPos));
        }
        return Unit.INSTANCE;
    }

    private static final void lambda$10$lambda$9(ValuesXY valuesXY, ValuesXY current) {
        Intrinsics.checkNotNullParameter((Object)valuesXY, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        current.setX(current.getX() + (double)Math.max(0, INSTANCE.getBarWidth()));
    }

    private static final Unit _init_$lambda$10(ChatTabGetMessageAtEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Config.INSTANCE.getValues().getScrollbarEnabled()) {
            return Unit.INSTANCE;
        }
        if (ChatManager.INSTANCE.getSelectedWindow().getGeneralSettings().getMessageAlignment() != AlignMessage.Alignment.RIGHT) {
            return Unit.INSTANCE;
        }
        it.addChatOperator(ScrollBar::lambda$10$lambda$9);
        return Unit.INSTANCE;
    }

    static {
        EventBus this_$iv;
        EventBus $this$iv;
        INSTANCE = new ScrollBar();
        EventBus eventBus = EventBus.INSTANCE;
        Function1 callback$iv = ScrollBar::_init_$lambda$0;
        Function0 priority$iv = EventBus.register.1.INSTANCE;
        Function0 skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        boolean $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatTabAddDisplayMessageEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = ScrollBar::_init_$lambda$2;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatRenderPostLinesRenderEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        priority$iv = ScrollBar::_init_$lambda$3;
        skipOtherCallbacks$iv = ScrollBar::_init_$lambda$4;
        callback$iv = ScrollBar::_init_$lambda$5;
        $i$f$register = false;
        this_$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatScreenMouseClickedEvent.class, callback$iv);
        this_$iv = EventBus.INSTANCE;
        callback$iv = ScrollBar::_init_$lambda$6;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatScreenMouseReleasedEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = ScrollBar::_init_$lambda$7;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatScreenCloseEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = ScrollBar::_init_$lambda$8;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatScreenMouseDraggedEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = ScrollBar::_init_$lambda$10;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatTabGetMessageAtEvent.class, callback$iv);
    }
}

