/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.util;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\b\u0010\tJI\u0010\u0010\u001a\u00020\u0007\"\u0004\b\u0000\u0010\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00070\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0011\u0010\u0013\u001a\u00020\u0012*\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0017\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u001b\u00a2\u0006\u0004\b\u0017\u0010\u001cJ\u001d\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/ebicep/chatplus/util/KotlinUtil;", "", "<init>", "()V", "E", "", "element", "", "containsReference", "(Ljava/util/Collection;Ljava/lang/Object;)Z", "T", "", "list1", "list2", "Lkotlin/Function2;", "comparator", "areListsEqual", "(Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function2;)Z", "Ljava/awt/Color;", "brighter2", "(Ljava/awt/Color;)Ljava/awt/Color;", "", "percentage", "reduceAlpha", "(Ljava/awt/Color;F)Ljava/awt/Color;", "", "color", "", "(ID)I", "(IF)I", "FACTOR", "D", "chatplus-common"})
public final class KotlinUtil {
    @NotNull
    public static final KotlinUtil INSTANCE = new KotlinUtil();
    private static final double FACTOR = 0.9;

    private KotlinUtil() {
    }

    public final <E> boolean containsReference(@NotNull Collection<? extends E> $this$containsReference, E element) {
        Intrinsics.checkNotNullParameter($this$containsReference, (String)"<this>");
        for (E e : $this$containsReference) {
            if (e != element) continue;
            return true;
        }
        return false;
    }

    public final <T> boolean areListsEqual(@NotNull List<? extends T> list1, @NotNull List<? extends T> list2, @NotNull Function2<? super T, ? super T, Boolean> comparator) {
        Intrinsics.checkNotNullParameter(list1, (String)"list1");
        Intrinsics.checkNotNullParameter(list2, (String)"list2");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        if (list1.size() != list2.size()) {
            return false;
        }
        int n = ((Collection)list1).size();
        for (int i = 0; i < n; ++i) {
            if (((Boolean)comparator.invoke(list1.get(i), list2.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Color brighter2(@NotNull Color $this$brighter2) {
        Intrinsics.checkNotNullParameter((Object)$this$brighter2, (String)"<this>");
        int r = $this$brighter2.getRed();
        int g = $this$brighter2.getGreen();
        int b = $this$brighter2.getBlue();
        int alpha = $this$brighter2.getAlpha();
        int i = 10;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i, alpha);
        }
        boolean bl = 1 <= r ? r < i : false;
        if (bl) {
            r = i;
        }
        boolean bl2 = 1 <= g ? g < i : false;
        if (bl2) {
            g = i;
        }
        boolean bl3 = 1 <= b ? b < i : false;
        if (bl3) {
            b = i;
        }
        return new Color(Math.min((int)((double)r / 0.9), 255), Math.min((int)((double)g / 0.9), 255), Math.min((int)((double)b / 0.9), 255), alpha);
    }

    @NotNull
    public final Color reduceAlpha(@NotNull Color $this$reduceAlpha, float percentage) {
        Intrinsics.checkNotNullParameter((Object)$this$reduceAlpha, (String)"<this>");
        int oldAlpha = $this$reduceAlpha.getRGB() >> 24 & 0xFF;
        float newAlpha = (float)oldAlpha * percentage;
        return new Color($this$reduceAlpha.getRGB() & 0xFFFFFF | (int)newAlpha << 24, true);
    }

    public final int reduceAlpha(int color, double percentage) {
        int oldAlpha = color >> 24 & 0xFF;
        double newAlpha = (double)oldAlpha * percentage;
        return color & 0xFFFFFF | (int)newAlpha << 24;
    }

    public final int reduceAlpha(int color, float percentage) {
        int oldAlpha = color >> 24 & 0xFF;
        float newAlpha = (float)oldAlpha * percentage;
        return color & 0xFFFFFF | (int)newAlpha << 24;
    }
}

