/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.features.speechtotext;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.features.speechtotext.ALMicrophoneKt;
import com.ebicep.chatplus.features.speechtotext.Microphone;
import com.ebicep.chatplus.features.speechtotext.MicrophoneException;
import com.ebicep.chatplus.features.speechtotext.SpeechToText;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.openal.ALC11;
import org.lwjgl.openal.ALUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0002\b\u000b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\rJ\u000f\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0010\u0010\rJ\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001aR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001bR\u0016\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/ebicep/chatplus/features/speechtotext/ALMicrophone;", "Lcom/ebicep/chatplus/features/speechtotext/Microphone;", "", "sampleRate", "bufferSize", "", "device", "", "line", "<init>", "(IILjava/lang/String;J)V", "", "open", "()V", "close", "startRecording", "stopRecording", "", "isOpen", "()Z", "isActive", "", "read", "()[S", "dataAvailable", "()I", "I", "Ljava/lang/String;", "J", "started", "Z", "Companion", "chatplus-common"})
public final class ALMicrophone
implements Microphone {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int sampleRate;
    private final int bufferSize;
    @Nullable
    private final String device;
    private long line;
    private boolean started;

    public ALMicrophone(int sampleRate, int bufferSize, @Nullable String device, long line) {
        this.sampleRate = sampleRate;
        this.bufferSize = bufferSize;
        this.device = device;
        this.line = line;
        this.open();
    }

    public /* synthetic */ ALMicrophone(int n, int n2, String string, long l, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 8) != 0) {
            l = 0L;
        }
        this(n, n2, string, l);
    }

    @Override
    public void open() {
        if (this.isOpen()) {
            throw new MicrophoneException("Microphone already open");
        }
        ChatPlus.INSTANCE.getLOGGER().info("Opening AL Microphone");
        String deviceName = this.device;
        ChatPlus.INSTANCE.getLOGGER().info("Device: " + deviceName);
        boolean present = SpeechToText.INSTANCE.canEnumerate();
        if (present) {
            deviceName = ALC11.alcGetString((long)0L, (int)784);
            ChatPlus.INSTANCE.getLOGGER().info("Device: " + deviceName);
            ALMicrophoneKt.checkALCError(0L);
        }
        long device = ALC11.alcCaptureOpenDevice((CharSequence)deviceName, (int)this.sampleRate, (int)65552, (int)this.bufferSize);
        ChatPlus.INSTANCE.getLOGGER().info("line: " + device);
        if (device == 0L) {
            throw new MicrophoneException("Failed to open microphone: " + ALMicrophoneKt.getALCError(ALC11.alcGetError((long)device)));
        }
        this.line = device;
    }

    @Override
    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.stopRecording();
        ALC11.alcCaptureCloseDevice((long)this.line);
        ALMicrophoneKt.checkALCError(this.line);
        this.line = 0L;
    }

    @Override
    public void startRecording() {
        if (!this.isOpen()) {
            return;
        }
        if (this.started) {
            return;
        }
        ALC11.alcCaptureStart((long)this.line);
        ALMicrophoneKt.checkALCError(this.line);
    }

    @Override
    public void stopRecording() {
        if (!this.isOpen()) {
            return;
        }
        if (!this.started) {
            return;
        }
        ALC11.alcCaptureStop((long)this.line);
        ALMicrophoneKt.checkALCError(this.line);
        this.started = false;
        int dataAvailable = this.dataAvailable();
        float[] data = new float[dataAvailable];
        ALC11.alcCaptureSamples((long)this.line, (float[])data, (int)data.length);
        ALMicrophoneKt.checkALCError(this.line);
        ChatPlus.INSTANCE.getLOGGER().info("Cleared " + dataAvailable + " samples");
    }

    @Override
    public boolean isOpen() {
        return this.line != 0L;
    }

    @Override
    public boolean isActive() {
        return this.started;
    }

    @Override
    @NotNull
    public short[] read() {
        int dataAvailable = this.dataAvailable();
        float[] buffer = new float[dataAvailable + 1];
        ALC11.alcCaptureSamples((long)this.line, (float[])buffer, (int)dataAvailable);
        ALMicrophoneKt.checkALCError(this.line);
        int n = 0;
        int n2 = buffer.length;
        short[] sArray = new short[n2];
        while (n < n2) {
            int n3 = n++;
            sArray[n3] = (short)(buffer[n3] * (float)Short.MAX_VALUE);
        }
        return sArray;
    }

    @Override
    public int dataAvailable() {
        int dataAvailable = ALC11.alcGetInteger((long)this.line, (int)786);
        ALMicrophoneKt.checkALCError(this.line);
        return dataAvailable;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ebicep/chatplus/features/speechtotext/ALMicrophone$Companion;", "", "<init>", "()V", "", "", "getMicrophoneNames", "()Ljava/util/List;", "chatplus-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getMicrophoneNames() {
            if (!SpeechToText.INSTANCE.canEnumerate()) {
                return CollectionsKt.emptyList();
            }
            List devices = ALUtil.getStringList((long)0L, (int)784);
            ALMicrophoneKt.checkALCError(0L);
            List list = devices;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

