/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.mixin;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.chattabs.AddNewMessageEvent;
import com.ebicep.chatplus.features.chattabs.ChatTab;
import com.ebicep.chatplus.features.chattabs.SkipNewMessageEvent;
import com.ebicep.chatplus.features.chatwindows.ChatWindowsManager;
import com.ebicep.chatplus.hud.ChatManager;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class}, priority=0x7FFFFFFF)
public class MixinChatComponent {
    @Final
    @Shadow
    private Minecraft minecraft;

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIIZ)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, int k, boolean bl, CallbackInfo ci) {
        if (!ChatPlus.INSTANCE.isEnabled() || Config.INSTANCE.getValues().getShowVanillaWhenUnfocused() && !ChatManager.INSTANCE.isChatFocused()) {
            return;
        }
        ChatWindowsManager.INSTANCE.renderAll(guiGraphics, i, j, k);
        ci.cancel();
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at={@At(value="RETURN")})
    public void addMessage(Component component, MessageSignature messageSignature, GuiMessageTag guiMessageTag, CallbackInfo ci, @Local GuiMessage guiMessage) {
        if (!ChatPlus.INSTANCE.isEnabled() && !Config.INSTANCE.getValues().getAddMessagesIfDisabled()) {
            return;
        }
        component = guiMessage.content();
        messageSignature = guiMessage.signature();
        guiMessageTag = guiMessage.tag();
        ArrayList<ChatTab> addMessagesTo = new ArrayList<ChatTab>();
        Integer lastPriority = null;
        for (ChatTab chatTab : ChatManager.INSTANCE.getGlobalSortedTabs()) {
            int priority = chatTab.getPriority();
            boolean alwaysAdd = chatTab.getAlwaysAdd();
            if (lastPriority != null && lastPriority > priority && !alwaysAdd || !chatTab.matches(component)) continue;
            addMessagesTo.add(chatTab);
            if (chatTab.getSkipOthers()) break;
            if (alwaysAdd) continue;
            lastPriority = priority;
        }
        if (!addMessagesTo.isEmpty()) {
            messageEvent = new AddNewMessageEvent(component.copy(), component, null, messageSignature, this.minecraft.gui.getGuiTicks(), guiMessageTag, false);
            EventBus.INSTANCE.post(AddNewMessageEvent.class, messageEvent);
            if (((AddNewMessageEvent)messageEvent).getReturnFunction()) {
                return;
            }
            for (ChatTab chatTab : addMessagesTo) {
                chatTab.addNewMessage((AddNewMessageEvent)messageEvent);
            }
        } else {
            messageEvent = new SkipNewMessageEvent(component.copy(), component, null, messageSignature, this.minecraft.gui.getGuiTicks(), guiMessageTag);
            EventBus.INSTANCE.post(SkipNewMessageEvent.class, messageEvent);
        }
    }
}

