/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.translator;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.translator.Language;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\nR(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R$\u0010\u001d\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0015\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\"\u0010!\u001a\u00020 8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0017\u0010'\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b'\u0010\u0015\u001a\u0004\b(\u0010\u0017\u00a8\u0006)"}, d2={"Lcom/ebicep/chatplus/translator/LanguageManager;", "", "<init>", "()V", "", "updateTranslateLanguages", "", "name", "Lcom/ebicep/chatplus/translator/Language;", "findLanguageFromName", "(Ljava/lang/String;)Lcom/ebicep/chatplus/translator/Language;", "googleCode", "findLanguageFromGoogle", "", "languages", "Ljava/util/List;", "getLanguages", "()Ljava/util/List;", "setLanguages", "(Ljava/util/List;)V", "languageTo", "Lcom/ebicep/chatplus/translator/Language;", "getLanguageTo", "()Lcom/ebicep/chatplus/translator/Language;", "setLanguageTo", "(Lcom/ebicep/chatplus/translator/Language;)V", "languageSelf", "getLanguageSelf", "setLanguageSelf", "languageSpeak", "getLanguageSpeak", "setLanguageSpeak", "", "languageSpeakEnabled", "Z", "getLanguageSpeakEnabled", "()Z", "setLanguageSpeakEnabled", "(Z)V", "autoLang", "getAutoLang", "chatplus-common"})
public final class LanguageManager {
    @NotNull
    public static final LanguageManager INSTANCE = new LanguageManager();
    @NotNull
    private static List<Language> languages = new ArrayList();
    @Nullable
    private static Language languageTo;
    @Nullable
    private static Language languageSelf;
    @Nullable
    private static Language languageSpeak;
    private static boolean languageSpeakEnabled;
    @NotNull
    private static final Language autoLang;

    private LanguageManager() {
    }

    @NotNull
    public final List<Language> getLanguages() {
        return languages;
    }

    public final void setLanguages(@NotNull List<Language> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        languages = list;
    }

    @Nullable
    public final Language getLanguageTo() {
        return languageTo;
    }

    public final void setLanguageTo(@Nullable Language language) {
        languageTo = language;
    }

    @Nullable
    public final Language getLanguageSelf() {
        return languageSelf;
    }

    public final void setLanguageSelf(@Nullable Language language) {
        languageSelf = language;
    }

    @Nullable
    public final Language getLanguageSpeak() {
        return languageSpeak;
    }

    public final void setLanguageSpeak(@Nullable Language language) {
        languageSpeak = language;
    }

    public final boolean getLanguageSpeakEnabled() {
        return languageSpeakEnabled;
    }

    public final void setLanguageSpeakEnabled(boolean bl) {
        languageSpeakEnabled = bl;
    }

    @NotNull
    public final Language getAutoLang() {
        return autoLang;
    }

    public final void updateTranslateLanguages() {
        languageTo = this.findLanguageFromName(Config.INSTANCE.getValues().getTranslateTo());
        languageSelf = this.findLanguageFromName(Config.INSTANCE.getValues().getTranslateSelf());
        languageSpeak = this.findLanguageFromName(Config.INSTANCE.getValues().getTranslateSpeak());
    }

    @Nullable
    public final Language findLanguageFromName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (Language lang : languages) {
            if (!Intrinsics.areEqual((Object)lang.getName(), (Object)name)) continue;
            return lang;
        }
        return null;
    }

    @Nullable
    public final Language findLanguageFromGoogle(@NotNull String googleCode) {
        Intrinsics.checkNotNullParameter((Object)googleCode, (String)"googleCode");
        for (Language lang : languages) {
            if (!Intrinsics.areEqual((Object)lang.getGoogleCode(), (Object)googleCode)) continue;
            return lang;
        }
        return null;
    }

    static {
        ChatPlus.INSTANCE.getLOGGER().info("Loading languages...");
        InputStream inputStream = LanguageManager.class.getResourceAsStream("/assets/chatplus/lang.json");
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        Gson gson = new Gson();
        Object object = gson.fromJson((Reader)reader, Language[].class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        Language[] langArray = (Language[])object;
        languages = CollectionsKt.listOf((Object[])Arrays.copyOf(langArray, langArray.length));
        Language language = INSTANCE.findLanguageFromGoogle("auto");
        Intrinsics.checkNotNull((Object)language);
        autoLang = language;
        ChatPlus.INSTANCE.getLOGGER().info("Loaded " + languages.size() + " languages");
    }
}

