/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.util;

import com.ebicep.chatplus.hud.ChatScreenInputEvent;
import com.ebicep.chatplus.hud.ChatScreenKeyPressedEvent;
import com.ebicep.chatplus.hud.ChatScreenMouseClickedEvent;
import com.ebicep.chatplus.hud.InputEvent;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0006\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\u0006\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0011\u0010\u000b\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u0011\u0010\u000f\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0007J\u0015\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0011\u0010\u0010\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0007J\u0015\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0011\u0010\u0011\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0007J\u0015\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u0011\u0010\u0012\u001a\u00020\u0005*\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0007J\u0015\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u0019\u0010\u0015\u001a\u00020\u0014*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/ebicep/chatplus/util/KeyUtil;", "", "<init>", "()V", "Lcom/mojang/blaze3d/platform/InputConstants$Key;", "", "isDown", "(Lcom/mojang/blaze3d/platform/InputConstants$Key;)Z", "Lcom/ebicep/chatplus/hud/ChatScreenInputEvent;", "event", "(Lcom/mojang/blaze3d/platform/InputConstants$Key;Lcom/ebicep/chatplus/hud/ChatScreenInputEvent;)Z", "isAlt", "", "value", "(I)Z", "isControl", "isShift", "isMouseButton", "isModifier", "parentheses", "Lnet/minecraft/network/chat/Component;", "getDisplayName", "(Lcom/mojang/blaze3d/platform/InputConstants$Key;Z)Lnet/minecraft/network/chat/Component;", "chatplus-common"})
public final class KeyUtil {
    @NotNull
    public static final KeyUtil INSTANCE = new KeyUtil();

    private KeyUtil() {
    }

    public final boolean isDown(@NotNull InputConstants.Key $this$isDown) {
        Intrinsics.checkNotNullParameter((Object)$this$isDown, (String)"<this>");
        if ($this$isDown.getValue() == -1) {
            return false;
        }
        Window window = Minecraft.getInstance().getWindow();
        if (window == null) {
            return false;
        }
        Window window2 = window;
        return this.isMouseButton($this$isDown.getValue()) ? GLFW.glfwGetMouseButton((long)window2.getWindow(), (int)$this$isDown.getValue()) == 1 : InputConstants.isKeyDown((long)window2.getWindow(), (int)$this$isDown.getValue());
    }

    public final boolean isDown(@NotNull InputConstants.Key $this$isDown, @NotNull ChatScreenInputEvent event) {
        InputEvent inputEvent;
        Intrinsics.checkNotNullParameter((Object)$this$isDown, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InputEvent inputEvent2 = inputEvent = event.getInputEvent();
        if (inputEvent2 instanceof ChatScreenMouseClickedEvent) {
            int button = ((ChatScreenMouseClickedEvent)inputEvent).getButton();
            return this.isMouseButton(button) && button == $this$isDown.getValue();
        }
        if (inputEvent2 instanceof ChatScreenKeyPressedEvent) {
            return ((ChatScreenKeyPressedEvent)inputEvent).getKeyCode() == $this$isDown.getValue();
        }
        return false;
    }

    public final boolean isAlt(@NotNull InputConstants.Key $this$isAlt) {
        Intrinsics.checkNotNullParameter((Object)$this$isAlt, (String)"<this>");
        return $this$isAlt.getValue() == 342 || $this$isAlt.getValue() == 346;
    }

    public final boolean isAlt(int value) {
        return value == 342 || value == 346;
    }

    public final boolean isControl(@NotNull InputConstants.Key $this$isControl) {
        Intrinsics.checkNotNullParameter((Object)$this$isControl, (String)"<this>");
        return Minecraft.ON_OSX ? $this$isControl.getValue() == 343 || $this$isControl.getValue() == 347 : $this$isControl.getValue() == 341 || $this$isControl.getValue() == 345;
    }

    public final boolean isControl(int value) {
        return Minecraft.ON_OSX ? value == 343 || value == 347 : value == 341 || value == 345;
    }

    public final boolean isShift(@NotNull InputConstants.Key $this$isShift) {
        Intrinsics.checkNotNullParameter((Object)$this$isShift, (String)"<this>");
        return $this$isShift.getValue() == 340 || $this$isShift.getValue() == 344;
    }

    public final boolean isShift(int value) {
        return value == 340 || value == 344;
    }

    public final boolean isMouseButton(@NotNull InputConstants.Key $this$isMouseButton) {
        Intrinsics.checkNotNullParameter((Object)$this$isMouseButton, (String)"<this>");
        return this.isMouseButton($this$isMouseButton.getValue());
    }

    public final boolean isMouseButton(int value) {
        return 0 <= value ? value < 8 : false;
    }

    public final boolean isModifier(@NotNull InputConstants.Key $this$isModifier) {
        Intrinsics.checkNotNullParameter((Object)$this$isModifier, (String)"<this>");
        return this.isAlt($this$isModifier) || this.isControl($this$isModifier) || this.isShift($this$isModifier);
    }

    public final boolean isModifier(int value) {
        return this.isAlt(value) || this.isControl(value) || this.isShift(value);
    }

    @NotNull
    public final Component getDisplayName(@NotNull InputConstants.Key $this$getDisplayName, boolean parentheses) {
        Intrinsics.checkNotNullParameter((Object)$this$getDisplayName, (String)"<this>");
        if ($this$getDisplayName.getValue() == -1) {
            MutableComponent mutableComponent = Component.empty();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"empty(...)");
            return (Component)mutableComponent;
        }
        Component keyDisplayName = $this$getDisplayName.getDisplayName();
        MutableComponent component = Component.empty();
        if (parentheses) {
            component.append((Component)Component.literal((String)" ("));
        }
        component.append(keyDisplayName);
        if (parentheses) {
            component.append((Component)Component.literal((String)")"));
        }
        Intrinsics.checkNotNull((Object)component);
        return (Component)component;
    }
}

