/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.features;

import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.config.EnumTranslatableName;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.chattabs.ChatPositionTranslator;
import com.ebicep.chatplus.features.chattabs.ChatTab;
import com.ebicep.chatplus.features.chattabs.ChatTabAddDisplayMessageEvent;
import com.ebicep.chatplus.features.chattabs.ChatTabGetMessageAtEvent;
import com.ebicep.chatplus.features.chattabs.MessageAtType;
import com.ebicep.chatplus.features.chattabs.ValuesXY;
import com.ebicep.chatplus.features.chatwindows.ChatWindow;
import com.ebicep.chatplus.features.internal.Debug;
import com.ebicep.chatplus.hud.ChatManager;
import com.ebicep.chatplus.hud.ChatRenderLineTextEvent;
import com.ebicep.chatplus.hud.ChatRenderer;
import com.ebicep.chatplus.util.GraphicsUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.internal.EnumsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2fStack;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/ebicep/chatplus/features/AlignMessage;", "", "<init>", "()V", "Alignment", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nAlignMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlignMessage.kt\ncom/ebicep/chatplus/features/AlignMessage\n+ 2 EventBus.kt\ncom/ebicep/chatplus/events/EventBus\n*L\n1#1,97:1\n57#2,5:98\n57#2,5:103\n57#2,5:108\n57#2,5:113\n*S KotlinDebug\n*F\n+ 1 AlignMessage.kt\ncom/ebicep/chatplus/features/AlignMessage\n*L\n24#1:98,5\n32#1:103,5\n38#1:108,5\n49#1:113,5\n*E\n"})
public final class AlignMessage {
    @NotNull
    public static final AlignMessage INSTANCE;

    private AlignMessage() {
    }

    private static final Unit _init_$lambda$0(ChatRenderLineTextEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Alignment alignment = it.getChatWindow().getGeneralSettings().getMessageAlignment();
        Function2<ChatRenderer, FormattedCharSequence, Double> function2 = alignment.getTranslation();
        ChatRenderer chatRenderer = it.getChatWindow().getRenderer();
        FormattedCharSequence formattedCharSequence = it.getChatPlusGuiMessageLine().getLine().content();
        Intrinsics.checkNotNullExpressionValue((Object)formattedCharSequence, (String)"content(...)");
        double xTranslation = ((Number)function2.invoke((Object)chatRenderer, (Object)formattedCharSequence)).doubleValue();
        if (alignment == Alignment.RIGHT && Config.INSTANCE.getValues().getScrollbarEnabled()) {
            xTranslation -= (double)Math.max(0, Config.INSTANCE.getValues().getScrollbarWidth());
        }
        Matrix3x2fStack matrix3x2fStack = it.getGuiGraphics().pose();
        Intrinsics.checkNotNullExpressionValue((Object)matrix3x2fStack, (String)"pose(...)");
        GraphicsUtil.translate0$default(GraphicsUtil.INSTANCE, matrix3x2fStack, xTranslation, 0.0, 2, null);
        return Unit.INSTANCE;
    }

    private static final int _init_$lambda$1() {
        return -1;
    }

    private static final Unit _init_$lambda$2(ChatTabAddDisplayMessageEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChatWindow chatWindow = it.getChatWindow();
        if (chatWindow.getGeneralSettings().getMessageAlignment() == Alignment.CENTER) {
            it.setMaxWidth(it.getMaxWidth() - 5);
        }
        return Unit.INSTANCE;
    }

    private static final int _init_$lambda$3() {
        return -1;
    }

    private static final void lambda$5$lambda$4(ChatTabGetMessageAtEvent $it, ChatWindow $chatWindow, ValuesXY valuesXY, ValuesXY current) {
        Intrinsics.checkNotNullParameter((Object)valuesXY, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        ChatTab.ChatPlusGuiMessageLine chatPlusGuiMessageLine = ChatPositionTranslator.INSTANCE.getMessageAtLineRelative($it.getChatTab(), current.getX(), current.getY());
        if (chatPlusGuiMessageLine == null) {
            return;
        }
        ChatTab.ChatPlusGuiMessageLine messageLine = chatPlusGuiMessageLine;
        double d = current.getX();
        Function2<ChatRenderer, FormattedCharSequence, Double> function2 = $chatWindow.getGeneralSettings().getMessageAlignment().getTranslation();
        ChatRenderer chatRenderer = $chatWindow.getRenderer();
        FormattedCharSequence formattedCharSequence = messageLine.getLine().content();
        Intrinsics.checkNotNullExpressionValue((Object)formattedCharSequence, (String)"content(...)");
        current.setX(d - ((Number)function2.invoke((Object)chatRenderer, (Object)formattedCharSequence)).doubleValue());
    }

    private static final Unit _init_$lambda$5(ChatTabGetMessageAtEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getMessageAtType() != MessageAtType.COMPONENT) {
            return Unit.INSTANCE;
        }
        ChatTab chatTab = it.getChatTab();
        ChatWindow chatWindow = chatTab.getChatWindow();
        it.addChatOperator((arg_0, arg_1) -> AlignMessage.lambda$5$lambda$4(it, chatWindow, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(ChatRenderLineTextEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Debug.INSTANCE.getDebug()) {
            return Unit.INSTANCE;
        }
        if (!ChatManager.INSTANCE.isChatFocused()) {
            return Unit.INSTANCE;
        }
        ChatRenderer renderer = it.getChatWindow().getRenderer();
        GuiGraphics guiGraphics = it.getGuiGraphics();
        Matrix3x2fStack pose = guiGraphics.pose();
        return Unit.INSTANCE;
    }

    static {
        EventBus $this$iv;
        INSTANCE = new AlignMessage();
        EventBus eventBus = EventBus.INSTANCE;
        Function1 callback$iv = AlignMessage::_init_$lambda$0;
        Function0 priority$iv = EventBus.register.1.INSTANCE;
        Function0 skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        boolean $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatRenderLineTextEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        priority$iv = AlignMessage::_init_$lambda$1;
        callback$iv = AlignMessage::_init_$lambda$2;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatTabAddDisplayMessageEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        priority$iv = AlignMessage::_init_$lambda$3;
        callback$iv = AlignMessage::_init_$lambda$5;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatTabGetMessageAtEvent.class, callback$iv);
        $this$iv = EventBus.INSTANCE;
        callback$iv = AlignMessage::_init_$lambda$6;
        priority$iv = EventBus.register.1.INSTANCE;
        skipOtherCallbacks$iv = EventBus.register.2.INSTANCE;
        $i$f$register = false;
        $this$iv.register((Function0<Integer>)priority$iv, (Function0<Boolean>)skipOtherCallbacks$iv, ChatRenderLineTextEvent.class, callback$iv);
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0087\u0081\u0002\u0018\u0000 \u001c2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u001cBI\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00126\u0010\r\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015RG\u0010\r\u001a2\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u0012j\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006 "}, d2={"Lcom/ebicep/chatplus/features/AlignMessage$Alignment;", "Lcom/ebicep/chatplus/config/EnumTranslatableName;", "", "", "key", "Lkotlin/Function2;", "Lcom/ebicep/chatplus/hud/ChatRenderer;", "Lkotlin/ParameterName;", "name", "renderer", "Lnet/minecraft/util/FormattedCharSequence;", "text", "", "translation", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function2;)V", "Lnet/minecraft/network/chat/Component;", "getTranslatableName", "()Lnet/minecraft/network/chat/Component;", "Ljava/lang/String;", "getKey", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function2;", "getTranslation", "()Lkotlin/jvm/functions/Function2;", "translatable", "Lnet/minecraft/network/chat/Component;", "getTranslatable", "Companion", "LEFT", "CENTER", "RIGHT", "chatplus-common"})
    public static final class Alignment
    extends Enum<Alignment>
    implements EnumTranslatableName {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String key;
        @NotNull
        private final Function2<ChatRenderer, FormattedCharSequence, Double> translation;
        @NotNull
        private final Component translatable;
        @NotNull
        private static final Lazy<KSerializer<Object>> $cachedSerializer$delegate;
        public static final /* enum */ Alignment LEFT;
        public static final /* enum */ Alignment CENTER;
        public static final /* enum */ Alignment RIGHT;
        private static final /* synthetic */ Alignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Alignment(String key, Function2<? super ChatRenderer, ? super FormattedCharSequence, Double> translation) {
            this.key = key;
            this.translation = translation;
            MutableComponent mutableComponent = Component.translatable((String)this.key);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            this.translatable = (Component)mutableComponent;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final Function2<ChatRenderer, FormattedCharSequence, Double> getTranslation() {
            return this.translation;
        }

        @NotNull
        public final Component getTranslatable() {
            return this.translatable;
        }

        @Override
        @NotNull
        public Component getTranslatableName() {
            return this.translatable;
        }

        public static Alignment[] values() {
            return (Alignment[])$VALUES.clone();
        }

        public static Alignment valueOf(String value) {
            return Enum.valueOf(Alignment.class, value);
        }

        @NotNull
        public static EnumEntries<Alignment> getEntries() {
            return $ENTRIES;
        }

        private static final double _init_$lambda$0(ChatRenderer chatRenderer, FormattedCharSequence formattedCharSequence) {
            Intrinsics.checkNotNullParameter((Object)chatRenderer, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)formattedCharSequence, (String)"<unused var>");
            return 0.0;
        }

        private static final double _init_$lambda$1(ChatRenderer renderer, FormattedCharSequence text) {
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return (double)renderer.getRescaledWidth() / 2.0 - (double)Minecraft.getInstance().font.width(text) / 2.0;
        }

        private static final double _init_$lambda$2(ChatRenderer renderer, FormattedCharSequence text) {
            Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return (double)renderer.getRescaledWidth() - (double)Minecraft.getInstance().font.width(text) - 1.0;
        }

        static {
            LEFT = new Alignment("chatPlus.chatWindow.generalSettings.messageAlignment.left", (Function2<? super ChatRenderer, ? super FormattedCharSequence, Double>)((Function2)Alignment::_init_$lambda$0));
            CENTER = new Alignment("chatPlus.chatWindow.generalSettings.messageAlignment.center", (Function2<? super ChatRenderer, ? super FormattedCharSequence, Double>)((Function2)Alignment::_init_$lambda$1));
            RIGHT = new Alignment("chatPlus.chatWindow.generalSettings.messageAlignment.right", (Function2<? super ChatRenderer, ? super FormattedCharSequence, Double>)((Function2)Alignment::_init_$lambda$2));
            $VALUES = alignmentArray = new Alignment[]{Alignment.LEFT, Alignment.CENTER, Alignment.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"com.ebicep.chatplus.features.AlignMessage.Alignment", (Enum[])Alignment.values()));
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ebicep/chatplus/features/AlignMessage$Alignment$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lcom/ebicep/chatplus/features/AlignMessage$Alignment;", "serializer", "()Lkotlinx/serialization/KSerializer;", "chatplus-common"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Alignment> serializer() {
                return this.get$cachedSerializer();
            }

            private final /* synthetic */ KSerializer get$cachedSerializer() {
                return (KSerializer)$cachedSerializer$delegate.getValue();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

