/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.hud;

import com.ebicep.chatplus.IChatScreen;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.events.EventBus;
import com.ebicep.chatplus.features.InputOverFlowAutoFill;
import com.ebicep.chatplus.features.chattabs.ChatTab;
import com.ebicep.chatplus.hud.ChatManager;
import com.ebicep.chatplus.hud.ChatPlusScreen;
import com.ebicep.chatplus.hud.ChatRenderer;
import com.ebicep.chatplus.hud.ChatScreenCloseEvent;
import com.ebicep.chatplus.hud.ChatScreenInitPostEvent;
import com.ebicep.chatplus.hud.ChatScreenInitPreEvent;
import com.ebicep.chatplus.hud.ChatScreenInputBoxEditEvent;
import com.ebicep.chatplus.hud.ChatScreenInputEvent;
import com.ebicep.chatplus.hud.ChatScreenKeyPressedEvent;
import com.ebicep.chatplus.hud.ChatScreenKeyReleasedEvent;
import com.ebicep.chatplus.hud.ChatScreenMouseClickedEvent;
import com.ebicep.chatplus.hud.ChatScreenMouseDraggedEvent;
import com.ebicep.chatplus.hud.ChatScreenMouseReleasedEvent;
import com.ebicep.chatplus.hud.ChatScreenMouseScrolledEvent;
import com.ebicep.chatplus.hud.ChatScreenRenderEvent;
import com.ebicep.chatplus.hud.ChatScreenSendMessagePostEvent;
import com.ebicep.chatplus.hud.ChatScreenSendMessagePreEvent;
import com.ebicep.chatplus.mixin.IMixinChatScreen;
import com.ebicep.chatplus.mixin.IMixinScreen;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\bJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u0018J5\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0019\u00a2\u0006\u0004\b \u0010!J\u001d\u0010$\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010&\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\"\u00a2\u0006\u0004\b&\u0010%J-\u0010)\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0019\u00a2\u0006\u0004\b)\u0010*J\u001d\u0010-\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010,\u001a\u00020+\u00a2\u0006\u0004\b-\u0010.J5\u00103\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00100\u001a\u00020/2\u0006\u0010\u001a\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020+2\u0006\u00102\u001a\u000201\u00a2\u0006\u0004\b3\u00104J5\u00105\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00100\u001a\u00020/2\u0006\u0010\u001a\u001a\u00020+2\u0006\u0010\u001b\u001a\u00020+2\u0006\u00102\u001a\u000201\u00a2\u0006\u0004\b5\u00104J\u001d\u00107\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u000b\u00a2\u0006\u0004\b7\u0010\u000f\u00a8\u00068"}, d2={"Lcom/ebicep/chatplus/hud/ChatPlusScreenAdapter;", "", "<init>", "()V", "Lnet/minecraft/client/gui/screens/ChatScreen;", "chatScreen", "", "handleInitPre", "(Lnet/minecraft/client/gui/screens/ChatScreen;)V", "handleInitPost", "handleRemoved", "", "str", "", "handleOnEdited", "(Lnet/minecraft/client/gui/screens/ChatScreen;Ljava/lang/String;)Z", "Lnet/minecraft/client/input/KeyEvent;", "keyEvent", "handleKeyPressed", "(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/input/KeyEvent;)Z", "handleKeyReleased", "(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/input/KeyEvent;)V", "up", "handlePageUpDown", "(Z)V", "", "mouseX", "mouseY", "amountX", "amountY", "handleMouseScrolled", "(Lnet/minecraft/client/gui/screens/ChatScreen;DDDD)Z", "scrollChat", "(D)Z", "Lnet/minecraft/client/input/MouseButtonEvent;", "mouseButtonEvent", "handleMouseClicked", "(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/input/MouseButtonEvent;)Z", "handleMouseReleased", "deltaX", "deltaY", "handleMouseDragged", "(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/input/MouseButtonEvent;DD)V", "", "pMsgPos", "handleMoveInHistory", "(Lnet/minecraft/client/gui/screens/ChatScreen;I)V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "", "partialTick", "handleRenderHead", "(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "handleRenderTail", "rawMessage", "handleChatInput", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nChatPlusScreenAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatPlusScreenAdapter.kt\ncom/ebicep/chatplus/hud/ChatPlusScreenAdapter\n+ 2 EventBus.kt\ncom/ebicep/chatplus/events/EventBus\n*L\n1#1,184:1\n67#2:185\n67#2:186\n67#2:187\n67#2:188\n67#2:189\n67#2:190\n67#2:191\n67#2:192\n67#2:193\n67#2:194\n67#2:195\n67#2:196\n67#2:197\n*S KotlinDebug\n*F\n+ 1 ChatPlusScreenAdapter.kt\ncom/ebicep/chatplus/hud/ChatPlusScreenAdapter\n*L\n26#1:185\n30#1:186\n34#1:187\n40#1:188\n45#1:189\n51#1:190\n64#1:191\n91#1:192\n97#1:193\n102#1:194\n133#1:195\n138#1:196\n158#1:197\n*E\n"})
public final class ChatPlusScreenAdapter {
    @NotNull
    public static final ChatPlusScreenAdapter INSTANCE = new ChatPlusScreenAdapter();

    private ChatPlusScreenAdapter() {
    }

    /*
     * WARNING - void declaration
     */
    public final void handleInitPre(@NotNull ChatScreen chatScreen) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        IChatScreen cfr_ignored_0 = (IChatScreen)chatScreen;
        int w = Config.INSTANCE.getValues().getInputBoxSettings().getCalculatedWidth();
        ((IChatScreen)chatScreen).setChatPlusWidth(w < 0 || Config.INSTANCE.getValues().getVanillaInputBox() ? chatScreen.width : w);
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenInitPreEvent data$iv = new ChatScreenInitPreEvent(chatScreen);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenInitPreEvent.class, data$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleInitPost(@NotNull ChatScreen chatScreen) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenInitPostEvent data$iv = new ChatScreenInitPostEvent(chatScreen);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenInitPostEvent.class, data$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleRemoved(@NotNull ChatScreen chatScreen) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenCloseEvent data$iv = new ChatScreenCloseEvent(chatScreen);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenCloseEvent.class, data$iv);
        ChatTab.resetChatScroll$default(ChatManager.INSTANCE.getGlobalSelectedTab(), false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handleOnEdited(@NotNull ChatScreen chatScreen, @NotNull String str) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenInputBoxEditEvent data$iv = new ChatScreenInputBoxEditEvent(chatScreen, str, false, 4, null);
        boolean $i$f$post = false;
        return this_$iv.post(ChatScreenInputBoxEditEvent.class, data$iv).getReturnFunction();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handleKeyPressed(@NotNull ChatScreen chatScreen, @NotNull KeyEvent keyEvent) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        ChatScreenKeyPressedEvent event = new ChatScreenKeyPressedEvent(chatScreen, keyEvent, false, 4, null);
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenInputEvent data$iv = new ChatScreenInputEvent(event);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenInputEvent.class, data$iv);
        return event.getReturnFunction();
    }

    /*
     * WARNING - void declaration
     */
    public final void handleKeyReleased(@NotNull ChatScreen chatScreen, @NotNull KeyEvent keyEvent) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        ChatScreenKeyReleasedEvent event = new ChatScreenKeyReleasedEvent(chatScreen, keyEvent, false, 4, null);
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenInputEvent data$iv = new ChatScreenInputEvent(event);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenInputEvent.class, data$iv);
    }

    public final void handlePageUpDown(boolean up) {
        ChatTab globalSelectedTab = ChatManager.INSTANCE.getGlobalSelectedTab();
        if (up) {
            globalSelectedTab.scrollChat(ChatRenderer.getLinesPerPage$default(globalSelectedTab.getChatWindow().getRenderer(), null, 1, null) - 1);
        } else {
            globalSelectedTab.scrollChat(-ChatRenderer.getLinesPerPage$default(globalSelectedTab.getChatWindow().getRenderer(), null, 1, null) + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handleMouseScrolled(@NotNull ChatScreen chatScreen, double mouseX, double mouseY, double amountX, double amountY) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenMouseScrolledEvent data$iv = new ChatScreenMouseScrolledEvent(chatScreen, mouseX, mouseY, amountX, amountY, false, 32, null);
        boolean $i$f$post = false;
        if (this_$iv.post(ChatScreenMouseScrolledEvent.class, data$iv).getReturnFunction()) {
            return true;
        }
        return this.scrollChat(amountY);
    }

    public final boolean scrollChat(double amountY) {
        Window window = Minecraft.getInstance().getWindow();
        if (InputConstants.isKeyDown((Window)window, (int)Config.INSTANCE.getValues().getKeyNoScroll().getValue())) {
            return true;
        }
        double scrollAmount = Config.INSTANCE.getValues().getInvertedScrolling() ? -amountY : amountY;
        double delta = Mth.clamp((double)scrollAmount, (double)-1.0, (double)1.0);
        if (InputConstants.isKeyDown((Window)window, (int)Config.INSTANCE.getValues().getKeyLargeScroll().getValue())) {
            delta *= 21.0;
        } else if (!InputConstants.isKeyDown((Window)window, (int)Config.INSTANCE.getValues().getKeyFineScroll().getValue())) {
            delta *= 7.0;
        }
        ChatManager.INSTANCE.getGlobalSelectedTab().scrollChat((int)delta);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handleMouseClicked(@NotNull ChatScreen chatScreen, @NotNull MouseButtonEvent mouseButtonEvent) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)mouseButtonEvent, (String)"mouseButtonEvent");
        ChatScreenMouseClickedEvent event = new ChatScreenMouseClickedEvent(chatScreen, mouseButtonEvent, false, 4, null);
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenInputEvent data$iv = new ChatScreenInputEvent(event);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenInputEvent.class, data$iv);
        return event.getReturnFunction();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handleMouseReleased(@NotNull ChatScreen chatScreen, @NotNull MouseButtonEvent mouseButtonEvent) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)mouseButtonEvent, (String)"mouseButtonEvent");
        ChatScreenMouseReleasedEvent event = new ChatScreenMouseReleasedEvent(chatScreen, mouseButtonEvent, false, 4, null);
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenInputEvent data$iv = new ChatScreenInputEvent(event);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenInputEvent.class, data$iv);
        return event.getReturnFunction();
    }

    /*
     * WARNING - void declaration
     */
    public final void handleMouseDragged(@NotNull ChatScreen chatScreen, @NotNull MouseButtonEvent mouseButtonEvent, double deltaX, double deltaY) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)mouseButtonEvent, (String)"mouseButtonEvent");
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenMouseDraggedEvent data$iv = new ChatScreenMouseDraggedEvent(chatScreen, mouseButtonEvent, deltaX, deltaY);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenMouseDraggedEvent.class, data$iv);
    }

    public final void handleMoveInHistory(@NotNull ChatScreen chatScreen, int pMsgPos) {
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        IMixinChatScreen cfr_ignored_0 = (IMixinChatScreen)chatScreen;
        int i = ((IMixinChatScreen)chatScreen).getHistoryPos() + pMsgPos;
        int j = ChatManager.INSTANCE.getSentMessages().size();
        i = Mth.clamp((int)i, (int)0, (int)j);
        if (i != ((IMixinChatScreen)chatScreen).getHistoryPos()) {
            EditBox input = ((IMixinChatScreen)chatScreen).getInput();
            if (i == j) {
                ((IMixinChatScreen)chatScreen).setHistoryPos(j);
                input.setValue(((IMixinChatScreen)chatScreen).getHistoryBuffer());
            } else {
                if (((IMixinChatScreen)chatScreen).getHistoryPos() == j) {
                    ((IMixinChatScreen)chatScreen).setHistoryBuffer(input.getValue());
                }
                input.setValue(ChatManager.INSTANCE.getSentMessages().get(i));
                ((IMixinChatScreen)chatScreen).getCommandSuggestions().setAllowSuggestions(false);
                ((IMixinChatScreen)chatScreen).setHistoryPos(i);
            }
            ((IMixinScreen)chatScreen).callSetInitialFocus((GuiEventListener)input);
        }
    }

    public final void handleRenderHead(@NotNull ChatScreen chatScreen, @NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        ChatPlusScreen.INSTANCE.setLastMouseX(mouseX);
        ChatPlusScreen.INSTANCE.setLastMouseY(mouseY);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleRenderTail(@NotNull ChatScreen chatScreen, @NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenRenderEvent data$iv = new ChatScreenRenderEvent(chatScreen, guiGraphics, mouseX, mouseY, partialTick);
        boolean $i$f$post = false;
        this_$iv.post(ChatScreenRenderEvent.class, data$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean handleChatInput(@NotNull ChatScreen chatScreen, @NotNull String rawMessage) {
        void data$iv;
        void this_$iv;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)chatScreen, (String)"chatScreen");
        Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
        IMixinChatScreen cfr_ignored_0 = (IMixinChatScreen)chatScreen;
        EventBus eventBus = EventBus.INSTANCE;
        ChatScreenSendMessagePreEvent data$iv2 = new ChatScreenSendMessagePreEvent(chatScreen, rawMessage, false, 4, null);
        boolean $i$f$post = false;
        ChatScreenSendMessagePreEvent sendMessageEvent = this_$iv2.post(ChatScreenSendMessagePreEvent.class, data$iv2);
        Minecraft minecraft = chatScreen.minecraft;
        Intrinsics.checkNotNull((Object)minecraft);
        Minecraft minecraft2 = minecraft;
        if (sendMessageEvent.getReturnFunction()) {
            return minecraft2.screen == chatScreen;
        }
        String newMessage = sendMessageEvent.getMessage();
        String normalizeChatMessage = ChatPlusScreen.INSTANCE.normalizeChatMessage(newMessage);
        if (((CharSequence)normalizeChatMessage).length() == 0) {
            return true;
        }
        List<String> messages = ChatPlusScreen.INSTANCE.splitChatMessage(normalizeChatMessage);
        if (messages.isEmpty()) {
            return minecraft2.screen == chatScreen;
        }
        String sentMessage = messages.get(0);
        if (!Intrinsics.areEqual((Object)rawMessage, (Object)newMessage)) {
            sentMessage = ChatPlusScreen.INSTANCE.splitChatMessage(rawMessage).get(0);
        }
        String messageToSend = chatScreen.normalizeChatMessage(messages.get(0));
        EventBus eventBus2 = EventBus.INSTANCE;
        Intrinsics.checkNotNull((Object)messageToSend);
        ChatScreenSendMessagePostEvent chatScreenSendMessagePostEvent = new ChatScreenSendMessagePostEvent(chatScreen, newMessage, sentMessage, messageToSend, normalizeChatMessage, messages, false, 64, null);
        boolean $i$f$post2 = false;
        if (((ChatScreenSendMessagePostEvent)this_$iv.post(ChatScreenSendMessagePostEvent.class, data$iv)).getDontSendMessage()) {
            return minecraft2.screen == chatScreen;
        }
        ChatManager.INSTANCE.addSentMessage(sentMessage);
        if (StringsKt.startsWith$default((String)normalizeChatMessage, (String)"/", (boolean)false, (int)2, null)) {
            LocalPlayer localPlayer = minecraft2.player;
            Intrinsics.checkNotNull((Object)localPlayer);
            ClientPacketListener clientPacketListener = localPlayer.connection;
            String string = messageToSend.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            clientPacketListener.sendCommand(string);
        } else {
            LocalPlayer localPlayer = minecraft2.player;
            Intrinsics.checkNotNull((Object)localPlayer);
            localPlayer.connection.sendChat(messageToSend);
            if (messages.size() > 1) {
                InputOverFlowAutoFill.INSTANCE.addToQueue(messages.subList(1, messages.size()));
            }
        }
        return minecraft2.screen == chatScreen;
    }
}

