/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.mixin;

import com.ebicep.chatplus.IChatScreen;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.features.MovableChat;
import com.ebicep.chatplus.features.TranslateMessage;
import com.ebicep.chatplus.hud.ChatManager;
import com.ebicep.chatplus.hud.ChatPlusScreenAdapter;
import com.ebicep.chatplus.mixin.IMixinChatScreen;
import com.ebicep.chatplus.translator.LanguageManager;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class}, priority=0x7FFFFFFF)
@Implements(value={@Interface(iface=IChatScreen.class, prefix="chatPlus$")})
public abstract class MixinChatScreen
extends Screen
implements IMixinChatScreen,
IChatScreen {
    @Shadow
    protected EditBox input;
    @Unique
    private int chatPlus$w;

    protected MixinChatScreen(Component component) {
        super(component);
    }

    public int chatPlus$getChatPlusWidth() {
        return this.chatPlus$w;
    }

    public void chatPlus$setChatPlusWidth(int chatPlus$w) {
        this.chatPlus$w = chatPlus$w;
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    private void initHead(CallbackInfo ci) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handleInitPre(this.thisScreen());
    }

    @Unique
    private ChatScreen thisScreen() {
        return (ChatScreen)this;
    }

    @ModifyExpressionValue(method={"init()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/ArrayListDeque;size()I")})
    private int initModifyVariable(int original) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return original;
        }
        return ChatManager.INSTANCE.getSentMessages().size();
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    private void initTail(CallbackInfo ci) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handleInitPost(this.thisScreen());
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen$1;<init>(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/network/chat/Component;)V"), index=2)
    private int modifyChatScreenStartX(int x) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return x;
        }
        if (Config.INSTANCE.getValues().getVanillaInputBox()) {
            return x;
        }
        return Config.INSTANCE.getValues().getInputBoxSettings().getStartX();
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen$1;<init>(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/network/chat/Component;)V"), index=3)
    private int modifyChatScreenStartY(int y) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return y;
        }
        if (Config.INSTANCE.getValues().getVanillaInputBox()) {
            return y;
        }
        return Config.INSTANCE.getValues().getInputBoxSettings().getCalculatedStartY();
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen$1;<init>(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/network/chat/Component;)V"), index=4)
    private int modifyChatScreenWidth(int width) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return width;
        }
        return this.chatPlus$w - 5;
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/ChatScreen$1;<init>(Lnet/minecraft/client/gui/screens/ChatScreen;Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/network/chat/Component;)V"), index=5)
    private int modifyChatScreenHeight(int height) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return height;
        }
        if (Config.INSTANCE.getValues().getVanillaInputBox()) {
            return height;
        }
        return 14;
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;setMaxLength(I)V"))
    private int modifyChatScreenMaxLength(int maxLength) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return maxLength;
        }
        return Config.INSTANCE.getValues().getInputBoxSettings().getMaxInputBoxInputLength();
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;setCanLoseFocus(Z)V"))
    private boolean modifyChatScreenCanLoseFocus(boolean canLoseFocus) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return canLoseFocus;
        }
        return true;
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CommandSuggestions;<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/screens/Screen;Lnet/minecraft/client/gui/components/EditBox;Lnet/minecraft/client/gui/Font;ZZIIZI)V"), index=7)
    private int modifyChatScreenCommandSuggestionsMaxHeight(int maxSuggestions) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return maxSuggestions;
        }
        return Config.INSTANCE.getValues().getMaxCommandSuggestions();
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CommandSuggestions;<init>(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/screens/Screen;Lnet/minecraft/client/gui/components/EditBox;Lnet/minecraft/client/gui/Font;ZZIIZI)V"), index=8)
    private boolean modifyChatScreenCommandSuggestionsAnchor(boolean bl) {
        if (!Config.INSTANCE.getValues().getEnabled() || Config.INSTANCE.getValues().getVanillaInputBox()) {
            return bl;
        }
        return Config.INSTANCE.getValues().getInputBoxSettings().renderBottom();
    }

    @Inject(method={"removed()V"}, at={@At(value="HEAD")})
    private void removed(CallbackInfo ci) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handleRemoved(this.thisScreen());
    }

    @Inject(method={"onEdited(Ljava/lang/String;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEdited(String str, CallbackInfo ci) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        if (ChatPlusScreenAdapter.INSTANCE.handleOnEdited(this.thisScreen(), str)) {
            ci.cancel();
        }
    }

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void keyPressed(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        if (ChatPlusScreenAdapter.INSTANCE.handleKeyPressed(this.thisScreen(), keyEvent)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;scrollChat(I)V", ordinal=0)})
    private void keyPressedPageUp(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handlePageUpDown(true);
    }

    @Inject(method={"keyPressed(Lnet/minecraft/client/input/KeyEvent;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;scrollChat(I)V", ordinal=1)})
    private void keyPressedPageDown(KeyEvent keyEvent, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handlePageUpDown(false);
    }

    @Inject(method={"mouseScrolled(DDDD)Z"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true)
    private void mouseScrolled(double mouseX, double mouseY, double amountX, double amountY, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        if (ChatPlusScreenAdapter.INSTANCE.handleMouseScrolled(this.thisScreen(), mouseX, mouseY, amountX, amountY)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @ModifyExpressionValue(method={"mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CommandSuggestions;mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;)Z")})
    private boolean mouseClickedCommandSuggestions(boolean original, @Share(value="clicked") LocalBooleanRef booleanRef) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return original;
        }
        booleanRef.set(original);
        return original;
    }

    @Inject(method={"mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CommandSuggestions;mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;)Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void mouseClickedAfter(MouseButtonEvent mouseButtonEvent, boolean bl, CallbackInfoReturnable<Boolean> cir, @Share(value="clicked") LocalBooleanRef booleanRef) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        if (booleanRef.get()) {
            return;
        }
        if (ChatPlusScreenAdapter.INSTANCE.handleMouseClicked(this.thisScreen(), mouseButtonEvent)) {
            cir.setReturnValue((Object)true);
            cir.cancel();
        }
    }

    @ModifyExpressionValue(method={"mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/CommandSuggestions;mouseClicked(Lnet/minecraft/client/input/MouseButtonEvent;)Z")})
    private boolean mouseClickedEditBox(boolean original) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return original;
        }
        return this.input.isFocused() && original;
    }

    public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return super.mouseReleased(mouseButtonEvent);
        }
        return ChatPlusScreenAdapter.INSTANCE.handleMouseReleased(this.thisScreen(), mouseButtonEvent);
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double deltaX, double deltaY) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return super.mouseDragged(mouseButtonEvent, deltaX, deltaY);
        }
        ChatPlusScreenAdapter.INSTANCE.handleMouseDragged(this.thisScreen(), mouseButtonEvent, deltaX, deltaY);
        if (!ChatManager.INSTANCE.isChatFocused() || mouseButtonEvent.button() != 0) {
            return super.mouseDragged(mouseButtonEvent, deltaX, deltaY);
        }
        return true;
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        if (Config.INSTANCE.getValues().getEnabled()) {
            ChatPlusScreenAdapter.INSTANCE.handleKeyReleased(this.thisScreen(), keyEvent);
        }
        return super.keyReleased(keyEvent);
    }

    @Inject(method={"moveInHistory(I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void moveInHistory(int i, CallbackInfo ci) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handleMoveInHistory(this.thisScreen(), i);
        ci.cancel();
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void renderHead(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handleRenderHead(this.thisScreen(), guiGraphics, mouseX, mouseY, partialTick);
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), index=0)
    private int renderFillStartX(int x) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return x;
        }
        MovableChat.InputBoxSettings inputBoxSettings = Config.INSTANCE.getValues().getInputBoxSettings();
        if (LanguageManager.INSTANCE.getLanguageSpeakEnabled()) {
            if (Config.INSTANCE.getValues().getVanillaInputBox()) {
                return TranslateMessage.INSTANCE.getTRANSLATE_PREFIX_INPUT_WIDTH() + inputBoxSettings.getStartX();
            }
            return TranslateMessage.INSTANCE.getTRANSLATE_PREFIX_INPUT_WIDTH();
        }
        if (Config.INSTANCE.getValues().getVanillaInputBox()) {
            return x;
        }
        return inputBoxSettings.getStartX() - 2;
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), index=1)
    private int renderFillStartY(int y) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return y;
        }
        if (Config.INSTANCE.getValues().getVanillaInputBox()) {
            return y;
        }
        return Config.INSTANCE.getValues().getInputBoxSettings().getCalculatedStartY() - 4;
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), index=2)
    private int renderFillWidth(int x) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return x;
        }
        if (Config.INSTANCE.getValues().getVanillaInputBox()) {
            return this.chatPlus$w;
        }
        return Config.INSTANCE.getValues().getInputBoxSettings().getStartX() + this.chatPlus$w;
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fill(IIIII)V"), index=3)
    private int renderFillHeight(int y) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return y;
        }
        if (Config.INSTANCE.getValues().getVanillaInputBox()) {
            return y;
        }
        return Config.INSTANCE.getValues().getInputBoxSettings().getCalculatedStartY() + 10;
    }

    @ModifyExpressionValue(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;getMessageTagAt(DD)Lnet/minecraft/client/GuiMessageTag;")})
    private GuiMessageTag renderModifyVariable(GuiMessageTag original) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return original;
        }
        return null;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    private void renderTail(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handleRenderTail(this.thisScreen(), guiGraphics, mouseX, mouseY, partialTick);
    }

    @Inject(method={"getComponentStyleAt(DD)Lnet/minecraft/network/chat/Style;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getComponentStyleAtRedirect(double mouseX, double mouseY, CallbackInfoReturnable<Style> cir) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        cir.setReturnValue((Object)ChatManager.INSTANCE.getGlobalSelectedTab().getComponentStyleAt(mouseX, mouseY));
        cir.cancel();
    }

    @Inject(method={"handleChatInput(Ljava/lang/String;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleChatInput(String string, boolean bl, CallbackInfo ci) {
        if (!Config.INSTANCE.getValues().getEnabled()) {
            return;
        }
        ChatPlusScreenAdapter.INSTANCE.handleChatInput(this.thisScreen(), string);
        ci.cancel();
    }
}

