/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.translator;

import com.ebicep.chatplus.features.InputOverFlowAutoFill;
import com.ebicep.chatplus.hud.ChatManager;
import com.ebicep.chatplus.hud.ChatPlusScreen;
import com.ebicep.chatplus.translator.Language;
import com.ebicep.chatplus.translator.LanguageManager;
import com.ebicep.chatplus.translator.TranslateResult;
import com.ebicep.chatplus.translator.Translator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\n\u001a\u0004\b\r\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/ebicep/chatplus/translator/SelfTranslator;", "Ljava/lang/Thread;", "", "toTranslate", "prefix", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "", "run", "()V", "Ljava/lang/String;", "getToTranslate", "()Ljava/lang/String;", "getPrefix", "chatplus-common"})
public final class SelfTranslator
extends Thread {
    @NotNull
    private final String toTranslate;
    @NotNull
    private final String prefix;

    public SelfTranslator(@NotNull String toTranslate, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)toTranslate, (String)"toTranslate");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.toTranslate = toTranslate;
        this.prefix = prefix;
    }

    @NotNull
    public final String getToTranslate() {
        return this.toTranslate;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @Override
    public void run() {
        block8: {
            Language language = LanguageManager.INSTANCE.getLanguageSpeak();
            if (language == null) break block8;
            Language it = language;
            boolean bl = false;
            Translator translator = new Translator(this.toTranslate, LanguageManager.INSTANCE.getLanguageSelf(), it, false, 8, null);
            TranslateResult translateResult = translator.translate(this.toTranslate);
            if (translateResult == null) {
                return;
            }
            TranslateResult translateResult2 = translateResult;
            List<String> messages = ChatPlusScreen.INSTANCE.splitChatMessage(translateResult2.getTranslatedText());
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            Intrinsics.checkNotNull((Object)localPlayer);
            ClientPacketListener connection = localPlayer.connection;
            String translatedMessage = messages.get(0);
            ChatManager.INSTANCE.addSentMessage(translatedMessage);
            if (((CharSequence)this.prefix).length() == 0) {
                if (StringsKt.startsWith$default((String)translatedMessage, (String)"/", (boolean)false, (int)2, null)) {
                    String string = translatedMessage.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    connection.sendCommand(string);
                } else {
                    connection.sendChat(translatedMessage);
                }
            } else if (StringsKt.startsWith$default((String)this.prefix, (String)"/", (boolean)false, (int)2, null)) {
                String string = this.prefix.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                connection.sendCommand(((Object)StringsKt.trim((CharSequence)string)).toString() + translatedMessage);
            } else {
                connection.sendChat(this.prefix + " " + translatedMessage);
            }
            if (messages.size() > 1) {
                InputOverFlowAutoFill.INSTANCE.addToQueue(messages.subList(1, messages.size()));
            }
        }
    }
}

