/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.chatplus.translator;

import com.ebicep.chatplus.ChatPlus;
import com.ebicep.chatplus.config.Config;
import com.ebicep.chatplus.features.internal.MessageFilter;
import com.ebicep.chatplus.translator.GoogleRequester;
import com.ebicep.chatplus.translator.Language;
import com.ebicep.chatplus.translator.RequestResult;
import com.ebicep.chatplus.translator.TranslateResult;
import com.ebicep.chatplus.util.ComponentUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ%\u0010\u0010\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0012\u0010\rJ+\u0010\u0017\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010!R\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\"\u001a\u0004\b%\u0010$R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lcom/ebicep/chatplus/translator/Translator;", "Ljava/lang/Thread;", "", "message", "Lcom/ebicep/chatplus/translator/Language;", "from", "to", "", "filtered", "<init>", "(Ljava/lang/String;Lcom/ebicep/chatplus/translator/Language;Lcom/ebicep/chatplus/translator/Language;Z)V", "", "run", "()V", "text", "Lkotlin/Pair;", "filterText", "(Ljava/lang/String;)Lkotlin/Pair;", "onTranslateSameMessage", "matchedRegex", "Lcom/ebicep/chatplus/translator/TranslateResult;", "translatedMessage", "fromLanguage", "onTranslate", "(Ljava/lang/String;Lcom/ebicep/chatplus/translator/TranslateResult;Ljava/lang/String;)V", "translate", "(Ljava/lang/String;)Lcom/ebicep/chatplus/translator/TranslateResult;", "Lcom/ebicep/chatplus/translator/RequestResult;", "transRequest", "logException", "(Lcom/ebicep/chatplus/translator/RequestResult;)V", "Ljava/lang/String;", "getMessage", "()Ljava/lang/String;", "Lcom/ebicep/chatplus/translator/Language;", "getFrom", "()Lcom/ebicep/chatplus/translator/Language;", "getTo", "Z", "getFiltered", "()Z", "chatplus-common"})
@SourceDebugExtension(value={"SMAP\nTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Translator.kt\ncom/ebicep/chatplus/translator/Translator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public class Translator
extends Thread {
    @NotNull
    private final String message;
    @Nullable
    private final Language from;
    @NotNull
    private final Language to;
    private final boolean filtered;

    public Translator(@NotNull String message, @Nullable Language from, @NotNull Language to, boolean filtered) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.message = message;
        this.from = from;
        this.to = to;
        this.filtered = filtered;
    }

    public /* synthetic */ Translator(String string, Language language, Language language2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(string, language, language2, bl);
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @Nullable
    public final Language getFrom() {
        return this.from;
    }

    @NotNull
    public final Language getTo() {
        return this.to;
    }

    public final boolean getFiltered() {
        return this.filtered;
    }

    @Override
    public void run() {
        ChatPlus.INSTANCE.getLOGGER().debug("Translating message: {} | {} -> {} | filtered: {}", (Object)this.message, (Object)this.from, (Object)this.to, (Object)this.filtered);
        Pair pair = this.filtered ? this.filterText(this.message) : TuplesKt.to(null, (Object)this.message);
        String matchedRegex = (String)pair.component1();
        String textToTranslate = (String)pair.component2();
        if (this.filtered && matchedRegex == null) {
            ChatPlus.INSTANCE.getLOGGER().debug("No regex match found for filtered message");
            return;
        }
        TranslateResult translateResult = this.translate(textToTranslate);
        if (translateResult == null) {
            Translator $this$run_u24lambda_u240 = this;
            boolean bl = false;
            ChatPlus.INSTANCE.getLOGGER().debug("Translation failed for: " + textToTranslate);
            return;
        }
        TranslateResult translatedMessage = translateResult;
        if (StringsKt.equals((String)((Object)StringsKt.trim((CharSequence)translatedMessage.getTranslatedText())).toString(), (String)textToTranslate, (boolean)true)) {
            ChatPlus.INSTANCE.getLOGGER().debug(this.message + " is the same after translation");
            this.onTranslateSameMessage();
            return;
        }
        ChatPlus.INSTANCE.getLOGGER().debug("Translated message: " + translatedMessage.getTranslatedText());
        Language language = translatedMessage.getFrom();
        this.onTranslate(matchedRegex, translatedMessage, language != null ? language.getName() : null);
    }

    private final Pair<String, String> filterText(String text) {
        for (MessageFilter regexMatch : Config.INSTANCE.getValues().getTranslatorRegexes()) {
            String pattern;
            Matcher matcher;
            String string;
            String it = string = regexMatch.getPattern();
            boolean bl = false;
            String string2 = ((CharSequence)it).length() > 0 ? string : null;
            if (string2 == null || !(matcher = Pattern.compile(pattern = string2).matcher(text)).find()) continue;
            String matchedRegex = matcher.group(0);
            Intrinsics.checkNotNull((Object)matchedRegex);
            String filteredText = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)text, (String)matchedRegex, (String)"", (boolean)false, (int)4, null))).toString();
            return TuplesKt.to((Object)matchedRegex, (Object)filteredText);
        }
        return TuplesKt.to(null, (Object)text);
    }

    public void onTranslateSameMessage() {
    }

    public void onTranslate(@Nullable String matchedRegex, @NotNull TranslateResult translatedMessage, @Nullable String fromLanguage) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)translatedMessage, (String)"translatedMessage");
            LocalPlayer localPlayer = Minecraft.getInstance().player;
            if (localPlayer == null) break block2;
            String string = matchedRegex;
            if (string == null) {
                string = "";
            }
            String string2 = translatedMessage.getTranslatedText();
            String string3 = fromLanguage;
            if (string3 == null) {
                string3 = "Unknown";
            }
            localPlayer.sendSystemMessage((Component)ComponentUtil.literal$default(ComponentUtil.INSTANCE, string + string2 + " (" + string3 + ")", ChatFormatting.GREEN, null, 4, null));
        }
    }

    @Nullable
    public final TranslateResult translate(@NotNull String text) {
        RequestResult transRequest;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (Intrinsics.areEqual((Object)this.from, (Object)this.to)) {
            return null;
        }
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)text)).toString()).length() == 0) {
            return null;
        }
        if (GoogleRequester.Companion.getAccessDenied()) {
            return null;
        }
        GoogleRequester google = new GoogleRequester();
        RequestResult requestResult = transRequest = this.from == null ? google.translateAuto(text, this.to) : google.performTranslationRequest(text, this.from, this.to);
        if (transRequest.getCode() != 200) {
            this.logException(transRequest);
            return null;
        }
        if (transRequest.getFrom() == null) {
            return null;
        }
        return new TranslateResult(((Object)StringsKt.trim((CharSequence)transRequest.getMessage())).toString(), transRequest.getFrom());
    }

    private final void logException(RequestResult transRequest) {
        switch (transRequest.getCode()) {
            case 1: {
                ChatPlus.INSTANCE.getLOGGER().error("Cannot connect to translation server. Is player offline?");
                break;
            }
            case 2: {
                ChatPlus.INSTANCE.getLOGGER().error(transRequest.getMessage());
                break;
            }
            case 411: {
                ChatPlus.INSTANCE.getLOGGER().error("Google API >> API call error");
                break;
            }
            case 429: {
                ChatPlus.INSTANCE.getLOGGER().warn("Google denied access to translation API. Pausing translation for 5 minutes");
                break;
            }
            case 403: {
                ChatPlus.INSTANCE.getLOGGER().error("Google API >> Exceeded API quota / User rate limit reached");
                break;
            }
            case 400: {
                ChatPlus.INSTANCE.getLOGGER().error("Google API >> API key invalid");
                break;
            }
            case 500: {
                ChatPlus.INSTANCE.getLOGGER().error("Google API >> Failed to determine source language: " + transRequest.getMessage());
                break;
            }
            default: {
                ChatPlus.INSTANCE.getLOGGER().error("Unknown error/Server side failure: " + transRequest.getMessage());
            }
        }
    }
}

