/*
 * Decompiled with CFR 0.152.
 */
package zepsizola.me.zPvPToggle.commands.subcommands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import zepsizola.me.zPvPToggle.ZPvPToggle;
import zepsizola.me.zPvPToggle.commands.SubCommand;
import zepsizola.me.zPvPToggle.indicator.ParticleRingManager;
import zepsizola.me.zPvPToggle.indicator.ParticleRingSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J3\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0017H\u0016\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u001c"}, d2={"Lzepsizola/me/zPvPToggle/commands/subcommands/IndicatorCommand;", "Lzepsizola/me/zPvPToggle/commands/SubCommand;", "()V", "description", "", "getDescription", "()Ljava/lang/String;", "name", "getName", "permission", "getPermission", "playerOnly", "", "getPlayerOnly", "()Z", "usage", "getUsage", "execute", "plugin", "Lzepsizola/me/zPvPToggle/ZPvPToggle;", "sender", "Lorg/bukkit/command/CommandSender;", "args", "", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)Z", "tabComplete", "", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)Ljava/util/List;", "ZPvPToggle"})
@SourceDebugExtension(value={"SMAP\nIndicatorCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndicatorCommand.kt\nzepsizola/me/zPvPToggle/commands/subcommands/IndicatorCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1549#2:102\n1620#2,3:103\n766#2:106\n857#2,2:107\n*S KotlinDebug\n*F\n+ 1 IndicatorCommand.kt\nzepsizola/me/zPvPToggle/commands/subcommands/IndicatorCommand\n*L\n90#1:102\n90#1:103,3\n91#1:106\n91#1:107,2\n*E\n"})
public final class IndicatorCommand
implements SubCommand {
    @NotNull
    private final String name;
    @NotNull
    private final String permission;
    private final boolean playerOnly;
    @NotNull
    private final String description;
    @NotNull
    private final String usage;

    public IndicatorCommand() {
        this.name = "indicator";
        this.permission = "zpvptoggle.user";
        this.playerOnly = true;
        this.description = "Change your PvP indicator ring style";
        this.usage = "/pvp indicator <style>";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPermission() {
        return this.permission;
    }

    @Override
    public boolean getPlayerOnly() {
        return this.playerOnly;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getUsage() {
        return this.usage;
    }

    @Override
    public boolean execute(@NotNull ZPvPToggle plugin, @NotNull CommandSender sender, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!(sender instanceof Player)) {
            return false;
        }
        ParticleRingManager ringManager = new ParticleRingManager(plugin);
        ringManager.loadRings();
        if (args.length == 0) {
            String currentRing = plugin.getPvpManager().getIndicatorRingId((Player)sender);
            sender.sendMessage(plugin.getMessageManager().getMessage("indicator.available_styles", MapsKt.mapOf((Pair)TuplesKt.to((Object)"%indicator%", (Object)currentRing))));
            ParticleRingSettings defaultRing = ringManager.getDefaultRing();
            for (ParticleRingSettings ring : ringManager.getAllRings()) {
                if (!Intrinsics.areEqual((Object)ring.getId(), (Object)defaultRing.getId()) && !sender.hasPermission("zpvptoggle.indicator." + ring.getId())) continue;
                String selected = Intrinsics.areEqual((Object)ring.getId(), (Object)currentRing) ? " (selected)" : "";
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"%indicator%", (Object)ring.getId()), TuplesKt.to((Object)"%selected%", (Object)selected)};
                sender.sendMessage(plugin.getMessageManager().getMessage("indicator.style_entry", MapsKt.mapOf((Pair[])pairArray)));
            }
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String ringId = string;
        ParticleRingSettings ring = ringManager.getRing(ringId);
        if (!Intrinsics.areEqual((Object)ring.getId(), (Object)ringId)) {
            sender.sendMessage(plugin.getMessageManager().getMessage("indicator.not_found", MapsKt.mapOf((Pair)TuplesKt.to((Object)"%indicator%", (Object)ringId))));
            return true;
        }
        ParticleRingSettings defaultRing = ringManager.getDefaultRing();
        if (!Intrinsics.areEqual((Object)ring.getId(), (Object)defaultRing.getId()) && !sender.hasPermission("zpvptoggle.indicator." + ring.getId())) {
            sender.sendMessage(plugin.getMessageManager().getMessage("indicator.no_permission", MapsKt.mapOf((Pair)TuplesKt.to((Object)"%indicator%", (Object)ringId))));
            return true;
        }
        plugin.getPvpManager().setIndicatorRing((Player)sender, ringId);
        sender.sendMessage(plugin.getMessageManager().getMessage("indicator.set_success", MapsKt.mapOf((Pair)TuplesKt.to((Object)"%indicator%", (Object)ringId))));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> tabComplete(@NotNull ZPvPToggle plugin, @NotNull CommandSender sender, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 1) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            ParticleRingManager ringManager = new ParticleRingManager(plugin);
            ringManager.loadRings();
            ParticleRingSettings defaultRing = ringManager.getDefaultRing();
            String string = args[0].toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String input = string;
            Iterable iterable = ringManager.getAllRings();
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ParticleRingSettings particleRingSettings = (ParticleRingSettings)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((ParticleRingSettings)((Object)it)).getId());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = StringsKt.startsWith$default((String)it, (String)input, (boolean)false, (int)2, null) && (Intrinsics.areEqual((Object)it, (Object)defaultRing.getId()) || sender instanceof Player && sender.hasPermission("zpvptoggle.indicator." + it));
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return SubCommand.DefaultImpls.getAliases(this);
    }

    @Override
    public boolean hasPermission(@NotNull CommandSender sender) {
        return SubCommand.DefaultImpls.hasPermission(this, sender);
    }

    @Override
    public boolean canExecute(@NotNull CommandSender sender) {
        return SubCommand.DefaultImpls.canExecute(this, sender);
    }
}

