/*
 * Decompiled with CFR 0.152.
 */
package zepsizola.me.zPvPToggle.commands.subcommands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import zepsizola.me.zPvPToggle.ZPvPToggle;
import zepsizola.me.zPvPToggle.commands.SubCommand;
import zepsizola.me.zPvPToggle.managers.MessageManager;
import zepsizola.me.zPvPToggle.managers.PvpManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ3\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001bH\u0016\u00a2\u0006\u0002\u0010\u001eR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u001f"}, d2={"Lzepsizola/me/zPvPToggle/commands/subcommands/ToggleCommand;", "Lzepsizola/me/zPvPToggle/commands/SubCommand;", "()V", "aliases", "", "", "getAliases", "()Ljava/util/List;", "description", "getDescription", "()Ljava/lang/String;", "name", "getName", "permission", "getPermission", "playerOnly", "", "getPlayerOnly", "()Z", "usage", "getUsage", "execute", "plugin", "Lzepsizola/me/zPvPToggle/ZPvPToggle;", "sender", "Lorg/bukkit/command/CommandSender;", "args", "", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)Z", "tabComplete", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)Ljava/util/List;", "ZPvPToggle"})
@SourceDebugExtension(value={"SMAP\nToggleCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToggleCommand.kt\nzepsizola/me/zPvPToggle/commands/subcommands/ToggleCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1549#2:91\n1620#2,3:92\n766#2:95\n857#2,2:96\n*S KotlinDebug\n*F\n+ 1 ToggleCommand.kt\nzepsizola/me/zPvPToggle/commands/subcommands/ToggleCommand\n*L\n83#1:91\n83#1:92,3\n84#1:95\n84#1:96,2\n*E\n"})
public final class ToggleCommand
implements SubCommand {
    @NotNull
    private final String name;
    @NotNull
    private final String permission;
    private final boolean playerOnly;
    @NotNull
    private final String description;
    @NotNull
    private final String usage;
    @NotNull
    private final List<String> aliases = CollectionsKt.listOf((Object)"");

    public ToggleCommand() {
        this.name = "toggle";
        this.permission = "zpvptoggle.user";
        this.description = "Toggle your PvP status or another player's";
        this.usage = "/pvp toggle [player]";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getPermission() {
        return this.permission;
    }

    @Override
    public boolean getPlayerOnly() {
        return this.playerOnly;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getUsage() {
        return this.usage;
    }

    @Override
    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public boolean execute(@NotNull ZPvPToggle plugin, @NotNull CommandSender sender, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        PvpManager pvpManager = plugin.getPvpManager();
        MessageManager messageManager = plugin.getMessageManager();
        if (!(args.length == 0) && sender.hasPermission("zpvptoggle.admin")) {
            String targetName = args[0];
            Player targetPlayer = Bukkit.getPlayerExact((String)targetName);
            if (targetPlayer == null) {
                sender.sendMessage(messageManager.getMessage("player_not_found"));
                return true;
            }
            boolean newState = pvpManager.togglePvp(targetPlayer);
            if (newState) {
                targetPlayer.sendMessage(messageManager.getMessage("pvp_enabled"));
                sender.sendMessage(messageManager.getMessage("pvp_enabled_other", MapsKt.mapOf((Pair)TuplesKt.to((Object)"%player%", (Object)targetPlayer.getName()))));
            } else {
                targetPlayer.sendMessage(messageManager.getMessage("pvp_disabled"));
                sender.sendMessage(messageManager.getMessage("pvp_disabled_other", MapsKt.mapOf((Pair)TuplesKt.to((Object)"%player%", (Object)targetPlayer.getName()))));
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(messageManager.getMessage("player_only_command"));
            return true;
        }
        if (pvpManager.hasCooldown((Player)sender)) {
            sender.sendMessage(messageManager.getMessage("pvp_cooldown", MapsKt.mapOf((Pair)TuplesKt.to((Object)"%cooldown%", (Object)pvpManager.getRemainingCooldownString((Player)sender)))));
            return true;
        }
        boolean newState = pvpManager.togglePvp((Player)sender);
        if (newState) {
            if (pvpManager.isFirstToggleOnThisSession((Player)sender) && plugin.getWarningMessageEnabled()) {
                sender.sendMessage(messageManager.getMessage("warning_message"));
            }
            sender.sendMessage(messageManager.getMessage("pvp_enabled"));
        } else {
            sender.sendMessage(messageManager.getMessage("pvp_disabled"));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> tabComplete(@NotNull ZPvPToggle plugin, @NotNull CommandSender sender, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 1 && sender.hasPermission("zpvptoggle.admin")) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String string = args[0].toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String input = string;
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getOnlinePlayers(...)");
            Iterable iterable = collection;
            boolean $i$f$map = false;
            void var7_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Player player = (Player)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getName());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                String string2 = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)input, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean canExecute(@NotNull CommandSender sender) {
        return SubCommand.DefaultImpls.canExecute(this, sender);
    }

    @Override
    public boolean hasPermission(@NotNull CommandSender sender) {
        return SubCommand.DefaultImpls.hasPermission(this, sender);
    }
}

