/*
 * Decompiled with CFR 0.152.
 */
package zepsizola.me.zPvPToggle.data;

import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import zepsizola.me.zPvPToggle.ZPvPToggle;
import zepsizola.me.zPvPToggle.data.DatabaseManager;
import zepsizola.me.zPvPToggle.managers.PlayerState;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lzepsizola/me/zPvPToggle/data/DatabaseManagerImpl;", "", "plugin", "Lzepsizola/me/zPvPToggle/ZPvPToggle;", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;)V", "dbManager", "Lzepsizola/me/zPvPToggle/data/DatabaseManager;", "close", "", "loadPlayerData", "player", "Lorg/bukkit/entity/Player;", "savePlayerIndicator", "indicatorId", "", "savePlayerIndicatorVisibility", "canSeeIndicators", "", "savePlayerOwnIndicatorVisibility", "canSeeOwnIndicator", "ZPvPToggle"})
public final class DatabaseManagerImpl {
    @NotNull
    private final ZPvPToggle plugin;
    @NotNull
    private final DatabaseManager dbManager;

    public DatabaseManagerImpl(@NotNull ZPvPToggle plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.dbManager = DatabaseManager.Companion.create(this.plugin);
        this.dbManager.initialize();
    }

    public final void loadPlayerData(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        try {
            PlayerState state;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            Map<String, Object> data = this.dbManager.loadPlayerData(uUID);
            if (data.containsKey("indicator_id")) {
                Object object = data.get("indicator_id");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String indicatorId = (String)object;
                this.plugin.getPvpManager().setIndicatorRing(player, indicatorId);
            }
            if (data.containsKey("can_see_indicators")) {
                Object object = data.get("can_see_indicators");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean canSeeIndicators = (Boolean)object;
                state = this.plugin.getPvpManager().getState(player);
                state.setCanSeeIndicators(canSeeIndicators);
            }
            if (data.containsKey("can_see_own_indicator")) {
                Object object = data.get("can_see_own_indicator");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                boolean canSeeOwnIndicator = (Boolean)object;
                state = this.plugin.getPvpManager().getState(player);
                state.setCanSeeOwnIndicator(canSeeOwnIndicator);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load player data for " + player.getName(), e);
        }
    }

    public final void savePlayerIndicator(@NotNull Player player, @NotNull String indicatorId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)indicatorId, (String)"indicatorId");
        try {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            this.dbManager.savePlayerIndicator(uUID, indicatorId);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save indicator preference for " + player.getName(), e);
        }
    }

    public final void savePlayerIndicatorVisibility(@NotNull Player player, boolean canSeeIndicators) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        try {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            this.dbManager.savePlayerIndicatorVisibility(uUID, canSeeIndicators);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save indicator visibility for " + player.getName(), e);
        }
    }

    public final void savePlayerOwnIndicatorVisibility(@NotNull Player player, boolean canSeeOwnIndicator) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        try {
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            this.dbManager.savePlayerOwnIndicatorVisibility(uUID, canSeeOwnIndicator);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save own indicator visibility for " + player.getName(), e);
        }
    }

    public final void close() {
        this.dbManager.close();
    }
}

