/*
 * Decompiled with CFR 0.152.
 */
package zepsizola.me.zPvPToggle.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zepsizola.me.zPvPToggle.ZPvPToggle;
import zepsizola.me.zPvPToggle.data.DatabaseManager;
import zepsizola.me.zPvPToggle.libs.hikari.HikariConfig;
import zepsizola.me.zPvPToggle.libs.hikari.HikariDataSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u001c\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001fH\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lzepsizola/me/zPvPToggle/data/MariaDB;", "Lzepsizola/me/zPvPToggle/data/DatabaseManager;", "plugin", "Lzepsizola/me/zPvPToggle/ZPvPToggle;", "host", "", "port", "", "database", "username", "password", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "dataSource", "Lzepsizola/me/zPvPToggle/libs/hikari/HikariDataSource;", "jdbcUrl", "close", "", "createTables", "connection", "Ljava/sql/Connection;", "getConnection", "initialize", "loadPlayerData", "", "", "uuid", "Ljava/util/UUID;", "savePlayerIndicator", "indicatorId", "savePlayerIndicatorVisibility", "canSeeIndicators", "", "savePlayerOwnIndicatorVisibility", "canSeeOwnIndicator", "ZPvPToggle"})
public final class MariaDB
implements DatabaseManager {
    @NotNull
    private final ZPvPToggle plugin;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String database;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @Nullable
    private HikariDataSource dataSource;
    @NotNull
    private final String jdbcUrl;

    public MariaDB(@NotNull ZPvPToggle plugin, @NotNull String host, int port, @NotNull String database, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.plugin = plugin;
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.jdbcUrl = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        try {
            try {
                Class.forName("com.mysql.cj.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                Class.forName("com.mysql.jdbc.Driver");
            }
            HikariConfig config = new HikariConfig();
            config.setJdbcUrl(this.jdbcUrl);
            config.setUsername(this.username);
            config.setPassword(this.password);
            config.setMaximumPoolSize(10);
            config.setMinimumIdle(2);
            config.setIdleTimeout(30000L);
            config.setMaxLifetime(1800000L);
            config.setConnectionTimeout(10000L);
            config.setPoolName("ZPvPToggle-HikariCP");
            config.addDataSourceProperty("cachePrepStmts", "true");
            config.addDataSourceProperty("prepStmtCacheSize", "250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            config.addDataSourceProperty("useServerPrepStmts", "true");
            config.addDataSourceProperty("useLocalSessionState", "true");
            config.addDataSourceProperty("rewriteBatchedStatements", "true");
            config.addDataSourceProperty("cacheResultSetMetadata", "true");
            config.addDataSourceProperty("cacheServerConfiguration", "true");
            config.addDataSourceProperty("elideSetAutoCommits", "true");
            config.addDataSourceProperty("maintainTimeStats", "false");
            this.dataSource = new HikariDataSource(config);
            Connection connection = this.getConnection();
            if (connection != null) {
                AutoCloseable autoCloseable = connection;
                Throwable throwable = null;
                try {
                    Connection conn = (Connection)autoCloseable;
                    boolean bl = false;
                    this.createTables(conn);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            this.plugin.getLogger().info("MariaDB database connection pool established with HikariCP.");
        }
        catch (ClassNotFoundException e) {
            this.plugin.getLogger().log(Level.SEVERE, "MySQL JDBC driver not found. Please ensure the MySQL connector is installed on your server.", e);
            throw e;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize MariaDB database with HikariCP", e);
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            HikariDataSource hikariDataSource = this.dataSource;
            if (hikariDataSource != null) {
                hikariDataSource.close();
            }
            this.plugin.getLogger().info("MariaDB connection pool closed.");
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error closing MariaDB connection pool", e);
        }
    }

    private final Connection getConnection() {
        HikariDataSource hikariDataSource = this.dataSource;
        return hikariDataSource != null ? hikariDataSource.getConnection() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, Object> loadPlayerData(@NotNull UUID uuid) {
        Map data;
        block8: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            data = new LinkedHashMap();
            String sql = "SELECT indicator_id, can_see_indicators, can_see_own_indicator FROM player_preferences WHERE uuid = ?";
            try {
                AutoCloseable autoCloseable = this.getConnection();
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(sql)) == null) break block8;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    stmt.setString(1, uuid.toString());
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        String indicatorId = rs.getString("indicator_id");
                        boolean canSeeIndicators = rs.getBoolean("can_see_indicators");
                        boolean canSeeOwnIndicator = rs.getBoolean("can_see_own_indicator");
                        Intrinsics.checkNotNull((Object)indicatorId);
                        data.put("indicator_id", indicatorId);
                        Boolean bl2 = canSeeIndicators;
                        data.put("can_see_indicators", bl2);
                        bl2 = canSeeOwnIndicator;
                        data.put("can_see_own_indicator", bl2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error loading player data for " + uuid, e);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerIndicator(@NotNull UUID uuid, @NotNull String indicatorId) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)indicatorId, (String)"indicatorId");
            String sql = "\n            INSERT INTO player_preferences (uuid, indicator_id) \n            VALUES (?, ?) \n            ON DUPLICATE KEY UPDATE indicator_id = ?\n        ";
            try {
                AutoCloseable autoCloseable = this.getConnection();
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(sql)) == null) break block7;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    stmt.setString(1, uuid.toString());
                    stmt.setString(2, indicatorId);
                    stmt.setString(3, indicatorId);
                    Integer n = stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error saving player indicator for " + uuid, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerIndicatorVisibility(@NotNull UUID uuid, boolean canSeeIndicators) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            String sql = "\n            INSERT INTO player_preferences (uuid, can_see_indicators) \n            VALUES (?, ?) \n            ON DUPLICATE KEY UPDATE can_see_indicators = ?\n        ";
            try {
                AutoCloseable autoCloseable = this.getConnection();
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(sql)) == null) break block7;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    stmt.setString(1, uuid.toString());
                    stmt.setBoolean(2, canSeeIndicators);
                    stmt.setBoolean(3, canSeeIndicators);
                    Integer n = stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error saving player indicator visibility for " + uuid, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerOwnIndicatorVisibility(@NotNull UUID uuid, boolean canSeeOwnIndicator) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            String sql = "\n            INSERT INTO player_preferences (uuid, can_see_own_indicator) \n            VALUES (?, ?) \n            ON DUPLICATE KEY UPDATE can_see_own_indicator = ?\n        ";
            try {
                AutoCloseable autoCloseable = this.getConnection();
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(sql)) == null) break block7;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    stmt.setString(1, uuid.toString());
                    stmt.setBoolean(2, canSeeOwnIndicator);
                    stmt.setBoolean(3, canSeeOwnIndicator);
                    Integer n = stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error saving player own indicator visibility for " + uuid, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createTables(Connection connection) {
        String sql = "\n            CREATE TABLE IF NOT EXISTS player_preferences (\n                uuid VARCHAR(36) PRIMARY KEY,\n                indicator_id VARCHAR(50) DEFAULT 'default',\n                can_see_indicators BOOLEAN DEFAULT TRUE,\n                can_see_own_indicator BOOLEAN DEFAULT TRUE\n            )\n        ";
        try {
            AutoCloseable autoCloseable = connection.createStatement();
            Throwable throwable = null;
            try {
                Statement stmt = (Statement)autoCloseable;
                boolean bl = false;
                boolean bl2 = stmt.execute(sql);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error creating tables", e);
        }
    }
}

