/*
 * Decompiled with CFR 0.152.
 */
package zepsizola.me.zPvPToggle.data;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zepsizola.me.zPvPToggle.ZPvPToggle;
import zepsizola.me.zPvPToggle.data.DatabaseManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0016J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0017H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lzepsizola/me/zPvPToggle/data/SQLite;", "Lzepsizola/me/zPvPToggle/data/DatabaseManager;", "plugin", "Lzepsizola/me/zPvPToggle/ZPvPToggle;", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;)V", "connection", "Ljava/sql/Connection;", "dbFile", "Ljava/io/File;", "close", "", "createTables", "initialize", "loadPlayerData", "", "", "", "uuid", "Ljava/util/UUID;", "savePlayerIndicator", "indicatorId", "savePlayerIndicatorVisibility", "canSeeIndicators", "", "savePlayerOwnIndicatorVisibility", "canSeeOwnIndicator", "ZPvPToggle"})
public final class SQLite
implements DatabaseManager {
    @NotNull
    private final ZPvPToggle plugin;
    @Nullable
    private Connection connection;
    @NotNull
    private final File dbFile;

    public SQLite(@NotNull ZPvPToggle plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.dbFile = new File(this.plugin.getDataFolder(), "playerdata.db");
    }

    @Override
    public void initialize() {
        try {
            if (!this.plugin.getDataFolder().exists()) {
                this.plugin.getDataFolder().mkdirs();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.dbFile.getAbsolutePath());
            this.createTables();
            this.plugin.getLogger().info("SQLite database connection established.");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize SQLite database", e);
        }
    }

    @Override
    public void close() {
        try {
            Connection connection = this.connection;
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Error closing SQLite connection", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Map<String, Object> loadPlayerData(@NotNull UUID uuid) {
        Map data;
        block8: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            data = new LinkedHashMap();
            String sql = "SELECT indicator_id, can_see_indicators, can_see_own_indicator FROM player_preferences WHERE uuid = ?";
            try {
                AutoCloseable autoCloseable = this.connection;
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(sql)) == null) break block8;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    stmt.setString(1, uuid.toString());
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) {
                        String indicatorId = rs.getString("indicator_id");
                        boolean canSeeIndicators = rs.getBoolean("can_see_indicators");
                        boolean canSeeOwnIndicator = rs.getBoolean("can_see_own_indicator");
                        Intrinsics.checkNotNull((Object)indicatorId);
                        data.put("indicator_id", indicatorId);
                        Boolean bl2 = canSeeIndicators;
                        data.put("can_see_indicators", bl2);
                        bl2 = canSeeOwnIndicator;
                        data.put("can_see_own_indicator", bl2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error loading player data for " + uuid, e);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerIndicator(@NotNull UUID uuid, @NotNull String indicatorId) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter((Object)indicatorId, (String)"indicatorId");
            String sql = "\n            INSERT INTO player_preferences (uuid, indicator_id) \n            VALUES (?, ?) \n            ON CONFLICT(uuid) DO UPDATE SET indicator_id = ?\n        ";
            try {
                AutoCloseable autoCloseable = this.connection;
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(sql)) == null) break block7;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    stmt.setString(1, uuid.toString());
                    stmt.setString(2, indicatorId);
                    stmt.setString(3, indicatorId);
                    Integer n = stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error saving player indicator for " + uuid, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerIndicatorVisibility(@NotNull UUID uuid, boolean canSeeIndicators) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            String sql = "\n            INSERT INTO player_preferences (uuid, can_see_indicators) \n            VALUES (?, ?) \n            ON CONFLICT(uuid) DO UPDATE SET can_see_indicators = ?\n        ";
            try {
                AutoCloseable autoCloseable = this.connection;
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(sql)) == null) break block7;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    stmt.setString(1, uuid.toString());
                    stmt.setBoolean(2, canSeeIndicators);
                    stmt.setBoolean(3, canSeeIndicators);
                    Integer n = stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error saving player indicator visibility for " + uuid, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void savePlayerOwnIndicatorVisibility(@NotNull UUID uuid, boolean canSeeOwnIndicator) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            String sql = "\n            INSERT INTO player_preferences (uuid, can_see_own_indicator) \n            VALUES (?, ?) \n            ON CONFLICT(uuid) DO UPDATE SET can_see_own_indicator = ?\n        ";
            try {
                AutoCloseable autoCloseable = this.connection;
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement(sql)) == null) break block7;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    stmt.setString(1, uuid.toString());
                    stmt.setBoolean(2, canSeeOwnIndicator);
                    stmt.setBoolean(3, canSeeOwnIndicator);
                    Integer n = stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error saving player own indicator visibility for " + uuid, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createTables() {
        block7: {
            String sql = "\n            CREATE TABLE IF NOT EXISTS player_preferences (\n                uuid TEXT PRIMARY KEY,\n                indicator_id TEXT DEFAULT 'default',\n                can_see_indicators BOOLEAN DEFAULT 1,\n                can_see_own_indicator BOOLEAN DEFAULT 1\n            )\n        ";
            try {
                AutoCloseable autoCloseable = this.connection;
                if (autoCloseable == null || (autoCloseable = autoCloseable.createStatement()) == null) break block7;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    Statement stmt = (Statement)autoCloseable2;
                    boolean bl = false;
                    Boolean bl2 = stmt.execute(sql);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error creating tables", e);
            }
        }
    }
}

