/*
 * Decompiled with CFR 0.152.
 */
package zepsizola.me.zPvPToggle.indicator;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zepsizola.me.zPvPToggle.ZPvPToggle;
import zepsizola.me.zPvPToggle.indicator.ParticleRingManager;
import zepsizola.me.zPvPToggle.indicator.ParticleRingSettings;
import zepsizola.me.zPvPToggle.managers.PlayerState;
import zepsizola.me.zPvPToggle.managers.PvpManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lzepsizola/me/zPvPToggle/indicator/ParticleIndicatorTask;", "", "()V", "indicatorCheckInterval", "", "indicatorCheckIntervalTicks", "ringManager", "Lzepsizola/me/zPvPToggle/indicator/ParticleRingManager;", "task", "Lio/papermc/paper/threadedregions/scheduler/ScheduledTask;", "showParticleRing", "", "player", "Lorg/bukkit/entity/Player;", "observer", "ring", "Lzepsizola/me/zPvPToggle/indicator/ParticleRingSettings;", "plugin", "Lzepsizola/me/zPvPToggle/ZPvPToggle;", "start", "stop", "ZPvPToggle"})
public final class ParticleIndicatorTask {
    @NotNull
    public static final ParticleIndicatorTask INSTANCE = new ParticleIndicatorTask();
    @Nullable
    private static ScheduledTask task;
    private static ParticleRingManager ringManager;
    private static long indicatorCheckInterval;
    private static long indicatorCheckIntervalTicks;

    private ParticleIndicatorTask() {
    }

    public final void start(@NotNull ZPvPToggle plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.stop();
        ringManager = new ParticleRingManager(plugin);
        ParticleRingManager particleRingManager = ringManager;
        if (particleRingManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ringManager");
            particleRingManager = null;
        }
        particleRingManager.loadRings();
        plugin.getPvpManager().initializePvpEnabledCache();
        indicatorCheckIntervalTicks = plugin.getConfig().getLong("particle-indicator.interval-ticks", 5L);
        indicatorCheckInterval = indicatorCheckIntervalTicks * 50L;
        double maxDistance = RangesKt.coerceIn((double)plugin.getConfig().getDouble("particle-indicator.max-view-distance", 32.0), (double)0.0, (double)64.0);
        task = plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)plugin, arg_0 -> ParticleIndicatorTask.start$lambda$1(plugin, maxDistance, arg_0), indicatorCheckInterval, indicatorCheckInterval, TimeUnit.MILLISECONDS);
    }

    public final void stop() {
        ScheduledTask scheduledTask = task;
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
        task = null;
    }

    public final void showParticleRing(@NotNull Player player, @NotNull Player observer, @NotNull ParticleRingSettings ring, @NotNull ZPvPToggle plugin) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter((Object)ring, (String)"ring");
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        Ref.IntRef curr = new Ref.IntRef();
        int end = (int)Math.round((double)indicatorCheckIntervalTicks / (double)((int)ring.getInterval()));
        observer.getScheduler().runAtFixedRate((Plugin)plugin, arg_0 -> ParticleIndicatorTask.showParticleRing$lambda$2(curr, end, player, ring, observer, arg_0), null, ring.getInterval(), ring.getInterval());
    }

    private static final void start$lambda$1$lambda$0(Location $location, double $maxDistance, ZPvPToggle $plugin, Player $pvpPlayer, ParticleRingSettings $ring, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter((Object)$location, (String)"$location");
        Intrinsics.checkNotNullParameter((Object)((Object)$plugin), (String)"$plugin");
        Intrinsics.checkNotNullParameter((Object)$pvpPlayer, (String)"$pvpPlayer");
        Intrinsics.checkNotNullParameter((Object)$ring, (String)"$ring");
        Intrinsics.checkNotNullParameter((Object)scheduledTask, (String)"<anonymous parameter 0>");
        for (Player observer : $location.getNearbyPlayers($maxDistance)) {
            PvpManager pvpManager = $plugin.getPvpManager();
            Intrinsics.checkNotNull((Object)observer);
            PlayerState observerState = pvpManager.getState(observer);
            if (!observerState.getCanSeeIndicators() || Intrinsics.areEqual((Object)observer, (Object)$pvpPlayer) && !observerState.getCanSeeOwnIndicator()) continue;
            INSTANCE.showParticleRing($pvpPlayer, observer, $ring, $plugin);
        }
    }

    private static final void start$lambda$1(ZPvPToggle $plugin, double $maxDistance, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter((Object)((Object)$plugin), (String)"$plugin");
        Intrinsics.checkNotNullParameter((Object)scheduledTask, (String)"<anonymous parameter 0>");
        Collection<Player> pvpEnabledPlayers = $plugin.getPvpManager().getPvpEnabledPlayers();
        block0: for (Player pvpPlayer : pvpEnabledPlayers) {
            Location location;
            if (!pvpPlayer.isValid() || !pvpPlayer.isOnline() || pvpPlayer.getGameMode() == GameMode.SPECTATOR) continue;
            String[] stringArray = new String[]{"vanished", "isVanished", "vanish"};
            List vanishKeys = CollectionsKt.listOf((Object[])stringArray);
            for (String key : vanishKeys) {
                List list = pvpPlayer.getMetadata(key);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMetadata(...)");
                MetadataValue metadataValue = (MetadataValue)CollectionsKt.firstOrNull((List)list);
                boolean isVanished = metadataValue != null ? metadataValue.asBoolean() : false;
                if (!isVanished) continue;
                continue block0;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pvpPlayer.getLocation(), (String)"getLocation(...)");
            PlayerState playerState = $plugin.getPvpManager().getState(pvpPlayer);
            ParticleRingManager particleRingManager = ringManager;
            if (particleRingManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ringManager");
                particleRingManager = null;
            }
            ParticleRingSettings ring = particleRingManager.getRing(playerState.getIndicatorRingId());
            $plugin.getServer().getRegionScheduler().run((Plugin)$plugin, location, arg_0 -> ParticleIndicatorTask.start$lambda$1$lambda$0(location, $maxDistance, $plugin, pvpPlayer, ring, arg_0));
        }
    }

    private static final void showParticleRing$lambda$2(Ref.IntRef $curr, int $end, Player $player, ParticleRingSettings $ring, Player $observer, ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter((Object)$curr, (String)"$curr");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)$ring, (String)"$ring");
        Intrinsics.checkNotNullParameter((Object)$observer, (String)"$observer");
        Intrinsics.checkNotNullParameter((Object)scheduledTask, (String)"<anonymous parameter 0>");
        if ($curr.element >= $end) {
            return;
        }
        int n = $curr.element;
        $curr.element = n + 1;
        Location location = $player.getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
        Location location2 = location;
        Location location3 = location2.clone().add(0.0, $ring.getYOffset(), 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"add(...)");
        Location center = location3;
        int n2 = $ring.getPoints();
        for (int i = 0; i < n2; ++i) {
            Location particleLoc;
            double angle = !$ring.getRandomParticlePositions() ? Math.PI * 2 * (double)i / (double)$ring.getPoints() : Random.Default.nextDouble(0.0, Math.PI * 2);
            double x = $ring.getRadius() * Math.cos(angle);
            double z = $ring.getRadius() * Math.sin(angle);
            Intrinsics.checkNotNullExpressionValue((Object)center.clone().add(x, 0.0, z), (String)"add(...)");
            Particle particle = $ring.getType();
            double d = $ring.getRandomOffsetHoriz();
            double d2 = $ring.getRandomOffsetVert();
            double d3 = $ring.getRandomOffsetHoriz();
            double d4 = $ring.getSpeed();
            Object object = $ring.getExtra();
            if (object == null) {
                object = null;
            }
            $observer.spawnParticle(particle, particleLoc, 1, d, d2, d3, d4, object);
        }
    }

    static {
        indicatorCheckInterval = 1000L;
        indicatorCheckIntervalTicks = 20L;
    }
}

